#include <amxmodx>
#include <amxmisc>
#include <regex>

// Preprocessor macros (Config)
#define PLAYER_NEWNAME			"Jatekos"
#define IN_GAME_WARNING_MSG		"Figyelmeztetes! Ne hirdess, semmifele szerveren"
#define KICKORBAN_NICK_REASON	"Nev spam!"
#define KICKORBAN_CHAT_REASON	"Chat spam!"
#define NICK_CHANGED_INFO		"Neved megvaltozott! Ne valtoztasd vissza a neved"
#define MSG_BLOCK_INFO			"Hirdetes van a nevedben, Kerlek ne hirdess semmilyen oldalt/szervert"

stock g_newname_num = 1
new cvar_action_spam_chat, cvar_action_spam_nick, cvar_ban_time

public plugin_init()
{
	register_plugin("Anti-Spam Lite", "1.0.5", "NullWarez")
	register_clcmd("say","check_player_msg")
	register_clcmd("say_team","check_player_msg")

	cvar_action_spam_chat 	= register_cvar("antispam_l_action_chat", "1");
	cvar_action_spam_nick 	= register_cvar("antispam_l_action_nick", "1");
	cvar_ban_time 			= register_cvar("antispam_l_bantime", "200");
}

// Check the nick when connecting
public client_connect(id)
{
	if(is_user_admin(id))
		return PLUGIN_CONTINUE

	new g_name[32]
	get_user_name(id, g_name,31)

	if(is_invalid(g_name))
	{
		spam_nick_action(id)
		return PLUGIN_HANDLED
	}
	set_task(20.0, "showWarning", id)
	return PLUGIN_CONTINUE
}

// Checks the message for spam
bool:is_invalid(const text[])
{
	new error[50], num
	new Regex:regex = regex_match (text, "[a-z0-9-]{3,}\.[a-z]{1,2}(\S)", num, error, 49, "i")
	if(regex >= REGEX_OK)
	{
		regex_free(regex)
		return true
	}

	regex = regex_match(text, "([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}", num, error, 49)
	if(regex >= REGEX_OK)
    {
		regex_free(regex)
		return true
	}

	return false
}

// Displays a warning ban for spam
public showWarning(id)
{
	if(is_user_connected(id))
		client_print(id, print_chat, "IN_GAME_WARNING_MSG")
}

// Check say or say_team message
public check_player_msg(id)
{
	if(is_user_admin(id))
		return PLUGIN_CONTINUE

	new text[128]
	read_args(text,127)
	if(is_invalid(text))
	{
		spam_chat_action(id)
		return PLUGIN_HANDLED
    }
	return PLUGIN_CONTINUE
}

// Called when set name
public client_infochanged(id)
{
	if(is_user_admin(id))
		return PLUGIN_CONTINUE

	if(!is_user_alive(id)) // loop fix
		return PLUGIN_CONTINUE

	new g_name[32]
	get_user_name(id, g_name,31)

	if(is_invalid(g_name))
	{
		spam_nick_action(id)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public spam_nick_action(id)
{
	switch (get_pcvar_num(cvar_action_spam_nick))
	{
		// Change nick name and show hud info
		case 1:
		{
			show_nick_changed_hud(id)
		}
		// kick player
		case 2:
		{
			kick_player(id, 1)
		}
		// ban player
		case 3:
		{
			ban_player(id, 1)
		}
	}
}

public spam_chat_action(id)
{
	switch (get_pcvar_num(cvar_action_spam_chat))
	{
		// block message and show info
		case 1:
		{
			client_print(id, print_chat, "MSG_BLOCK_INFO")
		}
		// block message and kick player
		case 2:
		{
			kick_player(id)
		}
		// block message and ban player
		case 3:
		{
			ban_player(id)
		}
	}
}

stock show_nick_changed_hud(id)
{
	server_cmd("amx_nick #%d ^"PLAYER_NEWNAME-%d^"", get_user_userid(id), g_newname_num);
	g_newname_num++
	set_hudmessage (200, 0, 0, -1.0, 0.35, 1, 0.0, 5.0, 1.0, 1.0, 1)
	show_hudmessage(id, "NICK_CHANGED_INFO")
}

stock kick_player(id, type = 0)
{
	if(type)
		server_cmd("kick #%d KICKORBAN_NICK_REASON", get_user_userid(id))
		
	server_cmd("kick #%d KICKORBAN_CHAT_REASON", get_user_userid(id))
}

stock ban_player(id, type = 0)
{
	if(type)
		server_cmd("amx_ban %d #%d KICKORBAN_NICK_REASON", get_pcvar_num(cvar_ban_time), get_user_userid(id))
		
	server_cmd("amx_ban %d #%d KICKORBAN_CHAT_REASON", get_pcvar_num(cvar_ban_time), get_user_userid(id))
}
