#include <amxmodx>
#include <amxmisc>
#include <regex>

// Preprocessor macros (Config)
#define BAN_TIME 			200
#define BAN_NICK_REASON 	"Spam miatt kickelve!"
#define BAN_MSG_REASON 		"Spam uzenet!"
#define IN_GAME_WARNING_MSG	"Figyelmeztetes! Ne hirdess, semmifele szerveren"

public plugin_init()
{
	register_plugin("Anti-Spam Lite", "1.0.4", "NullWarez")
	register_clcmd("say","check_player_msg")
	register_clcmd("say_team","check_player_msg")
}

// Check the nick when connecting
public client_connect(id)
{
	if(is_user_admin(id))
		return PLUGIN_CONTINUE

	new g_name[32]
	get_user_name(id, g_name,31)

	if(is_invalid(g_name))
	{
		server_cmd("amx_ban BAN_TIME #%d BAN_NICK_REASON", get_user_userid(id))
		return PLUGIN_CONTINUE
	}
	set_task(20.0, "showWarning", id)
	return PLUGIN_CONTINUE
}

// Checks the message for spam
bool:is_invalid(const text[])
{
	new error[50], num
	new Regex:regex = regex_match (text, "[a-z0-9-]{3,}\.[a-z]{1,2}(\S)", num, error, 49, "i")
	if(regex >= REGEX_OK)
	{
		regex_free(regex)
		return true
	}

	regex = regex_match(text, "([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}", num, error, 49)
	if(regex >= REGEX_OK)
    {
		regex_free(regex)
		return true
	}

	return false
}

// Displays a warning ban for spam
public showWarning(id)
{
	if(is_user_connected(id))
		client_print(id, print_chat, "IN_GAME_WARNING_MSG")
}

// Check say or say_team message
public check_player_msg(id)
{
	if(is_user_admin(id))
		return PLUGIN_CONTINUE

	new text[128]
	read_args(text,127)
	if(is_invalid(text))
	{
		server_cmd("amx_ban BAN_TIME #%d BAN_MSG_REASON", get_user_userid(id))
		return PLUGIN_HANDLED
    }
	return PLUGIN_CONTINUE
}

// Called when set name
public client_infochanged(id)
{
	if(is_user_admin(id))
		return PLUGIN_CONTINUE

	if(!is_user_alive(id)) // loop fix
		return PLUGIN_CONTINUE

	new g_name[32]
	get_user_name(id, g_name,31)

	if(is_invalid(g_name))
	{
		server_cmd("amx_ban BAN_TIME #%d BAN_NICK_REASON", get_user_userid(id))
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}
