#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <colorchat>

#define PLUGIN_NAME		"LoL Kill Sounds"
#define PLUGIN_VERSION	"v1.1"
#define PLUGIN_AUTHOR	"KISKE"

enum _:Teams {
	FM_CS_TEAM_UNASSIGNED = 0,
	FM_CS_TEAM_T,
	FM_CS_TEAM_CT,
	FM_CS_TEAM_SPECTATOR
};

new const LOL_SOUNDS[][] = {
	"sound/lol_sounds/double_kill.mp3",
	"sound/lol_sounds/triple_kill.mp3",
	"sound/lol_sounds/quadra_kill.mp3",
	"sound/lol_sounds/penta_kill.mp3"
}

new const E_LOL_SOUNDS[][] = {
	"sound/lol_sounds/e_double_kill.mp3",
	"sound/lol_sounds/e_triple_kill.mp3",
	"sound/lol_sounds/e_quadra_kill.mp3",
	"sound/lol_sounds/e_penta_kill.mp3"
}

new const LOL_MESSAGE[][] = {
	"LOL_MSG_DOUBLE_KILL",
	"LOL_MSG_TRIPLE_KILL",
	"LOL_MSG_QUADRA_KILL",
	"LOL_MSG_PENTA_KILL"
}

#define TASK_SOUND	957121

#define is_user_valid_connected(%1) 	(1 <= %1 <= g_MaxPlayers && is_user_connected(%1))

new g_Kills[33];

new g_MaxPlayers;
new g_KillerId = 0;

new g_pCVAR_ResetKills;

new g_pCVAR_TimeBet_FirstDouble;
new g_pCVAR_TimeBet_DoubleTriple;
new g_pCVAR_TimeBet_TripleQuadra;
new g_pCVAR_TimeBet_QuadraPenta;

new g_pCVAR_OnlyVictimListen;
new g_pCVAR_OnlyKillerListen;

new g_pCVAR_ShowMessage;

new Float:g_TimeBet_FirstDouble;
new Float:g_TimeBet_DoubleTriple;
new Float:g_TimeBet_TripleQuadra;
new Float:g_TimeBet_QuadraPenta;

new g_ShowMessage;

public plugin_precache()
{
	new i;
	for(i = 0; i < 4; ++i)
	{
		precache_generic(LOL_SOUNDS[i]);
		precache_generic(E_LOL_SOUNDS[i]);
	}
}

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR);
	
	register_dictionary("lol_sounds.txt");
	
	register_event("HLTV", "event_HLTV", "a", "1=0", "2=0");
	
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled");
	
	g_pCVAR_ResetKills = register_cvar("lol_reset_kills_with_penta", "1"); // Kills reset when you do a penta kill ? [0=NO || 1=YES]
	
	g_pCVAR_TimeBet_FirstDouble = register_cvar("lol_time_between_first_and_double", "7.0"); // Time to make a double kill after first
	g_pCVAR_TimeBet_DoubleTriple = register_cvar("lol_time_between_double_and_triple", "7.0"); // Time to make a triple kill after double kill
	g_pCVAR_TimeBet_TripleQuadra = register_cvar("lol_time_between_triple_and_quadra", "7.0"); // Time to make a quadra kill after triple kill
	g_pCVAR_TimeBet_QuadraPenta = register_cvar("lol_time_between_quadra_and_penta", "15.0"); // Time to make a penta kill after quadra kill
	
	g_pCVAR_OnlyVictimListen = register_cvar("lol_only_victim_listen", "0"); // Only the victim listen "enemy double/triple/quadra/penta kill" sounds? [0=NO (ALL THE ENEMY TEAM LISTEN) || 1=YES]
	g_pCVAR_OnlyKillerListen = register_cvar("lol_only_killer_listen", "0"); // Only the killer listen "double/triple/quadra/penta kill" sounds? [0=NO (ALL THE TEAM LISTEN) || 1=YES]
	
	g_pCVAR_ShowMessage = register_cvar("lol_show_message_in_chat", "1"); // Show message in chat? [0=NO || 1=YES]
	
	g_MaxPlayers = get_maxplayers();
}

public event_HLTV()
{
	g_TimeBet_FirstDouble = get_pcvar_float(g_pCVAR_TimeBet_FirstDouble);
	g_TimeBet_DoubleTriple = get_pcvar_float(g_pCVAR_TimeBet_DoubleTriple);
	g_TimeBet_TripleQuadra = get_pcvar_float(g_pCVAR_TimeBet_TripleQuadra);
	g_TimeBet_QuadraPenta = get_pcvar_float(g_pCVAR_TimeBet_QuadraPenta);
	
	g_ShowMessage = get_pcvar_num(g_pCVAR_ShowMessage);
}

public client_putinserver(id)
{
	g_Kills[id] = 0;
}

public fw_PlayerKilled(const victim, const killer, const shouldgib)
{
	if(victim == killer || !is_user_valid_connected(killer))
		return;
	
	if(g_KillerId != killer)
	{
		g_Kills[g_KillerId] = 0;
		g_KillerId = killer;
	}
	
	++g_Kills[killer];
	
	remove_task(TASK_SOUND);
	
	switch(g_Kills[killer])
	{
		case 1: set_task(g_TimeBet_FirstDouble, "removeSound", TASK_SOUND);
		case 2: set_task(g_TimeBet_DoubleTriple, "removeSound", TASK_SOUND);
		case 3: set_task(g_TimeBet_TripleQuadra, "removeSound", TASK_SOUND);
		case 4: set_task(g_TimeBet_QuadraPenta, "removeSound", TASK_SOUND);
	}
	
	if(g_Kills[killer] > 1 && g_Kills[killer] < 6)
	{
		if(g_ShowMessage)
		{
			new sKillerName[32];
			new sVictimName[32];
			
			get_user_name(killer, sKillerName, 31)
			get_user_name(victim, sVictimName, 31)
			
			colorChat(0, (getUserTeam(killer) == FM_CS_TEAM_T) ? CT : TERRORIST, "%L", LANG_SERVER, LOL_MESSAGE[g_Kills[killer] - 2], sKillerName, sVictimName);
		}
		
		if(!get_pcvar_num(g_pCVAR_OnlyVictimListen) && !get_pcvar_num(g_pCVAR_OnlyKillerListen))
			playSound(0);
		else if(get_pcvar_num(g_pCVAR_OnlyVictimListen) && !get_pcvar_num(g_pCVAR_OnlyKillerListen))
			playSound(1);
		else if(!get_pcvar_num(g_pCVAR_OnlyVictimListen) && get_pcvar_num(g_pCVAR_OnlyKillerListen))
			playSound(2);
		
		if(get_pcvar_num(g_pCVAR_OnlyVictimListen))
			client_cmd(victim, "mp3 play ^"%s^"", E_LOL_SOUNDS[g_Kills[killer] - 2])
		
		if(get_pcvar_num(g_pCVAR_OnlyKillerListen))
			client_cmd(killer, "mp3 play ^"%s^"", LOL_SOUNDS[g_Kills[killer] - 2])
	}
	
	if(g_Kills[killer] == 5 && get_pcvar_num(g_pCVAR_ResetKills))
		g_Kills[killer] = 0;
}

public removeSound()
{
	g_Kills[g_KillerId] = 0;
	g_KillerId = 0;
}

playSound(const who)
{
	new iUsers[32];
	new iNum;
	new iUser;
	new i;
	
	switch(who)
	{
		case 0: // BOTH TEAMS LISTEN THE SOUNDS
		{
			get_players(iUsers, iNum, "ac");
			
			new iKillerTeam;
			new iTeam;
			
			iKillerTeam = getUserTeam(g_KillerId);
			
			for(i = 0; i < iNum; i++)
			{
				iUser = iUsers[i]
				
				iTeam = getUserTeam(iUser);
				
				if(iTeam == iKillerTeam)
					client_cmd(iUser, "mp3 play ^"%s^"", LOL_SOUNDS[g_Kills[g_KillerId] - 2])
				else if(iTeam != FM_CS_TEAM_UNASSIGNED && iTeam != FM_CS_TEAM_SPECTATOR)
					client_cmd(iUser, "mp3 play ^"%s^"", E_LOL_SOUNDS[g_Kills[g_KillerId] - 2])
			}
		}
		case 1: // ONLY KILLER TEAM LISTEN THE SOUNDS
		{
			if(getUserTeam(g_KillerId) == FM_CS_TEAM_T)
				get_players(iUsers, iNum, "ace", "TERRORIST");
			else
				get_players(iUsers, iNum, "ace", "CT");
				
			for(i = 0; i < iNum; i++)
			{
				iUser = iUsers[i]
				client_cmd(iUser, "mp3 play ^"%s^"", LOL_SOUNDS[g_Kills[g_KillerId] - 2])
			}
		}
		case 2: // ONLY VICTIM TEAM LISTEN THE SOUNDS
		{
			if(getUserTeam(g_KillerId) == FM_CS_TEAM_T)
				get_players(iUsers, iNum, "ace", "CT");
			else
				get_players(iUsers, iNum, "ace", "TERRORIST");
				
			for(i = 0; i < iNum; i++)
			{
				iUser = iUsers[i]
				client_cmd(iUser, "mp3 play ^"%s^"", LOL_SOUNDS[g_Kills[g_KillerId] - 2])
			}
		}
	}
}

stock getUserTeam(const id) // FROM ZP
{
	if(pev_valid(id) != 2)
		return FM_CS_TEAM_UNASSIGNED;
	
	return get_pdata_int(id, 114, 5);
}