﻿#include <amxmodx>
#include <amxmisc>
#include <colorchat>
#include <cstrike>
#include <fakemeta>
#include <hamsandwich>
#include <xs>

#pragma semicolon 1

#define PLUGIN "Zeus X27 Taser"
#define VERSION "1.0.0"
#define AUTHOR "Akosch:."

#define is_user_valid(%0)		(1 <= %0 <= 32)
#define get_user_has_weapon(%0,%1)	(get_user_weapon(%0) == %1)
#define SLOT 32

new bool:g_bZeus[SLOT + 1], bool:g_bAttacking[SLOT + 1], g_pCvar[7], g_pSpriteModel;

stock const g_sServerPrefix[] = {"[Információ]"};
stock const g_sWeaponModel[] = {"models/v_zeus.mdl"};

stock const g_sDefaultSounds[][] =
{
	{"weapons/knife_deploy1.wav"},
	{"weapons/knife_hit1.wav"},
	{"weapons/knife_hit2.wav"},
	{"weapons/knife_hit3.wav"},
	{"weapons/knife_hit4.wav"},
	{"weapons/knife_hitwall1.wav"},
	{"weapons/knife_slash1.wav"},
	{"weapons/knife_slash2.wav"},
	{"weapons/knife_stab.wav"}
};

stock const g_sZeusSounds[][] =
{
	{"weapons/zeus_deploy1.wav"},
	{"weapons/zeus_hit1.wav"},
	{"weapons/zeus_hit2.wav"},
	{"weapons/zeus_hit3.wav"},
	{"weapons/zeus_hit4.wav"},
	{"weapons/zeus_hitwall1.wav"},
	{"weapons/zeus_slash1.wav"},
	{"weapons/zeus_slash2.wav"},
	{"weapons/zeus_stab.wav"}
};

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);

	register_forward(FM_EmitSound, "fwdEmitSound", 0);
	register_forward(FM_TraceLine, "fwdTraceLine", 0);
	register_forward(FM_TraceHull, "fwdTraceHull", 1);

	RegisterHam(Ham_Killed, "player", "fwdDeathPost", 1);
	RegisterHam(Ham_TakeDamage, "player", "fwdDamagePre", 0);
	RegisterHam(Ham_TakeDamage, "player", "fwdDamagePost", 1);
	RegisterHam(Ham_Item_Deploy, "weapon_knife", "fwdWeaponSwitchPost", 1);
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_knife", "fwdWpnPrimAttackPost", 1);
	RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_knife", "fwdWpnSecAttackPost", 1);

	register_clcmd("say /zeus", "fnBuyZeus", ADMIN_ALL);
	
	register_message(get_user_msgid("DeathMsg"), "msgDeath");

	g_pCvar[0] = register_cvar("Zeus_Prise", "750");
	g_pCvar[1] = register_cvar("Zeus_Distance", "3.0");
	g_pCvar[2] = register_cvar("Zeus_Beam_Width", "100");
	g_pCvar[3] = register_cvar("Zeus_Beam_Red", "120");
	g_pCvar[4] = register_cvar("Zeus_Beam_Green", "240");
	g_pCvar[5] = register_cvar("Zeus_Beam_Blue", "180");
	g_pCvar[6] = register_cvar("Zeus_Beam_Alpha", "100");
}

public plugin_precache()
{
	precache_model(g_sWeaponModel);
	
	g_pSpriteModel = precache_model("sprites/lightning.spr");
	
	for(new i; i < sizeof(g_sZeusSounds); i++)
		precache_sound(g_sZeusSounds[i]);
}

public client_connect(id)
	g_bZeus[id] = false;

public client_disconnect(id)
	g_bZeus[id] = false;

public fwdDeathPost(iVictim, iKiller)
	g_bZeus[iVictim] = false;

public fnBuyZeus(id)
{
	new iPrise = get_pcvar_num(g_pCvar[0]);
	
	if(!is_user_alive(id))
	{
		ColorChat(id, GREEN, "%s ^1Csak élők tudnak ^3Zeus x27 Taser ^1-t venni^4!", g_sServerPrefix);
		return;
	}
	else if(!cs_get_user_buyzone(id))
	{
		ColorChat(id, GREEN, "%s ^1Csak a vásárló zónában tudsz vásárolni^4!", g_sServerPrefix);
		return;
	}
	else if(g_bZeus[id])
	{
		ColorChat(id, GREEN, "%s ^1Neked már van egy ^3Zeus x27 Taser ^1-d^4!", g_sServerPrefix);
		return;
	}
	else if(cs_get_user_money(id) < iPrise)
	{
		ColorChat(id, GREEN, "%s ^1Nincs elég pénzed megvenni^4!", g_sServerPrefix);
		return;
	}
	else
	{
		g_bZeus[id] = true;
		cs_set_user_money(id, cs_get_user_money(id) - iPrise);
		ColorChat(id, GREEN, "%s ^1Sikeresen vettél egy ^3Zeus x27 Taser ^1-t^4!", g_sServerPrefix);
	}
}

public fwdWeaponSwitchPost(iWeapon)
{
	new id = pev(iWeapon, pev_owner);

	if(!is_user_valid(id) || !is_user_alive(id))
		return HAM_SUPERCEDE;

	if(g_bZeus[id])
	{
		set_pev(id, pev_viewmodel2, g_sWeaponModel);
		
		return HAM_SUPERCEDE;
	}
	
	return HAM_IGNORED;
}

public fwdDamagePre(iVictim, iInflictor, iAttacker, Float:fDamage)
	if(get_user_has_weapon(iAttacker, CSW_KNIFE) && g_bZeus[iAttacker])
	{
		new Float:fVicOrigin[3], Float:fAttOrigin[3], Float:fNewDmg;

		g_bAttacking[iVictim] = true;

		pev(iVictim, pev_origin, fVicOrigin);
		pev(iAttacker, pev_origin, fAttOrigin);

		(200.0 - get_distance_f(fVicOrigin, fAttOrigin)) > 0.0 ? (fNewDmg = 200.0 - get_distance_f(fVicOrigin, fAttOrigin)) : (fNewDmg = 1.0);

		SetHamParamFloat(4, fNewDmg);

		new iWidth, iRed, iGreen, iBlue, iAlpha;

		iWidth = get_pcvar_num(g_pCvar[2]);
		iRed = get_pcvar_num(g_pCvar[3]);
		iGreen = get_pcvar_num(g_pCvar[4]);
		iBlue = get_pcvar_num(g_pCvar[5]);
		iAlpha = get_pcvar_num(g_pCvar[6]);

		Create_Te_Beaments(iAttacker, iVictim, g_pSpriteModel, 0, 10, 4, iWidth, 5, iRed, iGreen, iBlue, iAlpha, 15);
	}

public fwdDamagePost(iVictim, iInflictor, iAttacker, Float:fDamage)
	if(is_user_alive(iVictim))
		g_bAttacking[iVictim] = false;

public fwdEmitSound(id, iChannel, const sSound[])
{
	if(!is_user_valid(id) || !is_user_alive(id) || (iChannel != 1 && iChannel != 3))
		return FMRES_IGNORED;

	if(!g_bZeus[id])
		return FMRES_IGNORED;

	static i;
	for(i = 0; i <= sizeof(g_sDefaultSounds); i++)
	{
		if(equali(g_sDefaultSounds[i], sSound))
		{
			engfunc(EngFunc_EmitSound, id, CHAN_WEAPON, g_sZeusSounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM);
			
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED;
}

public fwdWpnPrimAttackPost(iWeapon)
	fnWeapon_Attack(iWeapon);

public fwdWpnSecAttackPost(iWeapon)
	fnWeapon_Attack(iWeapon);

fnWeapon_Attack(iWeapon)
{
	if(!pev_valid(iWeapon))
		return;
	
	static id;
	id = pev(iWeapon, pev_owner);
	
	if(!is_user_valid(id))
		return;
	
	if(get_user_has_weapon(id, CSW_KNIFE) && g_bZeus[id])
		g_bZeus[id] = false;
}

public fwdTraceLine(Float:fStart[3], Float:fEnd[3], conditions, id, ptr)
	return fnTrace(id, ptr,fStart,fEnd,conditions);

public fwdTraceHull(Float:fStart[3], Float:fEnd[3], conditions, hull, id, ptr)
	return fnTrace(id, ptr,fStart,fEnd,conditions,true,hull);

fnTrace(id, ptr, Float:fStart[3], Float:fEnd[3],iNoMonsters, bool:hull = false, iHull = 0)
{
	if(is_user_alive(id) && get_user_has_weapon(id, CSW_KNIFE) && g_bZeus[id])
	{		
		xs_vec_sub(fEnd,fStart,fEnd);
		xs_vec_mul_scalar(fEnd,get_pcvar_float(g_pCvar[1]),fEnd);
		xs_vec_add(fEnd,fStart,fEnd);

		hull ? engfunc(EngFunc_TraceHull,fStart,fEnd,iNoMonsters,iHull,id,ptr) : engfunc(EngFunc_TraceLine,fStart,fEnd,iNoMonsters, id,ptr);
	}
	
	return FMRES_IGNORED;
}

public msgDeath(iMsgId, sMsgDest, id)
{
	new sWeapon[32], iVictim;

	get_msg_arg_string(4, sWeapon, charsmax(sWeapon));

	iVictim = get_msg_arg_int(2);

	if(equal(sWeapon, "knife")  && g_bAttacking[iVictim])
		set_msg_arg_string(4, "zeus x27 taser");

	return PLUGIN_CONTINUE;
}

stock Create_Te_Beaments(iStartEnt, iEndEnt, iSprite, iStartFrame, iFrameRate, iLife, iWidth, iNoise, iRed, iGreen, iBlue, iAlpha, iSpeed)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_BEAMENTS);
	write_short(iStartEnt);
	write_short(iEndEnt);
	write_short(iSprite);
	write_byte(iStartFrame);
	write_byte(iFrameRate);
	write_byte(iLife);
	write_byte(iWidth);
	write_byte(iNoise);
	write_byte(iRed);
	write_byte(iGreen);
	write_byte(iBlue);
	write_byte(iAlpha);
	write_byte(iSpeed);
	message_end();
}