#include <amxmodx>

#define PLUGIN	"Simple RoundEndSounds"
#define VERSION	"1.1"
#define AUTHOR	"mforce"


#define MAX_MUSIC 32
new const PREFIX[] = "RoundEndSounds"

new musics[MAX_MUSIC][64], music_count, play_count, bool:musicon[33];

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_clcmd("say /korvegi", "music_on")
	register_event("SendAudio", "PlayMusic", "a", "2&%!MRAD_ctwin")
	register_event("SendAudio", "PlayMusic", "a", "2&%!MRAD_terwin")
}

public plugin_precache() {
	new sBuffer[192], sFile[128], sData[64], pFile;
	get_localinfo("amxx_configsdir", sFile, charsmax(sFile));
	format(sFile, charsmax(sFile), "%s/korvegi_zene.ini", sFile);

	pFile = fopen(sFile, "rt");

	if(pFile) {		
		while(music_count < MAX_MUSIC && !feof(pFile)) {
			fgets(pFile, sBuffer, charsmax(sBuffer));
			trim(sBuffer);
			if(sBuffer[0] != ';' && parse(sBuffer, sData, charsmax(sData))) {
				if(contain(sData, ".mp3") != -1) {
					precache_sound(sData)
					copy(musics[music_count++], charsmax(musics[]), sData)
				}
			}
		}
		fclose(pFile);
	}
	else
		write_file(sFile, ";^"mappa/valami.mp3^"");

	if(!music_count) set_fail_state("Nem talaltunk zeneket! Ellenorizd a fajlt ^"addons/amxmodx/configs/korvegi_zene.ini^"");
}

public music_on(id) {
	switch(musicon[id]) {
		case true: {
			ChatColor(id, "^4[%s]^1 Kikapcsoltad a körvégi zenéket.", PREFIX)
			musicon[id] = false;
			client_cmd(id, "setinfo korvegi 0")
		}
		case false: {
			ChatColor(id, "^4[%s]^1 Bekapcsoltad a körvégi zenéket.", PREFIX)
			musicon[id] = true;
			client_cmd(id, "setinfo korvegi 1")
		}
	}
}

public client_putinserver(id) {
	if(user_roundmusic(id)) {
		musicon[id] = true;
	}
}

public client_disconnect(id) {
	musicon[id] = false;
}

public PlayMusic() {
	new Mp3File[128], players[32], num, tempid;
	formatex(Mp3File, charsmax(Mp3File), "sound/%s", musics[play_count == music_count ? (play_count = 0) : play_count++]);
	get_players(players, num, "c");
	for(new i; i < num; i++) {
		tempid = players[i];
		if(musicon[tempid]) {
			client_cmd(tempid, "mp3 play %s", Mp3File);
		}
	}
}

stock bool:user_roundmusic(id) {
	new azonosit[8];
	get_user_info(id, "korvegi", azonosit, charsmax(azonosit));
	if(equal(azonosit, "0")) return false;
	return true;
}

stock ChatColor(const id, const szMessage[], any:...) {
	static pnum, players[32], szMsg[190], IdMsg; 
	vformat(szMsg, charsmax(szMsg), szMessage, 3);
	
	if(!IdMsg) IdMsg = get_user_msgid("SayText");
	
	if(id) { 
		if(!is_user_connected(id)) return;
		players[0] = id;
		pnum = 1; 
	} 
	else get_players(players, pnum, "ch");
	
	for(new i; i < pnum; i++) {
		message_begin(MSG_ONE, IdMsg, .player = players[i]);
		write_byte(players[i]);
		write_string(szMsg);
		message_end();
	}
}