/* Header generated by AMXX-Studio*/

#if defined _KnifeSystem_included
	#endinput
#endif
#define _KnifeSystem_included

enum _:eKnifeDatas
{
	sName,
	sVModel, 
	sPModel,
	fSpeed,
	fGravity,
	fDamage,
	iKnockback,
	iHealth,
	iVisibly,
	iLevel
}

enum _:ePlayerInfo
{
	iPlayerLvl,
	iPlayerXp,
	iPlayerPoints,
	iPlayerSelected,
	iPlayerSteamId[ 32 ]
};

/**
Visszatr a maximum elrhet szinttel.

	@return		A maximum elrhet szint.

*/
native ks_get_max_level( );

/**
Informcikat kr le az adott azonostj jtkosrl.
Plda: ks_get_player_info( 3, iPlayerLvl )
	- lekri a 3-as azonostj jtkos szintjt.

	@param iPlayerId	A jtkos azonost.
	@param iPlayerInfo	Az inf amit le akarunk krni. ( Lsd: enum iPlayerInfo )
	
	@return			Az inf rtke.

*/
native ks_get_player_info( iPlayerId, iPlayerInfo );

/**
Lekri az adott id -j ksrl az adott inft ( lsd: eKnifeDatas )
Stringnl szksges megadni a tmbt amiben trolni akarjuk.
Plda: ks_get_knife_info( sName, 5, sArray );
	- lekri az 5 -s id-j ks nevt az sArray vltozba.
	
	@param iKnifeInfo	A lekrni kvnt ks inf. ( Lsd: eKnifeDatas )
	@param iKnifeId		A ks azonostja
	@param ...		Ha karakterlncot krnnk le ( 's' -el kezddik ), akkor
					a tmb amibe le akarjuk krni s a mrete.
	
	@return			Lebegpontos s intiger rtk esetn az info rtke,
					karakterlncnl pedig 1
*/
native ks_get_knife_info( iKnifeInfo, iKnifeId, any:... );

/**
Leregisztl egy rut a boltba.
Plda: ks_register_item( "Extralet", "fnletMegvve", 350 )
	- Leregisztrl egy rut, "Extralet" nven, ami 350 pontba kerl, s ha megveszi vki,
	  akkor az "fnletMegvve" fggvny fog meghvdni.
	  public fnletMegvve( iVasarloId )

	  
	@param sItemName	ru neve.
	@param sItemFunction	ruhoz kapcsolt fggvny.
	@param iCost		ru ra.
	
	@return			Az ru id-je.
*/
native ks_register_item( const sItemName[ ], const sItemFunction[ ], iCost );

/**
Szintlpsekkor hvdik meg.

	@param iPlayerId	A szintet lp jtkos azonostjt adja t.
	@param iPlayerNewLvl	A szintet lp jtkos j szintjt adja t.

	@note			Figyelmen kvl hagyja a visszatrsi rtket.
*/
forward ks_level_up( iPlayerId, iPlayerNewLvl );

/**
Meghvdik miutn elrte egy jtkos a maximum szintet.

	@param iPlayerId	A maximum szintet elr jtkos azonostjt adja t.

	@note			Figyelmen kvl hagyja a visszatrsi rtket.
*/
forward ks_max_lvl_reached( iPlayerId );

/**
Meghvdik miutn a jtkos sikeresen kivlasztott egy kst.

	@param iPlayerId	A kst kivlaszt jtkos azonostja.
	@param iKnifeId		A kivlasztott ks azonostja.

	@note			Figyelmen kvl hagyja a visszatrsi rtket.
*/
forward ks_knife_selected( iPlayerId, iKnifeId );
