#include <amxmodx> 
#include <regex>

#define VERSION 0.1.3 

#define MAX_SIZE		1024	
#define MAX_MAPS		64		
#define MAX_GROUP		24		
#define MAX_GROUPS	16
#define STR_L			64
#define STR_M			32
#define STR_S			16
#define TASK_ID		15658734

#define MAP(%1) g_maps_str[g_maps[%1]]

new g_shedule[MAX_GROUPS][4];
new g_shedule_size; 
 
new g_maps_str[MAX_SIZE];
new g_maps[MAX_MAPS];
new g_maps_len, g_maps_cnt;

new g_actual[MAX_GROUPS], g_actual_info[2];
new g_ut_midnight;		
 
public plugin_natives()
{
	register_library("maps_shedule");
	register_native("mapsh_maps", "_mapsh_maps", 0);
}

public plugin_init()
{	
	register_clcmd("amx_mapsh", "cmd_mapsh", -1, "");
} 

public plugin_cfg()
{ 
	load_shedule();  
	update_shedule(); 
}
 
public plugin_end()
{ 
	remove_task(TASK_ID);
}

public update_shedule(){	
	choose_groups(g_actual, g_actual_info);	
	set_task(float(g_actual_info[1]) + 0.5, "update_shedule", TASK_ID, "", 0, "a", 1);
	}

public cmd_mapsh(id, level, cid)
{ 	
	new arg1[STR_S];
	new bool:all = true; 
	read_argv(1, arg1, STR_S - 1);
	new tsec;
	
	if(arg1[0])
	{
		if(equal(arg1, "now"))
		{
			tsec = sec_from_midnight();			
		} 
		else if(equal(arg1, "at"))
		{			
			new arg2[STR_S];
			read_argv(2, arg2, STR_S - 1);
			new match, err[128], str[STR_S];
			new Regex:m = regex_match(arg2, "(\d{1,2}:\d{1,2}):?(\d{1,2})?", match, err, 127);

			if(match < 1){
				client_print(id, print_console, "Hibas betoltes.");	 
				return PLUGIN_HANDLED;
			}else if (match == 2){								
				regex_substr(m, 1, str, STR_S - 1);				
				tsec = parse_time(str, "%H:%M", 0);								
			}else if (match == 3){
				regex_substr(m, 0, str, STR_S - 1);				
				tsec = parse_time(str, "%H:%M:%S", 0);								
			}
			
			new timestr[STR_M];
			format_time(timestr, STR_M - 1, "%H:%M:%S", tsec + g_ut_midnight);
			client_print(id, print_console, "# Elerheto mapok %s:", timestr);
			regex_free(m);		
		}
		else if(equal(arg1, "id")){
			new arg2[STR_S];
			read_argv(2, arg2, STR_S - 1);			
			if(!is_str_num(arg2)){
				client_print(id, print_console, "Hibas betoltes.");		
				return PLUGIN_HANDLED;
			} 
			else {
				new group_id = str_to_num(arg2);
				if( group_id >= 0 && group_id <= g_shedule_size) {
					print_group(id, group_id);
				} 
				else {
					client_print(id, print_console, "Hibas id.");		
					return PLUGIN_HANDLED;
				}
			}
		}
		all = false;		
	} 
	
	new tleft_str[16];	
	
	if(!all){
		new tm[MAX_GROUPS], opt[2];
		choose_groups(tm, opt, tsec);		
		for(new i = 0; i < opt[0]; i++){ 
			print_group(id, tm[i]);
		}
		sec_to_str(opt[1], tleft_str);	
	} 
	else { 
		for(new i = 0; i <= g_shedule_size; i++){
			print_group(id, i);
		}
		sec_to_str(g_actual_info[1], tleft_str);
	}
	
	client_print(id, print_console, "A kovetkezo frissitesig: %s", tleft_str); 
	return PLUGIN_HANDLED;
}

print_group(id, group_id){	
	new t_str1[16], t_str2[16], t_str3[16], str[STR_L];
		
	new t1 = g_shedule[group_id][0], 
		 t2 = g_shedule[group_id][1], 
		 duration = t2 == t1 ? 86400 : t2 - t1; 
	
	format_time(t_str1, 16, "%H:%M:%S",  t1 + g_ut_midnight);
	format_time(t_str2, 16, "%H:%M:%S",  t2 + g_ut_midnight);		
	sec_to_str(duration, t_str3);
	
	new maps = g_shedule[group_id][3] - g_shedule[group_id][2];
	
	format(str, STR_L, "#%02d %02d	%s - %s ( %s )", group_id, maps, t_str1, t_str2, t_str3);
	client_print(id, print_console, str);
		
	for(new i = 0; i < maps; i++){
		format(str, STR_L, "%3d. %s", i, MAP(g_shedule[group_id][2] + i));
		client_print(id, print_console, str);
	}
	client_print(id, print_console, "");
}

public _mapsh_maps(plugin, params)
{
	new count	= get_param_byref(3);
	new rand		= get_param(4);
	new limit	= get_param(5);	
	new tsec		= get_param(6);
	new current	= get_param(7);
	
	if(tsec < 0)
		tsec = sec_from_midnight();
	
	new groups[MAX_GROUPS], info[2];	
	new all_maps_ids[MAX_MAPS], maps_cnt;
	new group_id, group_sz;
	new maps_ids[MAX_MAPS], map_id;
	
	choose_groups(groups, info, tsec);
	
	for(new i = 0; i < info[0]; i++){
		group_id = groups[i];
		group_sz = g_shedule[group_id][3] - g_shedule[group_id][2];
		
		for(new j = 0; j < group_sz; j++)
			all_maps_ids[maps_cnt + j] = g_shedule[group_id][2] + j;
			
		maps_cnt += group_sz;
	} 
	
	if(current == -1){
		new current_map[STR_M];
		get_mapname(current_map, STR_M - 1);
		current = get_current_map_id(current_map); 
		current = find(all_maps_ids, maps_cnt, current);		  
		if( current != -1 && maps_cnt <= limit)
			maps_cnt--; 
	} else current = -1;
 
	if(limit != -1)			
		maps_cnt = maps_cnt < limit ? maps_cnt : limit;	
  
	for(new j = 0; j < maps_cnt; j++){			
		if(rand){
			do map_id = all_maps_ids[random(maps_cnt + 1)]; 
			while(find(maps_ids, j, map_id) != -1)	 
		} 
		else map_id = all_maps_ids[j];				
 
		if(map_id == current){
			if(rand)
				j--;
			continue; 
		}
		else maps_ids[j] = map_id;
	}  
	
	new buff[MAX_SIZE];
	new maps[MAX_MAPS];
	new buff_sz, map_len; 
	
	for(new i = 0; i < maps_cnt; i++){		 		
		map_len = strlen(MAP(maps_ids[i]));
		maps[i] = buff_sz;
		copy(buff[buff_sz], MAX_SIZE, MAP(maps_ids[i])); 
		buff_sz += map_len + 1;
	} 
	
	set_array(1, buff, buff_sz);
	set_array(2, maps, maps_cnt);	 
	
	if(count != -1)
		set_param_byref(3, maps_cnt);
	   
	return info[1]; 
}

choose_groups(groups[MAX_GROUPS], info[2], tsec = 0)
{ 
	new t, t1, t2, tleft, diff, sz;	
	t = tsec ? tsec : sec_from_midnight();
	tleft = diff = 86400;
 	
	for(new i = 0; i <= g_shedule_size; i++){
		t1 = g_shedule[i][0] < 86400 ? g_shedule[i][0] : g_shedule[i][0] % 86400;
		t2 = g_shedule[i][1] < 86400 ? g_shedule[i][1] : g_shedule[i][1] % 86400;
		   
		if(t2 <= t1){
			t2 += 86400;
			if(t < t1 && t < t2)
				t1 = 0;
		}
			
		diff = t1 - t;
		
		if(t >= t1 && t < t2){
			groups[sz++] = i;
			diff = t2 - t;
		}
		
		diff = diff < 0 ? diff + 86400 : diff;		
		if(diff < tleft)
			tleft = diff; 
	}
 
	info[0] = sz;	
	info[1] = tleft;
}

load_shedule()
{
	g_shedule_size = -1;
	new path[STR_L];
	get_localinfo("amxx_configsdir", path, sizeof(path) - 1);
	format(path, sizeof(path) - 1, "%s/maps_shedule.ini", path);
	
	if(!file_exists(path))
		return;
			
	new f = fopen(path, "r");
	if(!f){
		log_amx("I/O Error. Fajlt nem lehet megnyitni: %s", path);
		return;
	}
	 
	new str[STR_L];
		
	while(!feof(f)){
		fgets(f, str, STR_L - 1);
		if(str[0] == ';' || strlen(str) < 4)
			continue;
				
		if(str[0] == '['){			
			if(++g_shedule_size == MAX_GROUPS)
				return;
			
			str[0] = ' ';
			replace(str, STR_L, "]", " ");
			trim(str);
			
			new l[32], r[32];
			strtok(str, l, 32, r, 32, '-' );
			
			g_shedule[g_shedule_size][0] = parse_time(l, "%H:%M:%S", 0);
			g_shedule[g_shedule_size][1] = parse_time(r, "%H:%M:%S", 0);

			continue;
		} 
		
		trim(str);
		if(is_map_valid(str)){
			if(g_shedule_size < 0){
				log_amx("Hiba: kovetkezo ^"%s^"", str);
				continue;
			}
			
			g_maps[g_maps_cnt++] = g_maps_len;
			if( g_maps_len >= MAX_SIZE){
				log_amx("Figyelmeztetes: Tul sok mapot tartalmaz.");
				break;
			}
			copy(g_maps_str[g_maps_len], MAX_SIZE, str);		
			g_maps_len += strlen(str) + 1;
			
			if(g_shedule[g_shedule_size][3] == 0){
				g_shedule[g_shedule_size][2] = g_shedule[g_shedule_size][3] = g_maps_cnt - 1;				
			} 
			g_shedule[g_shedule_size][3] += 1;			
		}
		else {
			log_amx("Figyelmeztetes: ^"%s^" map nem talalhato.", str);
		} 
	} 
}

find(arr[MAX_MAPS], sz, n, start = 0){	
	for(new i = start; i < sz; i++){
		if(arr[i] == n)
			return i;
	}
	return -1;
}

sec_from_midnight()
{ 
	g_ut_midnight = parse_time("00:00:00", "%H:%M:%S"); 
	return time() - g_ut_midnight;
}

sec_to_str(tsec, dest[16])
{
	tsec = tsec < 0 ? tsec + 86400 : tsec;		
	new h = tsec / 3600, 
		 m = (tsec % 3600) / 60, 
		 s = (tsec % 3600) % 60;
	
	format(dest, 16, "%02d:%02d:%02d", h, m, s);
}

get_current_map_id(map[STR_M]){
	for(new i = 0; i < g_maps_cnt; i++){
		if(equali(MAP(i), map))
			return i;
	}
	return -1;
} 