#include <amxmodx>
#include <engine>
#include <fakemeta_util>
#include <hamsandwich>
#include <cstrike>
#include <zombieplague>

#define PLUGIN "[CSO] Melee Item: Thanatos-9"
#define VERSION "2.0.beta" // Not Code Skull-Axe!
#define AUTHOR "Dev!l" //Original Author Code

#define THANATOS9_RANGE_SLASH 110.0
#define THANATOS9_RANGE_STAB 80.0
#define THANATOS9_NEXTATTACK_SLASH 2.0
#define THANATOS9_NEXTATTACK_STAB 1.0

#define THANATOS9_DAMAGE_SLASH 500.0
#define THANATOS9_DAMAGE_STAB 100.0

#define THANATOS9_CHANGEA 5.0
#define THANATOS9_CHANGEB 3.5

#define THANATOS9_SHOOT_START 1.0
#define THANATOS9_SHOOT_END 1.0

#define DRAW_TIMEA 1.0
#define DRAW_TIMEB 1.0

const OFFSET_WEAPONOWNER = 41
const OFFSET_LINUX_WEAPONS = 4
const m_flNextAttack = 83

#define CSW_THANATOS9 CSW_KNIFE
#define weapon_thanatos9 "weapon_knife"

new v_model[] = "models/cso/v_thanatos9.mdl"
new p_modela[] = "models/cso/p_thanatos9a.mdl"
new p_modelb[] = "models/cso/p_thanatos9b.mdl"

new const hit_wall[] = "weapons/balrog9_wall.wav"
new const hit_sound[] = "weapons/skullaxe_hit.wav"

new const thanatos9_sound[][] =
{
	"weapons/thanatos9_drawa.wav",
	"weapons/thanatos9_shoota1.wav",
	"weapons/thanatos9_shoota2.wav",
	"weapons/thanatos9_shootb_end.wav",
	"weapons/thanatos9_shootb_loop.wav",
	"weapons/thanatos9_changea_1.wav",
	"weapons/thanatos9_changea_2.wav",
	"weapons/thanatos9_changea_3.wav",
	"weapons/thanatos9_changea_4.wav",
	"weapons/thanatos9_changeb_1.wav",
	"weapons/thanatos9_changeb_2.wav"
}

enum
{
	THANATOS9_ANIM_DRAWA = 0,
	THANATOS9_ANIM_SHOOTB_LOOP,
	THANATOS9_ANIM_SHOOTB_START,
	THANATOS9_ANIM_SHOOTB_END,
	THANATOS9_ANIM_IDLEB,
	THANATOS9_ANIM_IDLEA,
	THANATOS9_ANIM_DRAWB,
	THANATOS9_ANIM_SHOOTA1,
	THANATOS9_ANIM_SHOOTA2,
	THANATOS9_ANIM_CHANGEA,
	THANATOS9_ANIM_CHANGEB
}

enum
{
	MODE_SLASH = 1,
	MODE_CHANGEA,
	MODE_CHANGEB,
	MODE_STAB,
	MODE_STAB_ACTION
}

enum
{
	HIT_NOTHING = 0,
	HIT_ENEMY,
	HIT_WALL
}

#define TASK_SLASHING 215842

new const WEAPONENTNAMES[][] = { "", "weapon_p228", "", "weapon_scout", "weapon_hegrenade", "weapon_xm1014", "weapon_c4", "weapon_mac10", "weapon_aug", "weapon_smokegrenade", "weapon_elite", "weapon_fiveseven", "weapon_ump45", "weapon_sg550", "weapon_p228", "weapon_famas", "weapon_usp", "weapon_glock18", "weapon_awp", "weapon_mp5navy", "weapon_m249",
"weapon_m3", "weapon_m4a1", "weapon_tmp", "weapon_g3sg1", "weapon_flashbang", "weapon_deagle", "weapon_sg552",
"weapon_ak47", "weapon_knife", "weapon_p90" }

new m_iBlood[2]
new g_has_thanatos9[33], g_item
new g_MaxPlayers, g_mode[33]

new Float:g_thanatos_swing_range = 1.8,Float:g_thanatos_stab_range = 0.8

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_event("HLTV", "Event_NewRound", "a", "1=0", "2=0")
	register_event("CurWeapon", "Event_CurWeapon", "be", "1=1")
	
	RegisterHam(Ham_Spawn, "player", "Player_Spawn", 1)
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled")
	RegisterHam(Ham_Weapon_WeaponIdle, "weapon_knife", "fw_thanatosidleanim", 1)
	
	register_forward(FM_EmitSound, "fw_EmitSound")
	register_forward(FM_CmdStart, "fw_CmdStart")
	register_forward(FM_TraceLine, "fw_TraceLine")
	register_forward(FM_TraceHull, "fw_TraceHull")
	RegisterHam(Ham_TraceAttack, "player", "fw_TraceAttack")
	
	for (new i = 1; i < sizeof WEAPONENTNAMES; i++)
	if (WEAPONENTNAMES[i][0]) RegisterHam(Ham_Item_Deploy, WEAPONENTNAMES[i], "fw_Item_Deploy_Post", 1)
	
	g_MaxPlayers = get_maxplayers()
	
	g_item = zp_register_extra_item("Thanatos-9", 40, ZP_TEAM_HUMAN)
}

public plugin_precache()
{
	precache_model(v_model)
	precache_model(p_modela)
	precache_model(p_modelb)
	
	precache_sound(hit_wall)
	precache_sound(hit_sound)
		
	for(new i = 0; i < sizeof thanatos9_sound; i++)
		precache_sound(thanatos9_sound[i])
		
	m_iBlood[0] = precache_model("sprites/blood.spr")
	m_iBlood[1] = precache_model("sprites/bloodspray.spr")
}

public zp_extra_item_selected(id, item)
{
	if(item == g_item)
	{
		get_thanatos9(id)
	}
}

public client_connect(id) remove_thanatos9(id)
public client_disconnect(id) remove_thanatos9(id)
public Player_Spawn(id) remove_thanatos9(id)
public fw_PlayerKilled(id) remove_thanatos9(id)
public zp_user_infected_post(id) remove_thanatos9(id)
public zp_user_humanized_post(id) remove_thanatos9(id)

public get_thanatos9(id)
{
	g_has_thanatos9[id] = 1
	g_mode[id] = MODE_SLASH

	if(get_user_weapon(id) == CSW_KNIFE) 
	{
		set_pev(id, pev_viewmodel2, v_model)
		
		set_weapon_anim(id, THANATOS9_ANIM_DRAWA)
		set_weapons_timeidle(id, CSW_THANATOS9, DRAW_TIMEA)
		set_player_nextattack(id, DRAW_TIMEA)
		
		static ent; ent = fm_get_user_weapon_entity(id, CSW_THANATOS9)
		set_pdata_float(ent, 47, 9999.0, OFFSET_LINUX_WEAPONS)
	} else {
		engclient_cmd(id, weapon_thanatos9)
	}
}

public remove_thanatos9(id)
{
	g_has_thanatos9[id] = 0
	g_mode[id] = 0
	if(g_mode[id] == MODE_STAB_ACTION)
	{
		g_mode[id] = MODE_STAB
		shoot_b_end(id)
	}
}

public fw_Item_Deploy_Post(weapon_ent)
{
	static owner
	owner = fm_cs_get_weapon_ent_owner(weapon_ent)

	if(g_has_thanatos9[owner])
	{
	set_weapons_timeidle(owner, CSW_THANATOS9, 1.7)
	// set_player_nextattack(owner, 1.7)
	}
}

public Event_CurWeapon(id)
{
	if(!is_user_alive(id))
		return 1
	if(get_user_weapon(id) != CSW_THANATOS9)
		return 1
	if(!g_has_thanatos9[id])
		return 1
		
	set_pev(id, pev_viewmodel2, v_model)
	
	if(g_has_thanatos9[id])
	{
		if(g_mode[id] == MODE_SLASH)
		{
			set_pev(id, pev_weaponmodel2, p_modela)
			set_weapon_anim(id, THANATOS9_ANIM_DRAWA)
			set_weapons_timeidle(id, CSW_THANATOS9, DRAW_TIMEA)
			set_player_nextattack(id, DRAW_TIMEA)
		} else if(g_mode[id] == MODE_STAB)
		{
			set_pev(id, pev_weaponmodel2, p_modelb)
			set_weapon_anim(id, THANATOS9_ANIM_DRAWB)
			set_weapons_timeidle(id, CSW_THANATOS9, DRAW_TIMEB)
			set_player_nextattack(id, DRAW_TIMEB)
		} else if(g_mode[id] == MODE_STAB_ACTION)
		{
			set_pev(id, pev_weaponmodel2, p_modela)
			set_weapon_anim(id, THANATOS9_ANIM_DRAWA)
			set_weapons_timeidle(id, CSW_THANATOS9, DRAW_TIMEA)
			set_player_nextattack(id, DRAW_TIMEA)
			g_mode[id] = MODE_STAB
			shoot_b_end(id)
		}
	}
		
	return 0
}			

public Event_NewRound()
{
	for(new i = 0; i < g_MaxPlayers; i++)
		remove_thanatos9(i)
}

stock fm_cs_get_weapon_ent_owner(ent)
{
	return get_pdata_cbase(ent, OFFSET_WEAPONOWNER, OFFSET_LINUX_WEAPONS)
}

public fw_EmitSound(id, channel, const sample[], Float:volume, Float:attn, flags, pitch)
{
	if(!is_user_connected(id))
		return FMRES_IGNORED
	if(get_user_weapon(id) != CSW_THANATOS9 || !g_has_thanatos9[id])
		return FMRES_IGNORED
		
	if(sample[8] == 'k' && sample[9] == 'n' && sample[10] == 'i')
	{
		if(sample[14] == 's' && sample[15] == 'l' && sample[16] == 'a')
		{
			if(g_mode[id] == MODE_SLASH)
			{
				set_weapons_timeidle(id, CSW_THANATOS9, 1.2)
				set_player_nextattack(id, 1.2)
			
				emit_sound(id, CHAN_WEAPON, thanatos9_sound[random_num(2,3)], 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			return FMRES_SUPERCEDE
		}
		if (sample[14] == 'h' && sample[15] == 'i' && sample[16] == 't') // hit
		{
			if (sample[17] == 'w') // wall
			{
				if(g_mode[id] == MODE_SLASH)
				{
					set_weapons_timeidle(id, CSW_THANATOS9, 1.2)
					set_player_nextattack(id, 1.2)
				
					emit_sound(id, CHAN_WEAPON, hit_wall, 1.0, ATTN_NORM, 0, PITCH_NORM)
				}
				return FMRES_SUPERCEDE
			}
			else
			{
				if(g_mode[id] == MODE_SLASH)
				{
					set_weapons_timeidle(id, CSW_THANATOS9, 1.2)
					set_player_nextattack(id, 1.2)
				
					emit_sound(id, CHAN_WEAPON, hit_sound, 1.0, ATTN_NORM, 0, PITCH_NORM)
				}
				return FMRES_SUPERCEDE
			}
		}
		if (sample[14] == 's' && sample[15] == 't' && sample[16] == 'a') // stab
		{
			if(g_mode[id] == MODE_SLASH)
			{
				set_weapons_timeidle(id, CSW_THANATOS9, 1.2)
				set_player_nextattack(id, 1.2)
			
				emit_sound(id, CHAN_WEAPON, hit_sound, 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED
}

public fw_thanatosidleanim(Weapon)
{
	new id = get_pdata_cbase(Weapon, 41, 4)

	if(!is_user_alive(id) || zp_get_user_zombie(id) || !g_has_thanatos9[id] || get_user_weapon(id) != CSW_THANATOS9)
		return HAM_IGNORED;
		
	if(g_mode[id] == MODE_SLASH && get_pdata_float(Weapon, 48, 4) <= 0.25) 
	{
		set_weapon_anim(id, THANATOS9_ANIM_IDLEA)
		set_pdata_float(Weapon, 48, 20.0, 4)
		return HAM_SUPERCEDE;
	}
	
	if(g_mode[id] == MODE_STAB && get_pdata_float(Weapon, 48, 4) <= 0.25) 
	{
		set_weapon_anim(id, THANATOS9_ANIM_IDLEB)
		set_pdata_float(Weapon, 48, 20.0, 4)
		return HAM_SUPERCEDE;
	}

	return HAM_IGNORED;
}

public fw_CmdStart(id, uc_handle, seed)
{
	if (!is_user_alive(id)) 
		return
	if(get_user_weapon(id) != CSW_THANATOS9)
		return
	if(!g_has_thanatos9[id])
		return
	
	static ent
	ent = find_ent_by_owner(-1, weapon_thanatos9, id)
	
	if(!pev_valid(ent))
		return
	if(get_pdata_float(ent, 46, 4) > 0.0 || get_pdata_float(ent, 47, 4) > 0.0) 
		return
	
	static CurButton
	CurButton = get_uc(uc_handle, UC_Buttons)
	
	if(CurButton & IN_ATTACK)
	{
		if(get_pdata_float(id, 83, 5) > 0.0)
			return
			
		set_uc(uc_handle, UC_Buttons, CurButton & ~IN_ATTACK)
		
		if(g_mode[id] == MODE_SLASH)
		{
			g_mode[id] = MODE_SLASH
			set_weapons_timeidle(id, CSW_THANATOS9, THANATOS9_NEXTATTACK_SLASH)
			set_player_nextattack(id, THANATOS9_NEXTATTACK_SLASH)
			set_weapon_anim(id, random_num(THANATOS9_ANIM_SHOOTA1, THANATOS9_ANIM_SHOOTA2))
			
			set_task(1.2, "Do_Slashing", id+TASK_SLASHING)
		}
		else if(g_mode[id] == MODE_STAB)
		{
			g_mode[id] = MODE_STAB
			shoot_b_start(id)
			set_weapons_timeidle(id, CSW_THANATOS9, 0.1)
			set_player_nextattack(id, THANATOS9_NEXTATTACK_STAB)
		}
	} else if (CurButton & IN_ATTACK2) {
		if(get_pdata_float(ent, 47, OFFSET_LINUX_WEAPONS) > 0.0) 
			return
			
		if(g_mode[id] == MODE_SLASH)
		{
			set_weapons_timeidle(id, CSW_THANATOS9, 0.1)
			set_player_nextattack(id, 0.1)
			g_mode[id] = MODE_CHANGEA
			set_task(0.1, "change_modea", id)
		}
		else if(g_mode[id] == MODE_STAB)
		{
			set_weapons_timeidle(id, CSW_THANATOS9, 0.1)
			set_player_nextattack(id, 0.1)
			g_mode[id] = MODE_CHANGEB
			set_task(0.1, "change_modeb", id)
		}
	}
}

public Do_Slashing(id)
{
	id -= TASK_SLASHING
	
	if(!is_user_alive(id))
		return
	if(get_user_weapon(id) != CSW_THANATOS9 || !g_has_thanatos9[id])
		return
		
	static Ent
	Ent = find_ent_by_owner(-1, weapon_thanatos9, id)
	new Float:origin[3]
	pev(Ent, pev_origin, origin)
	
	new a = FM_NULLENT
	
	while((a = find_ent_in_sphere(a, origin, 80.0)) != 0)
	{
		if (id == a)
			continue
			
		if (zp_get_user_zombie(id))
			return
	
		if(pev(a, pev_takedamage) != DAMAGE_NO)
		{
			ExecuteHamB(Ham_TakeDamage, a, id, id, 400.0, DMG_BULLET)
		}
	}
		
	if(!Check_Attack(id, 1))
	{
		emit_sound(id, CHAN_WEAPON, thanatos9_sound[random_num(2,3)], 1.0, ATTN_NORM, 0, PITCH_NORM)
	} else {
		emit_sound(id, CHAN_WEAPON, hit_sound, 1.0, ATTN_NORM, 0, PITCH_NORM)
	}
}

public change_modea(id)
{
	if(g_mode[id] == MODE_CHANGEA)
	{
		set_weapons_timeidle(id, CSW_THANATOS9, THANATOS9_CHANGEA)
		set_player_nextattack(id, THANATOS9_CHANGEA)
		set_weapon_anim(id, THANATOS9_ANIM_CHANGEA)
		set_pev(id, pev_weaponmodel2, p_modelb)
	
		g_mode[id] = MODE_SLASH
		set_task(THANATOS9_CHANGEA, "mode_b", id)
	}
}

public mode_b(id)
{
	g_mode[id] = MODE_STAB
}

public change_modeb(id)
{
	if(g_mode[id] == MODE_CHANGEB)
	{
		set_weapons_timeidle(id, CSW_THANATOS9, THANATOS9_CHANGEB)
		set_player_nextattack(id, THANATOS9_CHANGEB)
		set_weapon_anim(id, THANATOS9_ANIM_CHANGEB)
		set_pev(id, pev_weaponmodel2, p_modela)
				
		g_mode[id] = MODE_SLASH
	}
}

public shoot_b_start(id)
{
	if(g_mode[id] == MODE_STAB)
	{
		set_weapons_timeidle(id, CSW_THANATOS9, THANATOS9_SHOOT_START)
		set_player_nextattack(id, THANATOS9_SHOOT_START)
		set_weapon_anim(id, THANATOS9_ANIM_SHOOTB_START)
				
		g_mode[id] = MODE_STAB_ACTION
		set_task(THANATOS9_SHOOT_START, "shoot_b_loop", id)
	}
}

public shoot_b_loop(id)
{
	if(g_mode[id] == MODE_STAB_ACTION)
	{
		set_weapons_timeidle(id, CSW_THANATOS9, 6.0)
		set_player_nextattack(id, 0.0)
		set_weapon_anim(id, THANATOS9_ANIM_SHOOTB_LOOP)
		action_thanatos(id)
		emit_sound(id, CHAN_WEAPON, thanatos9_sound[4], 1.0, ATTN_NORM, 0, PITCH_NORM)
				
		g_mode[id] = MODE_STAB_ACTION
	}
}

public shoot_b_end(id)
{
	if(g_mode[id] == MODE_STAB)
	{
		remove_task(id)
		emit_sound(id, CHAN_WEAPON, "common/null.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
				
		g_mode[id] = MODE_STAB
		set_task(0.1, "shoot_b_end_finish", id)
	}
}

public shoot_b_end_finish(id)
{
	if(g_mode[id] == MODE_STAB)
	{
		set_weapons_timeidle(id, CSW_THANATOS9, THANATOS9_SHOOT_END)
		set_player_nextattack(id, THANATOS9_SHOOT_END)
		set_weapon_anim(id, THANATOS9_ANIM_SHOOTB_END)
				
		g_mode[id] = MODE_CHANGEB
		set_task(THANATOS9_SHOOT_END, "change_modeb", id)
	}
}

public action_thanatos(id)
{
	static Ent
	Ent = find_ent_by_owner(-1, weapon_thanatos9, id)
		
	Damage_thanatos(Ent)
	set_task(0.1, "action_thanatos", id)
}

public Damage_thanatos(Ent)
{
	static id; id = pev(Ent, pev_owner)
	new Float:origin[3]
	pev(Ent, pev_origin, origin)
	
	new a = FM_NULLENT
	
	while((a = find_ent_in_sphere(a, origin, 80.0)) != 0)
	{
		if (id == a)
			continue
			
		if (zp_get_user_zombie(id))
			return
	
		if(pev(a, pev_takedamage) != DAMAGE_NO)
		{
			ExecuteHamB(Ham_TakeDamage, a, id, id, 400.0, DMG_BULLET)
		}
	}
	set_task(0.1, "damage_thanatos9", id)
}


public damage_thanatos9(id)
{
	static Float:Max_Distance
	
	if(g_mode[id] == MODE_STAB_ACTION)
	{
		Max_Distance = THANATOS9_RANGE_STAB
	}
	
	static Float:VicOrigin[3], Float:MyOrigin[3]
	pev(id, pev_origin, MyOrigin)
			
	static Have_Victim; Have_Victim = 0
	static ent
	ent = find_ent_by_owner(-1, weapon_thanatos9, id)
		
	if(!pev_valid(ent))
		return 0
		
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(!is_user_alive(i))
			continue
		if(id == i)
			continue
		if(entity_range(id, i) > Max_Distance)
			continue
		pev(i, pev_origin, VicOrigin)
		if(!is_in_viewcone(id, VicOrigin, 1))
			continue
		if(is_wall_between_points(MyOrigin, VicOrigin, id))
			continue
		
		if(!Have_Victim) Have_Victim = 1
		if(g_mode[id] == MODE_STAB_ACTION)
		{
			do_attack(id, i, ent, THANATOS9_DAMAGE_STAB)
		}
	}	
	
	stop_damage(id)
	
	if(Have_Victim)
		return 1
	else
		return 0
	
	return 0
}

public stop_damage(id)
{
	set_task(6.0, "shoot_b_end", id)
	g_mode[id] = MODE_STAB
}

public Check_Attack(id, First_Check)
{
	static Float:Max_Distance
	
	if(g_mode[id] == MODE_SLASH)
	{
		Max_Distance = THANATOS9_RANGE_SLASH
	}
	
	static Float:VicOrigin[3], Float:MyOrigin[3]
	pev(id, pev_origin, MyOrigin)
		
	static Have_Victim; Have_Victim = 0
	static ent
	ent = find_ent_by_owner(-1, weapon_thanatos9, id)
		
	if(!pev_valid(ent))
		return 0
		
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(!is_user_alive(i))
			continue
		if(id == i)
			continue
		if(entity_range(id, i) > Max_Distance)
			continue
		pev(i, pev_origin, VicOrigin)
		if(!is_in_viewcone(id, VicOrigin, 1))
			continue
		if(is_wall_between_points(MyOrigin, VicOrigin, id))
			continue
		
		if(!Have_Victim) Have_Victim = 1
		if(g_mode[id] == MODE_SLASH)
		{
			do_attack(id, i, ent, THANATOS9_DAMAGE_SLASH)
			if(!First_Check && cs_get_user_team(id) != cs_get_user_team(i))
			{
				// do_attack(id, i, ent, THANATOS9_DAMAGE_SLASH)
			}
		}
	}	
	
	if(Have_Victim)
		return 1
	else
		return 0
	
	return 0
}	

public fw_TraceLine(Float:fStart[3], Float:fEnd[3], conditions, id, ptr){
	return vTrace(id, ptr,fStart,fEnd,conditions)
}

public fw_Tracehull(Float:fStart[3], Float:fEnd[3], conditions, hull, id, ptr){
	return vTrace(id, ptr,fStart,fEnd,conditions,true,hull)
}

vTrace(id, ptr,Float:fStart[3],Float:fEnd[3],iNoMonsters,bool:hull = false,iHull = 0)
{	
	if(is_user_alive(id) && get_user_weapon(id) == CSW_THANATOS9 && g_has_thanatos9[id]){		
		new Float:scalar
		
		if(g_mode[id] == MODE_SLASH) scalar = g_thanatos_swing_range
		else if(g_mode[id] == MODE_STAB_ACTION) scalar = g_thanatos_stab_range
		else scalar = 0.0

		xs_vec_sub(fEnd,fStart,fEnd)
		xs_vec_mul_scalar(fEnd,scalar,fEnd);
		xs_vec_add(fEnd,fStart,fEnd);
		
		hull ? engfunc(EngFunc_TraceHull,fStart,fEnd,iNoMonsters,iHull,id,ptr) : engfunc(EngFunc_TraceLine,fStart,fEnd,iNoMonsters, id,ptr)
	}
	
	return FMRES_IGNORED;
}

public fw_TraceAttack(Victim, Attacker, Float:Damage, Float:Direction[3], TraceHandle, DamageBit, ptr)
{
	if(!is_user_alive(Attacker))
		return HAM_IGNORED
	if(get_user_weapon(Attacker) != CSW_THANATOS9)
		return HAM_IGNORED
	if(!g_has_thanatos9[Attacker])
		return HAM_IGNORED
		
	
		
	return HAM_IGNORED
}

do_attack(Attacker, Victim, Inflictor, Float:fDamage)
{
	fake_player_trace_attack(Attacker, Victim, fDamage)
	fake_take_damage(Attacker, Victim, fDamage, Inflictor)
}

fake_player_trace_attack(iAttacker, iVictim, &Float:fDamage)
{
	// get fDirection
	new Float:fAngles[3], Float:fDirection[3]
	pev(iAttacker, pev_angles, fAngles)
	angle_vector(fAngles, ANGLEVECTOR_FORWARD, fDirection)
	
	// get fStart
	new Float:fStart[3], Float:fViewOfs[3]
	pev(iAttacker, pev_origin, fStart)
	pev(iAttacker, pev_view_ofs, fViewOfs)
	xs_vec_add(fViewOfs, fStart, fStart)
	
	// get aimOrigin
	new iAimOrigin[3], Float:fAimOrigin[3]
	get_user_origin(iAttacker, iAimOrigin, 3)
	IVecFVec(iAimOrigin, fAimOrigin)
	
	// TraceLine from fStart to AimOrigin
	new ptr = create_tr2() 
	engfunc(EngFunc_TraceLine, fStart, fAimOrigin, DONT_IGNORE_MONSTERS, iAttacker, ptr)
	new pHit = get_tr2(ptr, TR_pHit)
	new iHitgroup = get_tr2(ptr, TR_iHitgroup)
	new Float:fEndPos[3]
	get_tr2(ptr, TR_vecEndPos, fEndPos)

	// get target & body at aiming
	new iTarget, iBody
	get_user_aiming(iAttacker, iTarget, iBody)
	
	// if aiming find target is iVictim then update iHitgroup
	if (iTarget == iVictim)
	{
		iHitgroup = iBody
	}
	
	// if ptr find target not is iVictim
	else if (pHit != iVictim)
	{
		// get AimOrigin in iVictim
		new Float:fVicOrigin[3], Float:fVicViewOfs[3], Float:fAimInVictim[3]
		pev(iVictim, pev_origin, fVicOrigin)
		pev(iVictim, pev_view_ofs, fVicViewOfs) 
		xs_vec_add(fVicViewOfs, fVicOrigin, fAimInVictim)
		fAimInVictim[2] = fStart[2]
		fAimInVictim[2] += get_distance_f(fStart, fAimInVictim) * floattan( fAngles[0] * 2.0, degrees )
		
		// check aim in size of iVictim
		new iAngleToVictim = get_angle_to_target(iAttacker, fVicOrigin)
		iAngleToVictim = abs(iAngleToVictim)
		new Float:fDis = 2.0 * get_distance_f(fStart, fAimInVictim) * floatsin( float(iAngleToVictim) * 0.5, degrees )
		new Float:fVicSize[3]
		pev(iVictim, pev_size , fVicSize)
		if ( fDis <= fVicSize[0] * 0.5 )
		{
			// TraceLine from fStart to aimOrigin in iVictim
			new ptr2 = create_tr2() 
			engfunc(EngFunc_TraceLine, fStart, fAimInVictim, DONT_IGNORE_MONSTERS, iAttacker, ptr2)
			new pHit2 = get_tr2(ptr2, TR_pHit)
			new iHitgroup2 = get_tr2(ptr2, TR_iHitgroup)
			
			// if ptr2 find target is iVictim
			if ( pHit2 == iVictim && (iHitgroup2 != HIT_HEAD || fDis <= fVicSize[0] * 0.25) )
			{
				pHit = iVictim
				iHitgroup = iHitgroup2
				get_tr2(ptr2, TR_vecEndPos, fEndPos)
			}
			
			free_tr2(ptr2)
		}
		
		// if pHit still not is iVictim then set default HitGroup
		if (pHit != iVictim)
		{
			// set default iHitgroup
			iHitgroup = HIT_GENERIC
			
			new ptr3 = create_tr2() 
			engfunc(EngFunc_TraceLine, fStart, fVicOrigin, DONT_IGNORE_MONSTERS, iAttacker, ptr3)
			get_tr2(ptr3, TR_vecEndPos, fEndPos)
			
			// free ptr3
			free_tr2(ptr3)
		}
	}
	
	// set new Hit & Hitgroup & EndPos
	set_tr2(ptr, TR_pHit, iVictim)
	set_tr2(ptr, TR_iHitgroup, iHitgroup)
	set_tr2(ptr, TR_vecEndPos, fEndPos)
	
	// hitgroup multi fDamage
	new Float:fMultifDamage 
	switch(iHitgroup)
	{
		case HIT_HEAD: fMultifDamage  = 2.5
		case HIT_STOMACH: fMultifDamage  = 1.25
		case HIT_LEFTLEG: fMultifDamage  = 0.75
		case HIT_RIGHTLEG: fMultifDamage  = 0.75
		default: fMultifDamage  = 1.0
	}
	
	fDamage *= fMultifDamage
	
	// ExecuteHam
	fake_trake_attack(iAttacker, iVictim, fDamage, fDirection, ptr)
	
	// free ptr
	free_tr2(ptr)
}

stock fake_trake_attack(iAttacker, iVictim, Float:fDamage, Float:fDirection[3], iTraceHandle, iDamageBit = (DMG_NEVERGIB | DMG_BULLET))
{
	ExecuteHamB(Ham_TraceAttack, iVictim, iAttacker, fDamage, fDirection, iTraceHandle, iDamageBit)
}

stock fake_take_damage(iAttacker, iVictim, Float:fDamage, iInflictor = 0, iDamageBit = (DMG_NEVERGIB | DMG_BULLET))
{
	iInflictor = (!iInflictor) ? iAttacker : iInflictor
	ExecuteHamB(Ham_TakeDamage, iVictim, iInflictor, iAttacker, fDamage, iDamageBit)
}

stock set_weapon_anim(id, anim)
{
	if(!is_user_alive(id))
		return
		
	set_pev(id, pev_weaponanim, anim)
	
	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, _, id)
	write_byte(anim)
	write_byte(0)
	message_end()	
}

stock set_weapons_timeidle(id, WeaponId ,Float:TimeIdle)
{
	if(!is_user_alive(id))
		return
		
	static entwpn; entwpn = fm_get_user_weapon_entity(id, WeaponId)
	if(!pev_valid(entwpn)) 
		return
		
	set_pdata_float(entwpn, 46, TimeIdle, OFFSET_LINUX_WEAPONS)
	set_pdata_float(entwpn, 47, TimeIdle, OFFSET_LINUX_WEAPONS)
	set_pdata_float(entwpn, 48, TimeIdle + 0.5, OFFSET_LINUX_WEAPONS)
}

stock set_player_nextattack(id, Float:nexttime)
{
	if(!is_user_alive(id))
		return
		
	set_pdata_float(id, m_flNextAttack, nexttime, 5)
}

stock Get_MissileWeaponHitGroup( iEnt )
{
	new Float:flStart[ 3 ], Float:flEnd[ 3 ];
	
	pev( iEnt, pev_origin, flStart );
	pev( iEnt, pev_velocity, flEnd );
	xs_vec_add( flStart, flEnd, flEnd );
	
	new ptr = create_tr2();
	engfunc( EngFunc_TraceLine, flStart, flEnd, 0, iEnt, ptr );
	
	new iHitGroup, Owner, nOhead, head
	Owner = pev(iEnt, pev_owner)
	nOhead = get_tr2( ptr, TR_iHitgroup )
	head = set_tr2( ptr, TR_iHitgroup, HIT_HEAD )
	
	iHitGroup = is_user_alive(Owner) ? head : nOhead
	free_tr2( ptr );
	
	return iHitGroup;
}

stock get_angle_to_target(id, const Float:fTarget[3], Float:TargetSize = 0.0)
{
	new Float:fOrigin[3], iAimOrigin[3], Float:fAimOrigin[3], Float:fV1[3]
	pev(id, pev_origin, fOrigin)
	get_user_origin(id, iAimOrigin, 3) // end position from eyes
	IVecFVec(iAimOrigin, fAimOrigin)
	xs_vec_sub(fAimOrigin, fOrigin, fV1)
	
	new Float:fV2[3]
	xs_vec_sub(fTarget, fOrigin, fV2)
	
	new iResult = get_angle_between_vectors(fV1, fV2)
	
	if (TargetSize > 0.0)
	{
		new Float:fTan = TargetSize / get_distance_f(fOrigin, fTarget)
		new fAngleToTargetSize = floatround( floatatan(fTan, degrees) )
		iResult -= (iResult > 0) ? fAngleToTargetSize : -fAngleToTargetSize
	}
	
	return iResult
}

stock get_angle_between_vectors(const Float:fV1[3], const Float:fV2[3])
{
	new Float:fA1[3], Float:fA2[3]
	engfunc(EngFunc_VecToAngles, fV1, fA1)
	engfunc(EngFunc_VecToAngles, fV2, fA2)
	
	new iResult = floatround(fA1[1] - fA2[1])
	iResult = iResult % 360
	iResult = (iResult > 180) ? (iResult - 360) : iResult
	
	return iResult
}

stock is_wall_between_points(Float:start[3], Float:end[3], ignore_ent)
{
	static ptr
	ptr = create_tr2()

	engfunc(EngFunc_TraceLine, start, end, IGNORE_MONSTERS, ignore_ent, ptr)
	
	static Float:EndPos[3]
	get_tr2(ptr, TR_vecEndPos, EndPos)

	free_tr2(ptr)
	return floatround(get_distance_f(end, EndPos))
} 
