#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <colorchat>

new const Plugin[] = {"Sapik"}
new const Version[] = {"1.0"}
new const Author[] = {"LyleChriss"}

new const Prefix[] = {""}

//#define FLAG	ADMIN_KICK

new const MenuCmds[][] = {
	"say /sapka",
	"say /sapik",
	"say /sapi"
}

new const RemoveCmds[][] = {
	"say /alap",
	"say /nincs",
	"say /nohat",
	"say remove"
}

enum _:DATA
{
	Name[32],
	Model[32]
}
new sData[DATA]

new Trie:SayHats, Array:Hats
new g_HatEnt[33]

public plugin_init() {
	register_plugin(Plugin, Version, Author)
	
	for(new i; i<sizeof(MenuCmds);i++)
	{
		#if defined FLAG
		register_clcmd(MenuCmds[i], "Hats_Menu", FLAG)
		#else
		register_clcmd(MenuCmds[i], "Hats_Menu")
		#endif
	}
	for(new i; i<sizeof(RemoveCmds);i++)
	{
		#if defined FLAG
		register_clcmd(RemoveCmds[i], "Remove_Hat", FLAG)
		#else
		register_clcmd(RemoveCmds[i], "Remove_Hat")
		#endif
	}
	
	register_clcmd("say", "sayhandler");
	register_clcmd("say_team", "sayhandler");
}

public plugin_precache()
{
	SayHats=TrieCreate()
	Hats=ArrayCreate(DATA)
	new sBuffer[256], sFile[64], pFile
	get_localinfo("amxx_configsdir", sFile, charsmax(sFile))
	format(sFile, charsmax(sFile), "%s/hats.ini", sFile)
	
	pFile = fopen(sFile, "rt")
	
	if(pFile)
	{
		while(!feof(pFile))
		{
			fgets(pFile, sBuffer, charsmax(sBuffer))
			trim(sBuffer)
			if(sBuffer[0] == ';') continue;
			
			parse(sBuffer, sData[Name], 31, sData[Model], 31)
			
			if(containi(sData[Model], ".mdl") && !TrieKeyExists(SayHats, sData[Name]))
			{
				precache_model(sData[Model])
				TrieSetString(SayHats, sData[Name], sData[Model])
				ArrayPushArray(Hats, sData)
			}
		}
		fclose(pFile)
	}
	else write_file(sFile, ";^"hat name^" ^"models/hats_folder/hat_model.mdl^"^n")
}

public client_connect(id)
{
	if(g_HatEnt[id] > 0) remove_entity(g_HatEnt[id])
	g_HatEnt[id] = 0
}

public client_disconnect(id)
{
	if(g_HatEnt[id] > 0) remove_entity(g_HatEnt[id])
	g_HatEnt[id] = 0
}

public sayhandler(id)
{
	#if defined FLAG
	if(~get_user_flags(id) & FLAG) return;
	#endif
 
	new message[190]; read_args(message, charsmax(message));
	remove_quotes(message);
	
	if(TrieKeyExists(SayHats, message))
	{
		new sModel[64];
		TrieGetString(SayHats, message, sModel, charsmax(sModel));
		Set_Hat(id, sModel, message);
	}
}

public Remove_Hat(id, lvl, cid)
{
	#if defined FLAG
	if(cmd_access(id, lvl, cid, 0))
	{
	#endif
		remove_entity(g_HatEnt[id])
		g_HatEnt[id] = 0
		if(Prefix[0])
			ColorChat(id, NORMAL, "^4[%s]^1 Törölted a sapkád.", Prefix)
		else
			ColorChat(0, NORMAL, "^4[%s %s]^1 Törölted a sapkád.", Plugin, Version)
	#if defined FLAG
	}
	#endif
}

public Hats_Menu(id, lvl, cid)
{
	#if defined FLAG
	if(cmd_access(id, lvl, cid, 0))
	{
	#endif
		new txt[128]
		formatex(txt, charsmax(txt), "%s v%s by %s", Plugin, Version, Author)
		
		new menu = menu_create(txt, "Hats_Handler")
		
		menu_additem(menu, "Nincs", "", 0)
		for(new i;i<ArraySize(Hats);i++)
		{
			ArrayGetArray(Hats, i, sData)
			formatex(txt, charsmax(txt), "%s", sData[Name])
			
			menu_additem(menu, txt, "", 0)
		}
		
		menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
		menu_setprop(menu, MPROP_BACKNAME, "Vissza")
		menu_setprop(menu, MPROP_NEXTNAME, "Következő")
		menu_setprop(menu, MPROP_EXITNAME, "Kilépés")
			
		menu_display(id, menu, 0)
	#if defined FLAG
	}
	#endif
}

public Hats_Handler(id, menu, item)
{
	if(item == MENU_EXIT) {
		menu_destroy(menu);
		return PLUGIN_HANDLED;
	}
	
	if(item == 0)
	{
		remove_entity(g_HatEnt[id])
		g_HatEnt[id] = 0
		if(Prefix[0])
			ColorChat(id, NORMAL, "^4[%s]^1 Törölted a sapkád.", Prefix)
		else
			ColorChat(0, NORMAL, "^4[%s %s]^1 Törölted a sapkád.", Plugin, Version)
	}
	else
	{
		ArrayGetArray(Hats, item, sData)
		Set_Hat(id, sData[Model], sData[Name])
	}
	menu_destroy(menu);
	return PLUGIN_HANDLED;
}

public Set_Hat(id, model[], name[])
{
	if(g_HatEnt[id] < 1)
	{
		g_HatEnt[id] = create_entity("info_target")
		
		entity_set_string(g_HatEnt[id], EV_SZ_classname, "hat")
		entity_set_edict(g_HatEnt[id], EV_ENT_aiment, id)
		entity_set_edict(g_HatEnt[id], EV_ENT_owner, id)
		entity_set_int(g_HatEnt[id], EV_INT_movetype, MOVETYPE_FOLLOW)
		entity_set_model(g_HatEnt[id], model)
	}
	else
		entity_set_model(g_HatEnt[id], model)
		
	if(Prefix[0])
		ColorChat(id, NORMAL, "^4[%s]^1 kiválasztottad a(z) ^3%s ^1sapkát.", Prefix, name)
	else
		ColorChat(0, NORMAL, "^4[%s %s]^1 kiválasztottad a(z) ^3%s ^1sapkát.", Plugin, Version, name)
	
}

public plugin_end()
{
	ArrayDestroy(Hats)
	TrieDestroy(SayHats)
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
