#include <amxmodx>

new const g_sPrefix[ ] = "RoundEndSounds"

enum _:eMusicInfos { sName[ 128 ], sSound[ 64 ] };

new Array: g_daSounds, g_iData[ eMusicInfos ];
new g_iSoundsNum, g_iPrevSound = -1, bool: g_bEnabled[ 33 ];
 
public plugin_init( )
{
	register_plugin( "Round End Sounds", "1.0", "Demon" );
	
	if ( g_iSoundsNum > 0 )
	{
		register_event( "SendAudio", "PlayMusic", "a", "2&%!MRAD_ctwin" );
		register_event( "SendAudio", "PlayMusic", "a", "2&%!MRAD_terwin" );
		
		register_clcmd( "say /korvegi", "Toggle" );
		
		set_task( 150.0, "Advertising", 98765, _, _, "b" );
	}
}

public PlayMusic( )
{
	static iRand;
	
	do iRand = random( g_iSoundsNum );
	while ( iRand == g_iPrevSound );
	
	ArrayGetArray( g_daSounds, iRand, g_iData );
	
	ChatColor( 0, g_iData[ sSound ], "Zene:^3 %s", g_iData[ sName ] );
		
	g_iPrevSound = iRand;
}

public plugin_precache( )
{
	new pFile  = fopen( "addons/amxmodx/configs/musiclist.ini", "rt" );
	
	g_daSounds = ArrayCreate( eMusicInfos );
	
	if ( pFile )
	{
		new sLine[ 200 ];
		
		while ( !feof( pFile ) )
		{
			fgets( pFile, sLine, charsmax( sLine ) );
			if ( sLine[0] == ';' || strlen( sLine ) < 5 ) continue;
			
			parse( sLine, g_iData[ sName ], charsmax( g_iData[ sName ] ), g_iData[ sSound ], charsmax( g_iData[ sSound ] ) );
			
			if ( ( contain( g_iData[ sSound ], ".mp3" ) == -1 ) && ( contain( g_iData[ sSound ], ".wav" ) == -1 ) ) continue;
			
			if( strlen( g_iData[ sName ] ) == 0 ) g_iData[ sName ] = "Ismeretlen";
			
			ArrayPushArray( g_daSounds, g_iData );
			precache_sound( g_iData[ sSound ] );
		}
		fclose( pFile );
	}
	
	g_iSoundsNum = ArraySize( g_daSounds );
	log_amx( "Round End Sounds" );
	log_amx( "%d loaded music.", g_iSoundsNum );
}

public Advertising( ) { ChatColor( 0, "", "Körvégi zenék Ki/Be kapcsolásához:^3 /korvegi^1 ." ); }

public Toggle( iId ) { ChatColor( iId, "", "^3%skapcsoltad^1 a körvégi zenéket!", ( g_bEnabled[ iId ] ^= true ) ? "Be" : "Ki" ); }

public client_putinserver( iId ) { g_bEnabled[ iId ] = true; }

public plugin_end( ) { ArrayDestroy( g_daSounds ); }

stock ChatColor( const iId, sMusic[ ], const sMessage[ ], any:... )
{
	static iPlrNum, iPlayers[32], sMsg[ 256 ], iIdMsg, bool: bPlay;
	
	vformat( sMsg, charsmax( sMsg ), sMessage, 4 );
	format( sMsg, charsmax( sMsg ), "^4[%s]^1 %s", g_sPrefix, sMsg );
 
	if ( !iIdMsg ) iIdMsg = get_user_msgid( "SayText" );
 
	if ( iId )
	{ 
		if( !is_user_connected( iId ) ) return;
		iPlayers[ 0 ] = iId;
		iPlrNum = 1;
	} 
	else get_players( iPlayers, iPlrNum, "ch" );
	
	if ( ( bPlay = strlen( sMusic ) > 0 ) ) format( sMusic, 63, "%s sound/%s", ( contain( sMusic, ".mp3" ) != -1 ) ? "mp3 play" : "spk", sMusic );
 
	for ( new i, iPId; i < iPlrNum; ++i )
	{
		iPId = iPlayers[ i ];
		if ( bPlay )
		{
			if ( !g_bEnabled[ iPId ] ) continue;
			client_cmd( iPId, "%s", sMusic );
		}
		
		message_begin( MSG_ONE, iIdMsg, _, iPId );
		write_byte( iPId );
		write_string( sMsg );
		message_end( );
	}
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
