#include <amxmodx>
#include <amxmisc>
#include <colorchat>

#define PLUGIN "Snake Játék"
#define VERSION "1.2"
#define AUTHOR "BorJomi, RaZ_HU"
#define foodSpawn 8.0

const table_x=12
const table_y=10
new table_symbol[3]
new const TOP10_DIR[] = "addons/amxmodx/data/snake"
new const PREFIX[] = "[Snake]"

new bool:player_snake_control[33],bool:player_snake_sound[33],player_snake[33][table_x*table_y][2],player_snake_way[33],Float:g_game_time[33],player_snake_lengh[33]
new g_game_start[33],snake_food[33][1][2],bool:onetime_start[33]
new g_connect[33]
new extreme_food[11],extreme_names[11][33],normal_food[11],normal_names[11][33],easy_food[11],easy_names[11][33]
new deadOnly, bindThem

enum
{
	WAY_LEFT,
	WAY_RIGHT,
	WAY_UP,
	WAY_DOWN
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_clcmd("say /snake","start_menu_game")
	register_clcmd("say_team /snake","start_menu_game")

	register_clcmd("+snakeleft","snake_left_on")
	register_clcmd("+snakeright","snake_right_on")
	register_clcmd("+snakeup","snake_up_on")
	register_clcmd("+snakedown","snake_down_on")

	register_menucmd(register_menuid("Mygame"),          1023, "Mygamemenu");
	register_menucmd(register_menuid("optiongame"),          1023, "optionmenu");
	register_menucmd(register_menuid("topgame"),          1023, "topmenu");
	
	deadOnly = register_cvar("amx_snakedead", "1")
	bindThem = register_cvar("amx_snakeautobind", "1")

	formatex(table_symbol,2,"0")

	if( !dir_exists(TOP10_DIR) )
		mkdir(TOP10_DIR);
}
public plugin_cfg()
{
	for (new i = 0 ; i < 10; ++i)
	{
		extreme_food[i] = 0;
		normal_food[i] = 0;
		easy_food[i] = 0;
	}

	read_top10("Nehéz")
	read_top10("Normál")
	read_top10("Könnyű")
}
public client_connect(id)
{
	onetime_start[id]=false
	player_snake_control[id]=true
	player_snake_sound[id]=true
	player_snake[id][0][0]=table_x/2 //start x
	player_snake[id][0][1]=table_y/2 //start y
	player_snake_way[id]=WAY_UP
	g_game_time[id]=0.3
	player_snake_lengh[id]=0
	g_game_start[id]=false
	g_connect[id]=true

	if(task_exists(id+123456))
		remove_task(id+123456)
	if(task_exists(id+223456))
		remove_task(id+223456)
}
public client_disconnect(id)
{
	onetime_start[id]=false
	player_snake_control[id]=true
	player_snake_sound[id]=true
	g_connect[id]=false
	g_game_start[id]=false
	player_snake_way[id]=WAY_UP
	g_game_time[id]=0.3
	player_snake_lengh[id]=0

	if(task_exists(id+123456))
		remove_task(id+123456)
	if(task_exists(id+223456))
		remove_task(id+223456)
}
public set_food(id)
{
	id=id-223456

	snake_food[id][0][0]=random_num(0,table_x-1)
	snake_food[id][0][1]=random_num(0,table_y-1)

	set_task(foodSpawn,"set_food",id+223456)
}
public Displaygame(id)
{
	id=id-123456

	if(g_game_start[id])
	{
		for(new i=(player_snake_lengh[id]-1);i>=1;i--)
		{
			player_snake[id][i][0]=player_snake[id][i-1][0]
			player_snake[id][i][1]=player_snake[id][i-1][1]
		}

		switch(player_snake_way[id])
		{
			case 0:
			{

				if(player_snake[id][0][0]<=0)
						player_snake[id][0][0]=table_x

				player_snake[id][0][0]=player_snake[id][0][0]-1
			}
			case 1:
			{
				if(player_snake[id][0][0]>=table_x-1)
					player_snake[id][0][0]=-1

				player_snake[id][0][0]=player_snake[id][0][0]+1
			}
			case 2:
			{
				if(player_snake[id][0][1]<=0)
					player_snake[id][0][1]=table_y

				player_snake[id][0][1]=player_snake[id][0][1]-1
			}
			case 3:
			{
				if(player_snake[id][0][1]>=table_y-1)
					player_snake[id][0][1]=-1

				player_snake[id][0][1]=player_snake[id][0][1]+1
			}
		}

		for(new i=1;i<player_snake_lengh[id];i++)
		{
			if(player_snake[id][i][0]==player_snake[id][0][0] && player_snake[id][i][1]==player_snake[id][0][1])
			{
				client_print_color(id, NORMAL,"^4%s ^3Vesztettél a Snake játékban.",PREFIX)

				switch(g_game_time[id])
				{
					case 0.1:
						Top_update_extreme(id, player_snake_lengh[id]-1)
					case 0.2:
						Top_update_normal(id, player_snake_lengh[id]-1)
					case 0.3:
						Top_update_easy(id, player_snake_lengh[id]-1)
				}
				game_finish(id,1)
			}
		}

		menu_for_game(id)
		set_task(g_game_time[id],"Displaygame",id+123456)
	}
}
public debuga(id)
{
	for(new i=0;i<player_snake_lengh[id];i++)
	{
		server_print("x%d=%d y%d=%d",i,player_snake[id][i][0],i,player_snake[id][i][1])
	}
}
public gamestart(id)
{
	if(!g_game_start[id])
	{
		g_game_start[id]=true
		player_snake_lengh[id]=1

		player_snake[id][0][0]=table_x/2 //start x
		player_snake[id][0][1]=table_y/2 //start y

		snake_food[id][0][0]=random_num(0,table_x-1)
		snake_food[id][0][1]=random_num(0,table_y-1)

		set_task(g_game_time[id],"Displaygame",id+123456)

		set_task(foodSpawn,"set_food",id+223456)

		if(player_snake_control[id] && get_pcvar_num(bindThem) == 1)
		{
			onetime_start[id]=true

			SendCmd(id,"bind ^"uparrow^" ^"+snakeup^"")
			SendCmd(id,"bind ^"downarrow^" ^"+snakedown^"")
			SendCmd(id,"bind ^"leftarrow^" ^"+snakeleft^"")
			SendCmd(id,"bind ^"rightarrow^" ^"+snakeright^"")
		}
	}
	else
	{
		client_print_color(id, NORMAL,"^4%s ^3Már elindult a Snake játékod!",PREFIX)
	}
}
public game_finish(id,type)
{
	g_game_start[id]=false

	if(task_exists(id+123456))
		remove_task(id+123456)
	if(task_exists(id+223456))
		remove_task(id+223456)

	if(player_snake_control[id])
	{
		SendCmd(id,"bind ^"uparrow^" ^"+forward^"")
		SendCmd(id,"bind ^"downarrow^" ^"+back^"")
		SendCmd(id,"bind ^"leftarrow^" ^"+left^"")
		SendCmd(id,"bind ^"rightarrow^" ^"+right^"")
	}

	if(type == 1)
		client_print_color(id, NORMAL,"^4%s ^3A játék véget ért.",PREFIX)
	else if(type == 2)
		client_print_color(id, NORMAL,"^4%s ^3Befejezted a játékot.",PREFIX)
	else
		client_print_color(id, NORMAL,"^4%s ^3Játék újraindítása...",PREFIX)
}
public menu_for_game(id)
{
	new MenuBody[1024], len, keys;
	len = format(MenuBody, 1023, "\dSnake Játék^n");
	if(!player_snake_control[id])
	{
		len += format(MenuBody[len], 1023-len, "^n\r1. \wBal")
		keys |= (1<<0);

		len += format(MenuBody[len], 1023-len, "^n\r2. \wJobb")
		keys |= (1<<1);

		len += format(MenuBody[len], 1023-len, "^n\r3. \wFel")
		keys |= (1<<2);

		len += format(MenuBody[len], 1023-len, "^n\r4. \wLe")
		keys |= (1<<3);

		len += format(MenuBody[len], 1023-len, "^n^n\r9. \wÚjraindítás")
		keys |= (1<<8);

		len += format(MenuBody[len], 1023-len, "^n\r0. \wKilépés^n")
		keys |= (1<<9);
	}
	else
	{
		len += format(MenuBody[len], 1023-len, "^n\r9. \wÚjraindít")
		keys |= (1<<8);

		len += format(MenuBody[len], 1023-len, "^n\r0. \wKilépés^n");
		keys |= (1<<9);

	}
	len += format(MenuBody[len], 1023-len, "^n\wTáplálék:\y %d^n^n",player_snake_lengh[id]-1)

	for(new y=0;y<table_y;y++)
	{
		for(new x=0;x<table_x;x++)
		{
			new bool:find

			for(new i=0;i<player_snake_lengh[id];i++)
			{
				if(player_snake[id][i][0]==x && player_snake[id][i][1]==y)
				{
					len += format(MenuBody[len], 1023-len, "\w%s",table_symbol)

					find=true
					break
				}
			}

			switch(player_snake_way[id])
			{
				case 0:
				{
					if(snake_food[id][0][0]==player_snake[id][0][0] && snake_food[id][0][1]==player_snake[id][0][1])
					{
						snake_food[id][0][0]=-1
						snake_food[id][0][1]=-1
						player_snake_lengh[id]++

						if(player_snake_sound[id])
							client_cmd(id, "spk buttons/blip2");

						for(new i=(player_snake_lengh[id]-1);i>=1;i--)
						{
							player_snake[id][i][0]=player_snake[id][i-1][0]
							player_snake[id][i][1]=player_snake[id][i-1][1]
						}

						player_snake[id][0][0]=player_snake[id][0][0]-1

					}
				}
				case 1:
				{
					if(snake_food[id][0][0]==player_snake[id][0][0] && snake_food[id][0][1]==player_snake[id][0][1])
					{
						snake_food[id][0][0]=-1
						snake_food[id][0][1]=-1
						player_snake_lengh[id]++

						if(player_snake_sound[id])
							client_cmd(id, "spk buttons/blip2");

						for(new i=(player_snake_lengh[id]-1);i>=1;i--)
						{
							player_snake[id][i][0]=player_snake[id][i-1][0]
							player_snake[id][i][1]=player_snake[id][i-1][1]
						}

						player_snake[id][0][0]=player_snake[id][0][0]+1

					}
				}
				case 2:
				{
					if(snake_food[id][0][0]==player_snake[id][0][0] && snake_food[id][0][1]==player_snake[id][0][1]-1)
					{
						snake_food[id][0][0]=-1
						snake_food[id][0][1]=-1
						player_snake_lengh[id]++

						if(player_snake_sound[id])
							client_cmd(id, "spk buttons/blip2");

						for(new i=(player_snake_lengh[id]-1);i>=1;i--)
						{
							player_snake[id][i][0]=player_snake[id][i-1][0]
							player_snake[id][i][1]=player_snake[id][i-1][1]
						}

						player_snake[id][0][1]=player_snake[id][0][1]-1

					}
				}
				case 3:
				{
					if(snake_food[id][0][0]==player_snake[id][0][0] && snake_food[id][0][1]==player_snake[id][0][1])
					{
						snake_food[id][0][0]=-1
						snake_food[id][0][1]=-1
						player_snake_lengh[id]++

						if(player_snake_sound[id])
							client_cmd(id, "spk buttons/blip2");

						for(new i=(player_snake_lengh[id]-1);i>=1;i--)
						{
							player_snake[id][i][0]=player_snake[id][i-1][0]
							player_snake[id][i][1]=player_snake[id][i-1][1]
						}

						player_snake[id][0][1]=player_snake[id][0][1]+1

					}
				}
			}

			if(!find)
			{
				if(snake_food[id][0][0]==x && snake_food[id][0][1]==y)
				{
					len += format(MenuBody[len], 1023-len, "\y%s",table_symbol)
				}
				else
					len += format(MenuBody[len], 1023-len, "\r%s",table_symbol)
			}

			if(x==(table_x-1))
				len += format(MenuBody[len], 1023-len, "^n")
		}
	}

	show_menu(id, keys, MenuBody, -1, "Mygame");

}
public Mygamemenu(id, key)
{
	switch((key+1))
	{
		case 1:
		{
			menu_for_game(id)
			if((player_snake_way[id]!=WAY_RIGHT && player_snake_way[id]!=WAY_LEFT)|| player_snake_lengh[id]==1)
				change_way(id,WAY_LEFT)
		}
		case 2:
		{
			menu_for_game(id)

			if((player_snake_way[id]!=WAY_LEFT && player_snake_way[id]!=WAY_RIGHT) || player_snake_lengh[id]==1)
				change_way(id,WAY_RIGHT)
		}
		case 3:
		{
			menu_for_game(id)
			if((player_snake_way[id]!=WAY_DOWN && player_snake_way[id]!=WAY_UP)|| player_snake_lengh[id]==1)
				change_way(id,WAY_UP)
		}
		case 4:
		{
			menu_for_game(id)
			if((player_snake_way[id]!=WAY_UP && player_snake_way[id]!=WAY_DOWN) || player_snake_lengh[id]==1)
				change_way(id,WAY_DOWN)
		}
		case 9:
		{
			game_finish(id,0)
			gamestart(id)
		}
		case 10:
		{
			game_finish(id,2)
		}

	}
	return PLUGIN_HANDLED;
}
public change_way(id,way)
{
	player_snake_way[id]=way
}
public snake_left_on(id)
{
	if(((player_snake_way[id]!=WAY_RIGHT && player_snake_way[id]!=WAY_LEFT) || player_snake_lengh[id]==1))
		change_way(id,WAY_LEFT)
}
public snake_right_on(id)
{
	if(((player_snake_way[id]!=WAY_LEFT && player_snake_way[id]!=WAY_RIGHT)|| player_snake_lengh[id]==1))
		change_way(id,WAY_RIGHT)
}
public snake_down_on(id)
{
	if(((player_snake_way[id]!=WAY_UP && player_snake_way[id]!=WAY_DOWN) || player_snake_lengh[id]==1))
		change_way(id,WAY_DOWN)
}
public snake_up_on(id)
{
	if(((player_snake_way[id]!=WAY_DOWN && player_snake_way[id]!=WAY_UP) || player_snake_lengh[id]==1))
		change_way(id,WAY_UP)
}
public start_menu_game(id)
{
	if(get_pcvar_num(deadOnly))
		if(is_user_alive(id)){
			client_print_color(id,NORMAL,"^4%s ^3Csak halottként játszhatsz.",PREFIX)
			return;
		}

	if(g_game_start[id])
	{
		client_print_color(id, NORMAL,"^4%s ^3Már elindult a Snake játékod!",PREFIX)
		return;
	}

	new MenuBody[1024], len, keys;
	len = format(MenuBody, 1023, "\dSnake Játék by BorJomi^n\rBeállítások^n^n");

	new level[20]
	get_level_name(g_game_time[id],level,19);


	len += format(MenuBody[len], 1023-len, "^n\r1. \wNehézség:        \y%s",level)
	keys |= (1<<0);

	len += format(MenuBody[len], 1023-len, "^n\r2. \wHangok:           %s",player_snake_sound[id]==true ? "\yBe":"\rKi")
	keys |= (1<<1);

	len += format(MenuBody[len], 1023-len, "^n\r3. \wIrányítás:         %s",player_snake_control[id]==false ? "\rMenü Gombok":"\yFel, Le, Balra, Jobbra")
	keys |= (1<<2);

	if(player_snake_control[id])
	{
		len += format(MenuBody[len], 1023-len, "^n\r4. \wConfig mentése:     \ysnake_game.cfg")
		keys |= (1<<3);
	}
	else
	{
		len += format(MenuBody[len], 1023-len, "^n\r4. \d A mentés bekerül a snake_game.cfg-be")
	}

	len += format(MenuBody[len], 1023-len, "^n^n\r5. \wTop 10 Snake játékos")
	keys |= (1<<4);

	len += format(MenuBody[len], 1023-len, "^n^n\r6. \wIndítás")
	keys |= (1<<5);

	len += format(MenuBody[len], 1023-len, "^n^n\r0. \wKilépés^n^n");
	keys |= (1<<9);

	show_menu(id, keys, MenuBody, -1, "optiongame");

}
public optionmenu(id, key)
{
	switch((key+1))
	{
		case 1:
		{
			if(g_game_time[id]==0.3)
				g_game_time[id]=0.0

			g_game_time[id]=g_game_time[id]+0.1

			start_menu_game(id)
		}
		case 2:
		{
			if(player_snake_sound[id])
				player_snake_sound[id]=false
			else
				player_snake_sound[id]=true
			start_menu_game(id)
		}
		case 3:
		{
			if(player_snake_control[id])
				player_snake_control[id]=false
			else
				player_snake_control[id]=true

			start_menu_game(id)
		}
		case 4:
		{
			SendCmd(id,"writecfg snake_game")
			client_print_color(id, NORMAL,"^4%s ^3A config mentve mint: ^"snake_game.cfg^"",PREFIX)
			start_menu_game(id)
		}
		case 5:
		{
			top_game(id)
		}
		case 6:
		{
			gamestart(id)
		}
	}
	return PLUGIN_HANDLED;
}
public top_game(id)
{
	new MenuBody[1024], len, keys;
	len = format(MenuBody, 1023, "\rToplista^n^n");

	new level[20]
	get_level_name(g_game_time[id],level,19);

	len += format(MenuBody[len], 1023-len, "^n\r1. \wNehéz")
	keys |= (1<<0);

	len += format(MenuBody[len], 1023-len, "^n\r2. \wNormál")
	keys |= (1<<1);

	len += format(MenuBody[len], 1023-len, "^n\r3. \wKönnyű")
	keys |= (1<<2);

	len += format(MenuBody[len], 1023-len, "^n^n\r0. \wKilépés^n");
	keys |= (1<<9);

	show_menu(id, keys, MenuBody, -1, "topgame");
}
public topmenu(id, key)
{
	switch((key+1))
	{
		case 1:
		{
			showtop10(id,extreme_names,extreme_food,"Nehéz")
			top_game(id)
		}
		case 2:
		{
			showtop10(id,normal_names,normal_food,"Normál")
			top_game(id)
		}
		case 3:
		{
			showtop10(id,easy_names,easy_food,"Könnyű")
			top_game(id)
		}
	}
	return PLUGIN_HANDLED;
}
public get_level_name(Float:level, ret_name[], len)
{
	new name[21]
	switch(level)
	{
		case 0.1:
			name = "Nehéz"
		case 0.2:
			name = "Normál"
		case 0.3:
			name = "Könnyű"
	}
	formatex( ret_name, len, name )
}


public save_top10(level[],names[][],food[])
{
	new mapname[33], profile[128]
	get_mapname(mapname, 32)
	formatex(profile, 127, "%s/%s.cfg", TOP10_DIR, level)

	if( file_exists(profile) )
	{
		delete_file(profile)
	}

	new Data[256];
	new f = fopen(profile, "at")

	for(new i = 0; i < 10; i++)
	{
		formatex(Data, 255, "^"%s^" ^"%d^"^n",names[i],food[i])
		fputs(f, Data)
	}
	fclose(f);
}

public read_top10(level[])
{
	new mapname[33], profile[128], prodata[256]
	get_mapname(mapname, 32)
	formatex(profile, 127, "%s/%s.cfg", TOP10_DIR, level)

	new f = fopen(profile, "rt" )
	new i = 0
	while( !feof(f) && i < 11)
	{
		fgets(f, prodata, 255)
		new food[4]
		if(equali(level,"Nehéz"))
		{
			parse(prodata, extreme_names[i], 31, food, 3)
			extreme_food[i]=str_to_num(food)
		}
		else if(equali(level,"Normál"))
		{
			parse(prodata, normal_names[i], 31, food, 3)
			normal_food[i]=str_to_num(food)
		}
		else if(equali(level,"Könnyű"))
		{
			parse(prodata, easy_names[i], 31, food, 3)
			easy_food[i]=str_to_num(food)
		}
		i++;
	}
	fclose(f)
}

public Top_update_extreme(id, food)
{
	new name[32];
	get_user_name(id, name, 31);
	new bool:Is_in_top10
	Is_in_top10 = false

	for(new i = 0; i < 10; i++)
	{
		if( equali(extreme_names[i], name) )
		{
			Is_in_top10 = true
		}
	}

	for (new i = 0; i < 10; i++)
	{
		new tmpfood = extreme_food[i]

		if( food > extreme_food[i])
		{
			new pos = i

			while( !equal(extreme_names[pos], name) && pos < 10 )
			{
				pos++;
			}

			for (new j = pos; j > i; j--)
			{
				formatex(extreme_names[j], 31, extreme_names[j-1]);
				extreme_food[j] = extreme_food[j-1];
			}

			formatex(extreme_names[i], 31, name);
			extreme_food[i] = food

			save_top10("Nehéz",extreme_names,extreme_food)

			if( Is_in_top10 )
			{
				if( food > tmpfood )
				{
					if( (i + 1) == 1)
					{
						client_print_color(id, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, te %d táplálékot ettél.",PREFIX,name,food)
					}
					else
					{
						client_print_color(0, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, bekerült a %d. Nehéz helyre, mivel %d táplálékot evett!",PREFIX,name,(i+1),food)
					}
				}
			}
			else
			{
				if( (i + 1) == 1)
				{
					client_print_color(id, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, te %d táplálékot ettél.",PREFIX,name,food)
				}
				else
				{
					client_print_color(0, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, bekerült a %d. Nehéz helyre, mivel %d táplálékot evett!",PREFIX,name,(i+1),food)
				}
			}

			return;
		}
	}
}

public Top_update_normal(id, food)
{
	new name[32];
	get_user_name(id, name, 31);
	new bool:Is_in_top10
	Is_in_top10 = false

	for(new i = 0; i < 10; i++)
	{
		if( equali(normal_names[i], name) )
		{
			Is_in_top10 = true
		}
	}

	for (new i = 0; i < 10; i++)
	{
		new tmpfood = normal_food[i]

		if( food > normal_food[i])
		{
			new pos = i

			while( !equal(normal_names[pos], name) && pos < 10 )
			{
				pos++;
			}

			for (new j = pos; j > i; j--)
			{
				formatex(normal_names[j], 31, normal_names[j-1]);
				normal_food[j] = normal_food[j-1];
			}

			formatex(normal_names[i], 31, name);
			normal_food[i] = food

			save_top10("Normál",normal_names,normal_food)

			if( Is_in_top10 )
			{
				if( food > tmpfood )
				{

					if( (i + 1) == 1)
					{
						client_print_color(id, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, te %d táplálékot ettél.",PREFIX,name,food)
					}
					else
					{
						client_print_color(0, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, bekerült a %d. Normál helyre, mivel %d táplálékot evett!",PREFIX,name,(i+1),food)
					}
				}
			}
			else
			{
				if( (i + 1) == 1)
				{
					client_print_color(id, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, te %d táplálékot ettél.",PREFIX,name,food)
				}
				else
				{
					client_print_color(0, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, bekerült a %d. Normál helyre, mivel %d táplálékot evett!",PREFIX,name,(i+1),food)
				}
			}

			return;
		}
	}
}

public Top_update_easy(id, food)
{
	new name[32];
	get_user_name(id, name, 31);
	new bool:Is_in_top10
	Is_in_top10 = false

	for(new i = 0; i < 10; i++)
	{
		if( equali(easy_names[i], name) )
		{
			Is_in_top10 = true
		}
	}

	for (new i = 0; i < 10; i++)
	{
		new tmpfood = easy_food[i]

		if( food > easy_food[i])
		{
			new pos = i

			while( !equal(easy_names[pos], name) && pos < 10 )
			{
				pos++;
			}

			for (new j = pos; j > i; j--)
			{
				formatex(easy_names[j], 31, easy_names[j-1]);
				easy_food[j] = easy_food[j-1];
			}

			formatex(easy_names[i], 31, name);
			easy_food[i] = food

			save_top10("Könnyű",easy_names,easy_food)

			if( Is_in_top10 )
			{
				if( food > tmpfood )
				{

					if( (i + 1) == 1)
					{
						client_print_color(id, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, te %d táplálékot ettél.",PREFIX,name,food)
					}
					else
					{
						client_print_color(0, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, bekerült a %d. Könnyű helyre, mivel %d táplálékot evett!",PREFIX,name,(i+1),food)
					}
				}
			}
			else
			{
				if( (i + 1) == 1)
				{
					client_print_color(id, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, te %d táplálékot ettél.",PREFIX,name,food)
				}
				else
				{
					client_print_color(0, NORMAL,"^4%s ^3Gratulálunk ^1%s^3, bekerült a %d. Könnyű helyre, mivel %d táplálékot evett!",PREFIX,name,(i+1),food)
				}
			}

			return;
		}
	}
}

public showtop10(id,names[][],food[],level[])
{
	new buffer[2048]

	new len = formatex(buffer, 2047,"<meta http-equiv=^"Content-Type^" content=^"text/html;charset=UTF-8^">")
	len += formatex(buffer[len], 2047, "<body bgcolor=#FFFFFF><table width=100%% cellpadding=2 cellspacing=0 border=0>")
	len += formatex(buffer[len], 2047-len, "<tr  align=center bgcolor=#52697B><th width=5%%> # <th width=35%% align=left> Játékos <th width=20%%> Táplálékszám")

	for (new i = 0; i < 10; i++)
	{
		if(food[i]== 0)
		{
			len += formatex(buffer[len], 2047-len, "<tr align=center%s><td> %d <td align=left> %s <td> %s", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), "-", "-")
		}
		else
		{
			while (containi(names[i], "<") != -1)
				replace(names[i], 129, "<", "&lt;")
			while (containi(names[i], ">") != -1)
				replace(names[i], 129, ">", "&gt;")
			len += formatex(buffer[len], 2047-len, "<tr align=center%s><td> %d <td align=left> %s <td> %d", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), names[i],food[i])
		}
	}

	len += formatex(buffer[len], 2047-len, "</table></body>")
	len += formatex(buffer[len], 2047-len, "<tr><Center><b>Snake Játékot készítette: BorJomi<BR>© 2011")
	len += formatex(buffer[len], 2047-len, "<tr><Center>Frissítette: RaZ_HU")

	new info[21]
	formatex(info,20,"%s Toplista",level)
	show_motd(id, buffer, info)

	return PLUGIN_HANDLED
}

// @ mforce
stock SendCmd(id, const szText[], any:...) {
	static szCmd[128]; vformat(szCmd, charsmax(szCmd), szText, 3);
	message_begin(MSG_ONE, SVC_DIRECTOR, _, id);
	write_byte(strlen(szCmd) + 2);
	write_byte(10); //SVC_DIRECTOR_STUFFTEXT
	write_string(szCmd);
	message_end();
}
