#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <fun>
#include <hamsandwich>
#include <cstrike>

new V_MODEL[] = "models/v_buffawp.mdl";
new P_MODEL[] = "models/p_buffawp.mdl";
new W_MODEL[] = "models/w_buffawp.mdl";

new bool:g_HasGun[33], g_SyncHud[3], g_Cvar[7];
new g_Charge[33], g_TmpClip[33], g_IsInPrimaryAttack[33], g_Zoomed[33];

public plugin_init()
{
	register_plugin("[CSO] Wpn: AWP Elven Ranger", "1.0.0", "JohanCorn");
	
	register_clcmd("say /get_buffawp", "get_wpn");
	
	RegisterHam(Ham_Item_Deploy, "weapon_awp", "fw_Item_Deploy_Post", 1);
	RegisterHam(Ham_Item_PostFrame, "weapon_awp", "fw_Item_PostFrame");
	RegisterHam(Ham_Item_AddToPlayer, "weapon_awp", "fw_Item_AddToPlayer");
	RegisterHam(Ham_Weapon_Reload, "weapon_awp", "fw_Weapon_Reload");
	RegisterHam(Ham_Weapon_Reload, "weapon_awp", "fw_Weapon_Reload_Post", 1);
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_awp", "fw_Weapon_PrimaryAttack_Post", 1);
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage");
	
	register_message(get_user_msgid("DeathMsg"), "message_DeathMsg");
	
	g_Cvar[0] = register_cvar("wpn_buffawp_charge_hud", "2");
	g_Cvar[1] = register_cvar("wpn_buffawp_ammo_max", "30");
	g_Cvar[2] = register_cvar("wpn_buffawp_ammo_clip", "20");
	g_Cvar[3] = register_cvar("wpn_buffawp_multi_damage_none", "2.34");
	g_Cvar[4] = register_cvar("wpn_buffawp_multi_damage_yellow", "3.50");
	g_Cvar[5] = register_cvar("wpn_buffawp_multi_damage_orange", "4.91");
	g_Cvar[6] = register_cvar("wpn_buffawp_multi_damage_red", "6.55");
	
	register_forward(FM_SetModel, "fw_SetModel");
	
	register_event("SetFOV", "event_SetFOV", "be");
	register_event("DeathMsg", "event_DeathMsg", "a");
	
	g_SyncHud[0] = CreateHudSyncObj();
	g_SyncHud[1] = CreateHudSyncObj();
	g_SyncHud[2] = CreateHudSyncObj();
}

public client_disconnect(id)
	g_HasGun[id] = false;

public plugin_precache()
{
	register_clcmd("weapon_buffawp", "weapon_hook");
	
	precache_model(V_MODEL);
	precache_model(P_MODEL);
	precache_model(W_MODEL);
	
	precache_sound("weapons/awpbuff_clipin.wav");
	precache_sound("weapons/awpbuff_clipout.wav");
	precache_sound("weapons/awpbuff_idle.wav");
	precache_sound("weapons/awpbuff_reload.wav");
	precache_sound("weapons/awpbuff-1.wav");
	
	precache_generic("sprites/weapon_buffawp.txt");
	precache_generic("sprites/640hud135.spr");
}

public event_SetFOV(id)
{
	if(get_user_weapon(id))
	{
		switch (read_data(1))
		{
			case 5..24:
			{
				if(!g_Zoomed[id])
				{
					remove_task(id+20160918);
					set_task_charge(id+20160918);
				}
			}
			case 25..55:
			{
				remove_task(id+20160918);
				set_task_charge(id+20160918);
				
				g_Zoomed[id] = 1;
			}
			case 90:
			{
				ClearSyncHud(id, g_SyncHud[0]);
				ClearSyncHud(id, g_SyncHud[1]);
				ClearSyncHud(id, g_SyncHud[2]);
				
				remove_task(id+20160918);
				g_Charge[id] = 0;
				g_Zoomed[id] = 0;
			}
		}
	}
}

public event_DeathMsg()
{
	new id = read_data(2);
	
	g_HasGun[id] = false;
	
	remove_task(id+20160918);
	
	ClearSyncHud(id, g_SyncHud[0]);
	ClearSyncHud(id, g_SyncHud[1]);
	ClearSyncHud(id, g_SyncHud[2]);
	
	return PLUGIN_CONTINUE;
}

public weapon_hook(id)
{
	engclient_cmd(id, "weapon_awp");
	
	return PLUGIN_HANDLED;
}

public get_wpn(id)
{
	UTIL_DropWeapon(id, 1);
	
	new iWep = give_item(id,"weapon_awp");
	
	if(iWep)
	{
		cs_set_weapon_ammo(iWep, get_pcvar_num(g_Cvar[2]));
		cs_set_user_bpammo (id, CSW_AWP, get_pcvar_num(g_Cvar[1]));
		set_pdata_float(id, 83, 1.0, 5);
		
		g_HasGun[id] = true;
		
		message_begin(MSG_ONE, get_user_msgid("WeaponList"), {0,0,0}, id);
		write_string("weapon_buffawp");
		write_byte(1);
		write_byte(30);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(2);
		write_byte(CSW_AWP);
		write_byte(0);
		message_end();
		
		set_pev(id, pev_viewmodel2, V_MODEL);
		set_pev(id, pev_weaponmodel2, P_MODEL);
	}
}

public fw_Item_Deploy_Post(entity)
{
	static id;
	id = get_pdata_cbase(entity, 41, 4)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;
	
	if (!g_HasGun[id])
		return HAM_IGNORED;
	
	set_pev(id, pev_viewmodel2, V_MODEL);
	set_pev(id, pev_weaponmodel2, P_MODEL);
	
	return HAM_IGNORED;
}

public fw_Weapon_Reload(entity) 
{
	static id;
	id = get_pdata_cbase(entity, 41, 4)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;
	
	if (!g_HasGun[id])
		return HAM_IGNORED;
	
	g_TmpClip[id] = -1;
	
	new iBpAmmo = cs_get_user_bpammo(id, CSW_AWP);
	new iClip = get_pdata_int(entity, 51, 4);
	
	if(iBpAmmo <= 0)
		return HAM_SUPERCEDE;
	
	if(iClip >= get_pcvar_num(g_Cvar[2]))
		return HAM_SUPERCEDE;
	
	g_TmpClip[id] = iClip;
	
	return HAM_IGNORED;
}

public fw_Weapon_Reload_Post(entity) 
{
	static id;
	id = get_pdata_cbase(entity, 41, 4)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_HasGun[id])
		return HAM_IGNORED;

	if (g_TmpClip[id] == -1)
		return HAM_IGNORED;

	set_pdata_int(entity, 51, g_TmpClip[id], 4);
	set_pdata_int(entity, 54, 1, 4);

	return HAM_IGNORED;
}

public fw_Item_PostFrame(entity) 
{
	static id;
	id = get_pdata_cbase(entity, 41, 4)
	
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_HasGun[id])
		return HAM_IGNORED;
	
	new Float:flNextAttack = get_pdata_float(id, 83, 5)
	
	new iBpAmmo = cs_get_user_bpammo(id, CSW_AWP);
	new iClip = get_pdata_int(entity, 51, 4);
	new fInReload = get_pdata_int(entity, 54, 4);
	
	if(fInReload && flNextAttack <= 0.0)
	{
		new j = min(get_pcvar_num(g_Cvar[2]) - iClip, iBpAmmo);
		
		set_pdata_int(entity, 51, iClip + j, 4);
		cs_set_user_bpammo(id, CSW_AWP, iBpAmmo-j);
		
		set_pdata_int(entity, 54, 0, 4);
		fInReload = 0;
	}
	
	return HAM_IGNORED;
}

public fw_Weapon_PrimaryAttack_Post(entity)
{
	static id;
	id = get_pdata_cbase(entity, 41, 4);
	
	g_IsInPrimaryAttack[id] = 0;
	
	new szClip, szAmmo;
	get_user_weapon(id, szClip, szAmmo);
	
	if(!is_user_alive(id))
		return HAM_IGNORED;
		
	if (!g_HasGun[id])
		return HAM_IGNORED;

	if (!g_TmpClip[id])
		return HAM_IGNORED;
	
	emit_sound(id, CHAN_WEAPON, "weapons/awpbuff-1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
	
	return HAM_IGNORED;
}

public fw_Item_AddToPlayer(entity, id)
{
	if(!is_valid_ent(entity) || !is_user_connected(id))
		return HAM_IGNORED;
	
	if(entity_get_int(entity, EV_INT_impulse) == 20160918)
	{
		g_HasGun[id] = true;
		
		entity_set_int(entity, EV_INT_impulse, 0);
		
		message_begin(MSG_ONE, get_user_msgid("WeaponList"), {0,0,0}, id);
		write_string("weapon_buffawp");
		write_byte(1);
		write_byte(30);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(2);
		write_byte(CSW_AWP);
		write_byte(0);
		message_end();
		
		return HAM_HANDLED;
	}
	else
	{
		message_begin(MSG_ONE, get_user_msgid("WeaponList"), {0,0,0}, id);
		write_string("weapon_awp");
		write_byte(1);
		write_byte(30);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(2);
		write_byte(CSW_AWP);
		write_byte(0);
		message_end();
		
		return HAM_HANDLED;
	}
	
	return HAM_IGNORED;
}

public fw_SetModel(entity, model[])
{
	if(!is_valid_ent(entity))
		return FMRES_IGNORED;
	
	static szClassName[33];
	entity_get_string(entity, EV_SZ_classname, szClassName, charsmax(szClassName));
		
	if(!equal(szClassName, "weaponbox"))
		return FMRES_IGNORED;
	
	static iOwner;
	iOwner = entity_get_edict(entity, EV_ENT_owner);
	
	if(equal(model, "models/w_awp.mdl"))
	{
		static iStoredAwpID;
		iStoredAwpID = find_ent_by_owner(-1, "weapon_awp", entity);
	
		if(!is_valid_ent(iStoredAwpID))
			return FMRES_IGNORED;
	
		if(g_HasGun[iOwner])
		{
			entity_set_int(iStoredAwpID, EV_INT_impulse, 20160918);
			entity_set_model(entity, W_MODEL);
			
			g_HasGun[iOwner] = false;
			
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED;
}

public message_DeathMsg(msg_id, msg_dest, id)
{
	static szTruncatedWeapon[33], iAttacker, iVictim;
	get_msg_arg_string(4, szTruncatedWeapon, charsmax(szTruncatedWeapon))
	
	iAttacker = get_msg_arg_int(1);
	iVictim = get_msg_arg_int(2);
	
	if(!is_user_connected(iAttacker) || iAttacker == iVictim)
		return PLUGIN_CONTINUE;
	
	if(equal(szTruncatedWeapon, "awp") && get_user_weapon(iAttacker) == CSW_AWP)
		if(g_HasGun[iAttacker])
			set_msg_arg_string(4, "AWP Elven Ranger");
	
	return PLUGIN_CONTINUE;
}

public show_hudmessage_charge(id)
{
	if(get_pcvar_num(g_Cvar[0]) == 1)
	{
		if(g_Charge[id] == 1)
		{
			set_hudmessage(250, 250, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "-----              ");
		}
		else if(g_Charge[id] == 2)
		{
			set_hudmessage(250, 100, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "----- -----       ");
		}
		else if(g_Charge[id] == 3)
		{
			set_hudmessage(250, 0, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "----- ----- -----");
		}
		else
			ClearSyncHud(id, g_SyncHud[0]);
	}
	else if(get_pcvar_num(g_Cvar[0]) == 2)
	{
		if(g_Charge[id] == 1)
		{
			set_hudmessage(150, 150, 150, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "       ----- -----");
			
			set_hudmessage(250, 250, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[1], "-----              ");
			
			ClearSyncHud(id, g_SyncHud[2]);
		}
		else if(g_Charge[id] == 2)
		{
			set_hudmessage(150, 150, 150, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "              -----");
			
			set_hudmessage(250, 250, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[1], "-----              ");
			
			set_hudmessage(250, 100, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[2], "       -----       ");
		}
		else if(g_Charge[id] == 3)
		{
			set_hudmessage(250, 0, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "              -----");
			
			set_hudmessage(250, 250, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[1], "-----              ");
			
			set_hudmessage(250, 100, 0, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[2], "       -----       ");
		}
		else
		{
			set_hudmessage(150, 150, 150, -1.0, 0.75, 0, 1.0, 1.0);
			ShowSyncHudMsg(id, g_SyncHud[0], "----- ----- -----");
			
			ClearSyncHud(id, g_SyncHud[1]);
			ClearSyncHud(id, g_SyncHud[2]);
		}
	}
}

public set_task_charge(id)
{
	id = id-20160918;
	
	if(get_pcvar_num(g_Cvar[0]))
		show_hudmessage_charge(id);
	
	if(g_Charge[id] < 3)
		g_Charge[id] ++;
		
	set_task(1.0, "set_task_charge", id+20160918);
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage)
{
	if (victim != attacker && is_user_connected(attacker))
		if(get_user_weapon(attacker) == CSW_AWP)
			if(g_HasGun[attacker])
			{
				if(g_Charge[attacker] == 1)
					SetHamParamFloat(4, damage * get_pcvar_float(g_Cvar[4]));
				else if(g_Charge[attacker] == 2)
					SetHamParamFloat(4, damage * get_pcvar_float(g_Cvar[5]));
				else if(g_Charge[attacker] == 3)
					SetHamParamFloat(4, damage * get_pcvar_float(g_Cvar[6]));
				else
					SetHamParamFloat(4, damage * get_pcvar_float(g_Cvar[3]));
					
				set_hudmessage(255, 0, 0, -1.0, 0.46, 0, 0.2, 0.2);
				show_hudmessage(attacker, "\  /^n/  \");
			}
}

stock UTIL_DropWeapon(id, slot)
{
	if(!(1 <= slot <= 2))
		return 0;
	
	static iCount; iCount = 0;
	static iEntity; iEntity = get_pdata_cbase(id, (367 + slot), 5);
	
	if(iEntity > 0)
	{
		static iNext;
		static szWeaponName[32];
		
		do {
			iNext = get_pdata_cbase(iEntity, 42, 4);
			
			if(get_weaponname(cs_get_weapon_id(iEntity), szWeaponName, charsmax(szWeaponName)))
			{  
				engclient_cmd(id, "drop", szWeaponName);
				iCount++;
			}
		}
		
		while(( iEntity = iNext) > 0);
	}
	
	return iCount;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
