#if defined _hudchat_included
	#endinput
#endif

#define _hudchat_included

#include <amxmodx>

#define __HUDCHAT_MAXLINES		5
#define __HUDCHAT_MAXMSGLEN		128
#define __HUDCHAT_UPDATEINTERVAL	0.5

#define __HUDCHAT_POS_X			0.01
#define __HUDCHAT_POS_Y			0.22

#define __HUDCHAT_TASKID_UPDATE		32462847
#define __HUDCHAT_TASKID_REMOVE		56723876

stock __HUDCHAT_R = 255;
stock __HUDCHAT_G = 255;
stock __HUDCHAT_B = 255;

stock __HUDCHAT_CHANNEL = 2;

stock Float:__HUDCHAT_REMOVETIME = 5.0;

stock Array:__HUDCHAT_MESSAGES[33];
stock __HUDCHAT_MSGCOUNT[33];

stock __HUDCHAT_MAXPLAYERS;

stock hudchat_init()
{
	__HUDCHAT_MAXPLAYERS = get_maxplayers();
	
	for(new i = 1; i <= __HUDCHAT_MAXPLAYERS; i++)
	{
		__HUDCHAT_MESSAGES[i] = ArrayCreate(__HUDCHAT_MAXMSGLEN);
		__HUDCHAT_MSGCOUNT[i] = 0;
	}
}

stock hudchat_end()
{
	for(new i = 1; i <= __HUDCHAT_MAXPLAYERS; i++)
	{
		ArrayDestroy(__HUDCHAT_MESSAGES[i]);
		__HUDCHAT_MSGCOUNT[i] = 0;
		
		remove_task(i + __HUDCHAT_TASKID_REMOVE);
		remove_task(i + __HUDCHAT_TASKID_UPDATE);
	}
}

stock hudchat_update(id)
{
	if(id)
	{
		new taskid = id + __HUDCHAT_TASKID_UPDATE;
		
		__TaskShowHudChat(taskid);
		
		remove_task(taskid);
		set_task(__HUDCHAT_UPDATEINTERVAL, "__TaskShowHudChat", taskid, .flags = "b");
	}
	else
	{
		for(id = 1; id <= __HUDCHAT_MAXPLAYERS; id++)
		{
			hudchat_update(id);
		}
	}
}

stock hudchat_get_maxlines()
{
	return __HUDCHAT_MAXLINES;
}

stock hudchat_set_color(r, g, b)
{
	__HUDCHAT_R = (r & 255);
	__HUDCHAT_G = (g & 255);
	__HUDCHAT_B = (b & 255);
}

stock hudchat_get_color(&r, &g, &b)
{
	r = __HUDCHAT_R;
	g = __HUDCHAT_G;
	b = __HUDCHAT_B;
}

stock hudchat_set_removetime(Float:_time)
{
	if(_time > 0.0 )
	{
		__HUDCHAT_REMOVETIME = _time;
	}
}

stock Float:hudchat_get_removetime()
{
	return __HUDCHAT_REMOVETIME;
}

stock hudchat_set_channel(channel)
{
	__HUDCHAT_CHANNEL = channel;
}

stock hudchat_get_channel()
{
	return __HUDCHAT_CHANNEL;
}

stock hudchat_show(id, const msg[], any:...)
{
	new message[__HUDCHAT_MAXMSGLEN];
	vformat(message, charsmax(message), msg, 3);
	
	if(id)
	{
		while(__HUDCHAT_MSGCOUNT[id] >= __HUDCHAT_MAXLINES)
		{
			ArrayDeleteItem(__HUDCHAT_MESSAGES[id], 0);
			__HUDCHAT_MSGCOUNT[id]--;
		}
		
		ArrayPushString(__HUDCHAT_MESSAGES[id], message);
		__HUDCHAT_MSGCOUNT[id]++;
		
		new taskid = id + __HUDCHAT_TASKID_REMOVE;
		
		remove_task(taskid);
		set_task(__HUDCHAT_REMOVETIME, "__TaskRemoveHudChat", taskid);
	}
	else
	{
		for(id = 1; id <= __HUDCHAT_MAXPLAYERS; id++)
		{
			hudchat_show(id, "%s", message);
		}
	}
}

stock hudchat_clear(id)
{
	if(id)
	{
		ArrayClear(__HUDCHAT_MESSAGES[id]);
		__HUDCHAT_MSGCOUNT[id] = 0;
		
		remove_task(id + __HUDCHAT_TASKID_REMOVE);
		remove_task(id + __HUDCHAT_TASKID_UPDATE);
	}
	else
	{
		for(id = 1; id <= __HUDCHAT_MAXPLAYERS; id++)
		{
			hudchat_clear(id);
		}
	}
}

public __TaskShowHudChat(id)
{
	id -= __HUDCHAT_TASKID_UPDATE;
	
	new message[__HUDCHAT_MAXMSGLEN];
	new messages[((__HUDCHAT_MAXMSGLEN - 1) * __HUDCHAT_MAXLINES) + __HUDCHAT_MAXLINES];
	new m, len;
	
	for(m = 0; m < __HUDCHAT_MSGCOUNT[id]; m++)
	{
		ArrayGetString(__HUDCHAT_MESSAGES[id], m, message, charsmax(message));
		
		len += formatex(messages[len], charsmax(messages) - len, "%s%s", (len > 0) ? "^n" : "", message);
	}
	
	messages[len] = 0;
	
	set_hudmessage(__HUDCHAT_R, __HUDCHAT_G, __HUDCHAT_B, __HUDCHAT_POS_X, __HUDCHAT_POS_Y, 0, 0.0, (__HUDCHAT_UPDATEINTERVAL + 0.1), 0.0, 0.0, __HUDCHAT_CHANNEL);
	show_hudmessage(id, "%s", messages);
}

public __TaskRemoveHudChat(taskid)
{
	new id = taskid - __HUDCHAT_TASKID_REMOVE;
	
	if(__HUDCHAT_MSGCOUNT[id] > 0)
	{
		ArrayDeleteItem(__HUDCHAT_MESSAGES[id], 0);
		
		if(--__HUDCHAT_MSGCOUNT[id] > 0)
		{
			set_task(__HUDCHAT_REMOVETIME, "__TaskRemoveHudChat", taskid);
		}
	}
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang11274\\ f0\\ fs16 \n\\ par }
*/
