#include < amxmodx >
#include < amxmisc >
#include < fakemeta >
#include < engine >
#include < sqlx >

//#define USE_ICHAT

#if defined USE_ICHAT
	#include < ichat >
#endif

#pragma semicolon 1

#define MinOnlineTime 18000
#define SubPoint 200
#define MaxRang 19

new const g_sPrefix[ ] = "Prefix";

new const g_sTable[ ] = "rang_system_new";
new const g_sSQL_INFOS[ ][ ] =
{
	"Host",    	// HOST
	"Username",     // USERNAME
	"Password",     // PASSWORD
	"DB"      	// DATABASE
};
new Handle: g_iSqlTuple;

enum _:ePlayerInfos { iOnlineTime, iOnlineTimeW, iKills, iDeaths, iPoints, iFCTime, sPrefix[ 16 ] };
enum _:eRangInfos { sRangName[ 32 ], iRangPoint };

new g_iUserData[ 33 ][ ePlayerInfos ];
new const g_iRangs[ MaxRang ][ eRangInfos ] =
{
	{ "Újonc", 0 },
	{ "Honvéd", 300 },
	{ "Õrvezetõ", 500 },
	{ "Tizedes", 700 },
	{ "Szakaszvezetõ", 900 },
	{ "Õrmester", 1100 },
	{ "Törzsõrmester", 1400 },
	{ "Fõtörzsõrmester", 1700 },
	{ "Hadnagy", 2100 },
	{ "Fõhadnagy", 2600 },
	{ "Százados", 3300 },
	{ "Õrnagy", 4000 },
	{ "Alezredes", 4600 },
	{ "Ezredes", 5300 },
	{ "Dandártábornok", 6500 },
	{ "Vezérnagy", 8000 },
	{ "Altábornok", 10000 },
	{ "Vezérezredes", 12000 },
	{ "Egyedi prefix", 15000 }
};
new g_iRoundKills[ 33 ], g_iRang[ 33 ], g_sAuthID[ 33 ][ 32 ], g_sUsername[ 33 ][ 32 ], bool: g_bHud[ 33 ];

public plugin_init( )
{
	register_plugin( "Rang Rendszer", "1.0", "Demon" );
	register_cvar( "Rang Rendsze", "By Demon", FCVAR_SERVER );
	
	register_dictionary( "RangSystem.txt" );
	
	g_iSqlTuple = SQL_MakeDbTuple( g_sSQL_INFOS[ 0 ], g_sSQL_INFOS[ 1 ], g_sSQL_INFOS[ 2 ], g_sSQL_INFOS[ 3 ] );
	
	new sThread[ 512 ];
	formatex( sThread, charsmax( sThread ), "CREATE TABLE IF NOT EXISTS `%s` (`authid` varchar(32) NOT NULL,`online_time` INT(11) NOT NULL,`online_timew` INT(11) NOT NULL,`kills` INT(11) NOT NULL,`deaths` INT(11) NOT NULL,`points` INT(11) NOT NULL,`first_con_time` INT(15) NOT NULL,`prefix` varchar(16) NOT NULL,`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY);", g_sTable );
	
	SQL_ThreadQuery( g_iSqlTuple, "ThreadHandler", sThread, { 0 }, 1 );
	
	Load( );
	
	register_event( "SendAudio", "evCTWin", "a", "2&%!MRAD_ctwin" );
	register_event( "SendAudio", "evTEWin", "a", "2&%!MRAD_terwin" );
	register_event( "DeathMsg", "evDeath", "a" );
	
	register_clcmd( "say /hud", "cmdHud" );
	register_clcmd( "say /rang", "cmdRang" );
	register_clcmd( "say /myrank", "cmdRang" );
	register_clcmd( "say /rangok", "cmdRangs" );
	register_clcmd( "say /ranks", "cmdRangs" );
	register_clcmd( "say /prefix", "cmdPrefix" );
	register_clcmd( "reset_prefix", "cmdResetPrefix", ADMIN_RCON, "<jatekos> - Reset prefix." );
	
	register_concmd( "PREFIX", "GetPrefix" );
	
	register_forward( FM_ClientUserInfoChanged, "fwClientUserInfoChanged" );
}

public plugin_natives( )
{
	register_library( "rang_sys" );
	register_native( "get_user_rang", "_get_rang", 1 );
}
 
public _get_rang( iPlayerId, sRang[ ], iLen )
{
	param_convert( 2 );
	if ( g_iRang[ iPlayerId ] >= MaxRang ) copy( sRang, iLen, g_iUserData[ iPlayerId ][ sPrefix ] );
	else copy( sRang, iLen, g_iRangs[ g_iRang[ iPlayerId ] - 1 ][ sRangName ] );
}

public SaveDatas( iPlayerId, iMode )
{
	static sText[ 512 ];
	
	if ( iMode == 1 ) formatex( sText, charsmax( sText ), "INSERT INTO `%s` (`authid`,`first_con_time`,`prefix`) VALUES (^"%s^",^"%d^",^"%s^");", g_sTable, g_sAuthID[ iPlayerId ], get_systime( ), g_iRangs[ MaxRang - 1 ][ sRangName ] );
	else if ( iMode == 2 ) formatex( sText, charsmax( sText ), "UPDATE `%s` SET online_time = ^"%d^", online_timew = ^"%d^", kills = ^"%d^", deaths = ^"%d^", points = ^"%d^", prefix = ^"%s^" WHERE authid = ^"%s^";", g_sTable, g_iUserData[ iPlayerId ][ iOnlineTime ], g_iUserData[ iPlayerId ][ iOnlineTimeW ], g_iUserData[ iPlayerId ][ iKills ], g_iUserData[ iPlayerId ][ iDeaths ], g_iUserData[ iPlayerId ][ iPoints ], g_iUserData[ iPlayerId ][ sPrefix ], g_sAuthID[ iPlayerId ] );
	else if ( iMode == 3 ) formatex( sText, charsmax( sText ), "UPDATE `%s` SET online_timew = ^"0^";", g_sTable );
	else formatex( sText, charsmax( sText ), "UPDATE `%s` SET points = points - %d WHERE %d - first_con_time > 604799 AND online_timew < %d AND points > %d;", g_sTable, SubPoint, get_systime( ), MinOnlineTime, ( SubPoint - 1 ) );
	
	SQL_ThreadQuery( g_iSqlTuple, "ThreadHandler", sText, { 0 }, 1 );
}

public LoadDatas( iPlayerId )
{
	static sText[ 128 ], iArray[ 1 ];
	
	formatex( sText, charsmax( sText ), "SELECT * FROM `%s` WHERE authid = ^"%s^";", g_sTable, g_sAuthID[ iPlayerId ] );
	iArray[ 0 ] = iPlayerId;
	
	SQL_ThreadQuery( g_iSqlTuple, "ThreadHandler", sText, iArray, sizeof ( iArray ) );
}

public ThreadHandler( iFailState, Handle:iQuery, const sErrorMsg[ ], iErrorCode, const iARRAY[ ], iArraySize, Float:fQueueTime )
{
	if ( iFailState == TQUERY_CONNECT_FAILED )
	{
		set_fail_state( "Nem tudtam csatlakozni az adatbazishoz." );
		return;
	}
	else if ( iFailState == TQUERY_QUERY_FAILED )
	{
		set_fail_state( "Query Error" );
		return;
	}
	
	if ( iErrorCode )
	{
		log_amx( "%i - %s", iErrorCode, sErrorMsg );
		return;
	}
	
	new iPlayerId = iARRAY[ 0 ];
	if ( iPlayerId )
	{
		if ( SQL_NumResults( iQuery ) > 0 )
		{
			g_iUserData[ iPlayerId ][ iOnlineTime ] = SQL_ReadResult( iQuery, 1 );
			g_iUserData[ iPlayerId ][ iOnlineTimeW ] = SQL_ReadResult( iQuery, 2 );
			g_iUserData[ iPlayerId ][ iKills ] = SQL_ReadResult( iQuery, 3 );
			g_iUserData[ iPlayerId ][ iDeaths ] = SQL_ReadResult( iQuery, 4 );
			g_iUserData[ iPlayerId ][ iPoints ] = SQL_ReadResult( iQuery, 5 );
			g_iUserData[ iPlayerId ][ iFCTime ] = SQL_ReadResult( iQuery, 6 );
			SQL_ReadResult( iQuery, 7, g_iUserData[ iPlayerId ][ sPrefix ], charsmax( g_iUserData[ ][ sPrefix ] ) );
			
			g_iRang[ iPlayerId ] = 0;
			for ( new i; i < MaxRang; ++i ) if ( g_iUserData[ iPlayerId ][ iPoints ] >= g_iRangs[ i ][ iRangPoint ] ) ++g_iRang[ iPlayerId ];
			
#if defined USE_ICHAT
			if ( g_iRang[ iPlayerId ] >= MaxRang ) iChatSendCustomData( iPlayerId, 0, g_iUserData[ iPlayerId ][ sPrefix ] );
			else iChatSendCustomData( iPlayerId, 0, g_iRangs[ g_iRang[ iPlayerId ] - 1 ][ sRangName ] );
#endif
		}
		else SaveDatas( iPlayerId, 1 );
	}
	
	return;
}

public evCTWin( ) { GivePoint( "CT" ); }
public evTEWin( ) { GivePoint( "TERRORIST" ); }

public GivePoint( const sTeam[ ] )
{
	static iPlayers[ 32 ], iPlrNum, iPlayerId;
	
	get_players( iPlayers, iPlrNum, "ech", sTeam );
	
	for ( new i; i < iPlrNum; ++i )
	{
		iPlayerId = iPlayers[ i ];
		
		if ( g_iRoundKills[ iPlayerId ] == 0 ) continue;
		
		if ( get_playersnum( ) > 11 )
		{
			if ( 14400 <= g_iUserData[ iPlayerId ][ iOnlineTimeW ] < 21600 )
				g_iRoundKills[ iPlayerId ] *= 2;
			else if ( 21600 <= g_iUserData[ iPlayerId ][ iOnlineTimeW ] < 28800 )
				g_iRoundKills[ iPlayerId ] *= 3;
			else if ( g_iUserData[ iPlayerId ][ iOnlineTimeW ] >= 28800 )
				g_iRoundKills[ iPlayerId ] *= 4;
		}
		
		g_iUserData[ iPlayerId ][ iPoints ] += g_iRoundKills[ iPlayerId ];
		if ( g_iRang[ iPlayerId ] < MaxRang )
		{
			if ( g_iUserData[ iPlayerId ][ iPoints ] >= g_iRangs[ g_iRang[ iPlayerId ] ][ iRangPoint ] )
			{
				++g_iRang[ iPlayerId ];
#if defined USE_ICHAT
				if ( g_iRang[ iPlayerId ] >= MaxRang ) iChatSendCustomData( iPlayerId, 0, g_iUserData[ iPlayerId ][ sPrefix ] );
				else iChatSendCustomData( iPlayerId, 0, g_iRangs[ g_iRang[ iPlayerId ] - 1 ][ sRangName ] );
#endif
			}
		}
	}
	arrayset( g_iRoundKills, 0, sizeof( g_iRoundKills ) );
}

public evDeath( )
{
	new iKiller = read_data( 1 );
	new iVictim = read_data( 2 );
	
	if ( ( iKiller != iVictim ) && !( get_user_team( iKiller ) == get_user_team( iVictim ) ))
	{
		++g_iUserData[ iKiller ][ iKills ];
		++g_iUserData[ iVictim ][ iDeaths ];
		++g_iRoundKills[ iKiller ];
	}	
}

public cmdHud( iPlayerId ) { ChatColor( iPlayerId, "%L", iPlayerId, "HUD", iPlayerId, ( g_bHud[ iPlayerId ] ^= true ) ? "ON" : "OFF" ); }

public cmdRang( iPlayerId )
{
	static sCurRang[ 32 ], sNextRang[ 32 ], iLen = 0, sMotd[ 2048 ], iMotdLen = charsmax( sMotd ), iTime;
	copy( sCurRang, charsmax( sCurRang ), g_iRangs[ g_iRang[ iPlayerId ] - 1 ][ sRangName ] );
	
	iTime = get_systime( ) - g_iUserData[ iPlayerId ][ iFCTime ];
	
	if ( g_iRang[ iPlayerId ] >= MaxRang )
		format( sCurRang, charsmax( sCurRang ), "%s (%s)", sCurRang, g_iUserData[ iPlayerId ][ sPrefix ] );
	
	if ( g_iRang[ iPlayerId ] < MaxRang )
		copy( sNextRang, charsmax( sNextRang ), g_iRangs[ g_iRang[ iPlayerId ] ][ sRangName ] );
		
	iLen = formatex( sMotd, iMotdLen, "<meta charset=utf-8><body bgcolor=#000000><font color=#FFB000><pre>" );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n", iPlayerId, "MOTD0", iTime / 3600,( iTime / 60 ) % 60, iTime % 60 );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n", iPlayerId, "MOTD1", g_iUserData[ iPlayerId ][ iOnlineTime ] / 3600,(g_iUserData[ iPlayerId ][ iOnlineTime ] / 60 ) % 60, g_iUserData[ iPlayerId ][ iOnlineTime ] % 60 );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n", iPlayerId, "MOTD2", g_iUserData[ iPlayerId ][ iOnlineTimeW ] / 3600, (g_iUserData[ iPlayerId ][ iOnlineTimeW ] / 60 ) % 60, g_iUserData[ iPlayerId ][ iOnlineTimeW ] % 60 );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n%L^n%L^n", iPlayerId, "MOTD3", g_iUserData[ iPlayerId ][ iKills ], iPlayerId, "MOTD4", g_iUserData[ iPlayerId ][ iDeaths ], iPlayerId, "MOTD5", g_iUserData[ iPlayerId ][ iPoints ] );
	
	if ( g_iRang[ iPlayerId ] >= MaxRang ) iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n^n", iPlayerId, "MOTD6", sCurRang );
	else iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n%L^n^n", iPlayerId, "MOTD6", sCurRang, iPlayerId, "MOTD7", sNextRang, ( g_iRangs[ g_iRang[ iPlayerId ] ][ iRangPoint ] - g_iUserData[ iPlayerId ][ iPoints ] ) );
	
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n", iPlayerId, "MOTD8", MinOnlineTime / 3600 );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n", iPlayerId, "MOTD9" );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L^n", iPlayerId, "MOTD13" );
	iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "%L", iPlayerId, "MOTD10" );
	
	show_motd( iPlayerId, sMotd, "Rangrendszer info" );
}

public cmdRangs( iPlayerId )
{
	static sRang[ 32 ], iLen = 0, sMotd[ 2048 ], iMotdLen = charsmax( sMotd );

	iLen = formatex( sMotd, iMotdLen, "<meta charset=utf-8><style>table{color:#FFB000;} td,th{border:1px solid #666;text-align:center;}</style><body bgcolor=#000000><center><h1><font color=#FFB000>%L</h1><br><table width='400'><tr><th>%L</th><th>%L</th><tr>", iPlayerId, "MOTD11", iPlayerId, "RANG", iPlayerId, "MOTD12" );
	
	for ( new i; i < MaxRang; ++i )
	{
		copy( sRang, charsmax( sRang ), g_iRangs[ i ][ sRangName ] );
		
		if ( i < g_iRang[ iPlayerId ] - 1 )
			iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "<tr><td>%s</td><td>0</td><tr>", sRang );
		else if ( i == g_iRang[ iPlayerId ] - 1 )
			iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "<tr style='background-color:#666;'><td>%s</td><td>0</td><tr>", sRang );
		else
			iLen += formatex( sMotd[ iLen ], iMotdLen - iLen, "<tr><td>%s</td><td>%d</td><tr>", sRang, ( g_iRangs[ i ][ iRangPoint ] - g_iUserData[ iPlayerId ][ iPoints ] ) );
	}
	
	show_motd( iPlayerId, sMotd, "Rangrendszer info" );
}

public cmdPrefix( iPlayerId )
{
	if ( g_iRang[ iPlayerId ] < MaxRang )
	{
		ChatColor( iPlayerId, "%L", iPlayerId, "PREFIX1" );
		return;
	}
	ChatColor( iPlayerId, "%L", iPlayerId, "PREFIX2" );
	client_cmd( iPlayerId, "messagemode PREFIX" );
}

public cmdResetPrefix( iPlayerId, iLevel, iCid )
{
	if ( !cmd_access( iPlayerId, iLevel, iCid, 2 ) ) return PLUGIN_HANDLED;
 
	static sUser[ 32 ], iPlrId;
	read_argv( 1, sUser, charsmax( sUser ) );
	
	iPlrId = cmd_target( iPlayerId, sUser, ( CMDTARGET_OBEY_IMMUNITY | CMDTARGET_ALLOW_SELF ) );
	
	if ( !iPlrId )
	{
		ChatColor( iPlayerId, "Nincs %s nevezetű játékos.", sUser );
		return PLUGIN_HANDLED;
	}
	
	copy( g_iUserData[ iPlrId ][ sPrefix ], charsmax( g_iUserData[ ][ sPrefix ] ), g_iRangs[ MaxRang - 1 ][ sRangName ] );
	
#if defined USE_ICHAT
	iChatSendCustomData( iPlrId, 0, g_iRangs[ MaxRang - 1 ][ sRangName ] );
#endif
	
	ChatColor( iPlayerId, "Sikeresen resetelted a jatekos prefixet." );
	
	return PLUGIN_CONTINUE;
}

public GetPrefix( iPlayerId )
{
	if ( g_iRang[ iPlayerId ] < MaxRang ) return PLUGIN_HANDLED;
	
	static sString[ 17 ], iLen;
	read_args( sString, charsmax( sString ) );
	remove_quotes( sString );
	
	replace_all( sString, charsmax( sString ), "'", "" );
	replace_all( sString, charsmax( sString ), "^"", "" );
	replace_all( sString, charsmax( sString ), "`", "" );
	
	iLen = strlen( sString );
	
	if ( iLen < 3 || iLen > 15 )
	{
		ChatColor( iPlayerId, "%L", iPlayerId, "PREFIX3" );
		
		return PLUGIN_HANDLED;
	}
	format( sString, charsmax( sString ), "%s", sString );
	copy( g_iUserData[ iPlayerId ][ sPrefix ], charsmax( g_iUserData[ ][ sPrefix ] ), sString );
#if defined USE_ICHAT	
	iChatSendCustomData( iPlayerId, 0, sString );
#endif
	ChatColor( iPlayerId, "%L", iPlayerId, "PREFIX4", sString );
	
	return PLUGIN_CONTINUE;
}

public fwClientUserInfoChanged( iPlayerId, iBuffer )
{ 
	if ( !is_user_connected( iPlayerId ) ) return FMRES_IGNORED;
	
	static sOldName[ 32 ], sNewName[ 32 ];
	get_user_name( iPlayerId, sOldName, charsmax( sOldName ) );
	
	engfunc( EngFunc_InfoKeyValue, iBuffer, "name", sNewName, charsmax( sNewName ) );
	
	if ( equal( sNewName, sOldName ) ) return FMRES_IGNORED;
	
	engfunc( EngFunc_SetClientKeyValue, iPlayerId, iBuffer, "name", sOldName );
	client_cmd( iPlayerId, "name ^"%s^"; setinfo name ^"%s^"", sOldName, sOldName );
	
	return FMRES_SUPERCEDE;
}

public OnlineTimeCounter( iPlayerId )
{
	++g_iUserData[ iPlayerId ][ iOnlineTime ];
	++g_iUserData[ iPlayerId ][ iOnlineTimeW ];
	
	if ( g_bHud[ iPlayerId ] )
	{
		if ( !is_user_alive( iPlayerId ) )
		{
			set_hudmessage( 0, 255, 0, 0.01, 0.20, 0, 6.0, 0.9 );
			new iTarget = entity_get_int( iPlayerId, EV_INT_iuser2 );
	 
			if ( iTarget != 0 )
			{
				show_hudmessage( iPlayerId, "%L^n%L^n%L^n%L^n%L^n%L^n%L", iPlayerId, "HUD1", 
				g_sUsername[ iTarget ], iPlayerId, "HUD2", 
				g_iUserData[ iTarget ][ iOnlineTime ] / 3600,( g_iUserData[ iTarget ][ iOnlineTime ] / 60 ) % 60, g_iUserData[ iTarget ][ iOnlineTime ] % 60, iPlayerId, "HUD3", 
				g_iUserData[ iTarget ][ iOnlineTimeW ] / 3600, ( g_iUserData[ iTarget ][ iOnlineTimeW ] / 60 ) % 60, g_iUserData[ iTarget ][ iOnlineTimeW ] % 60, iPlayerId, "HUD4", 
				g_iUserData[ iTarget ][ iKills ], iPlayerId, "HUD5", g_iUserData[ iTarget ][ iDeaths ], iPlayerId, "HUD6", g_iRangs[ g_iRang[ iTarget ] - 1 ][ sRangName ], g_iUserData[ iTarget ][ iPoints ], iPlayerId, "MOTD10" );
			}
			else
			{
				show_hudmessage( iPlayerId, "%L^n%L^n%L^n%L^n%L^n%L^n%L", iPlayerId, "HUD7", iPlayerId, "HUD2",
				g_iUserData[ iPlayerId ][ iOnlineTime ] / 3600,( g_iUserData[ iPlayerId ][ iOnlineTime ] / 60 ) % 60, g_iUserData[ iPlayerId ][ iOnlineTime ] % 60, iPlayerId, "HUD3", 
				g_iUserData[ iPlayerId ][ iOnlineTimeW ] / 3600, ( g_iUserData[ iPlayerId ][ iOnlineTimeW ] / 60 ) % 60, g_iUserData[ iPlayerId ][ iOnlineTimeW ] % 60, iPlayerId, "HUD4", 
				g_iUserData[ iPlayerId ][ iKills ], iPlayerId, "HUD5", g_iUserData[ iPlayerId ][ iDeaths ], iPlayerId, "HUD6", g_iRangs[ g_iRang[ iPlayerId ] - 1 ][ sRangName ], g_iUserData[ iPlayerId ][ iPoints ], iPlayerId, "MOTD10" );
			}
		}
	}
}

public Save( iNum )
{
	new sNewLine[ 16 ];
	
	formatex( sNewLine, charsmax( sNewLine ), "^"%d^"", iNum );
	write_file( "addons/amxmodx/configs/rangsys.ini", sNewLine, 0 );
}

public Load( )
{
	new pFile = fopen( "addons/amxmodx/configs/rangsys.ini", "rt" );
	
	if ( pFile )
	{
		new sLine[ 16 ], sTime[ 64 ], iNum;
		fgets( pFile, sLine, charsmax( sLine ) );
		
		trim( sLine );
		remove_quotes( sLine );
		
		iNum = str_to_num( sLine );
		
		get_time( "%a", sTime, charsmax( sTime ) );
		
		if ( equal( sTime, "Mon" ) )
		{
			if ( iNum == 0 )
			{
				SaveDatas( 0, 4 );
				Save( 1 );
				set_task( 2.5, "ResetOTimeW" );
			}
		}
		else { if ( iNum == 1 ) Save( 0 ); }
		
		fclose(pFile);
	}
	else Save( 0 );
}

public ResetOTimeW( ) { SaveDatas( 0, 3 ); }

public client_putinserver( iPlayerId )
{
	if ( is_user_bot( iPlayerId ) || is_user_hltv( iPlayerId ) ) return;
	
	g_iRoundKills[ iPlayerId ] = 0;
	g_bHud[ iPlayerId ] = true;
	g_iRang[ iPlayerId ] = 1;
	
	arrayset( g_iUserData[ iPlayerId ], 0, sizeof( g_iUserData[ ] ) );
	copy( g_iUserData[ iPlayerId ][ sPrefix ], charsmax( g_iUserData[ ][ sPrefix ] ), g_iRangs[ MaxRang - 1 ][ sRangName ] );
#if defined USE_ICHAT
	iChatSendCustomData( iPlayerId, 0, g_iRangs[ 0 ][ sRangName ] );
#endif	
	get_user_name( iPlayerId, g_sUsername[ iPlayerId ], charsmax( g_sUsername[ ] ) );
	get_user_authid( iPlayerId, g_sAuthID[ iPlayerId ], charsmax( g_sAuthID[ ] ) );
	
	LoadDatas( iPlayerId );
	set_task( 1.0, "OnlineTimeCounter", iPlayerId, _, _, "b" );
}

public client_disconnect( iPlayerId ) { if ( task_exists( iPlayerId ) ) remove_task( iPlayerId ); SaveDatas( iPlayerId, 2 ); }
public plugin_end( ) { SQL_FreeHandle( g_iSqlTuple ); }

stock ChatColor( iPlayerId, const sMessage[ ], any:... )
{
	static iPlrNum, iPlayers[ 32 ], sMsg[ 256 ], iIdMsg, iMsgLen = charsmax( sMsg );
	
	vformat( sMsg, iMsgLen, sMessage, 3 );
	format( sMsg, iMsgLen, "!g[%s]!y %s", g_sPrefix, sMsg );
	
	replace_all( sMsg, iMsgLen, "!g", "^4" );
	replace_all( sMsg, iMsgLen, "!y", "^1" );
	replace_all( sMsg, iMsgLen, "!t", "^3" );
 
	if ( !iIdMsg ) iIdMsg = get_user_msgid( "SayText" );
 
	if ( iPlayerId )
	{ 
		iPlayers[ 0 ] = iPlayerId;
		iPlrNum = 1;
	} 
	else get_players( iPlayers, iPlrNum, "ch" );
 
	for ( new i, iPId; i < iPlrNum; ++i )
	{
		iPId = iPlayers[ i ];
		
		if ( !is_user_connected( iPId ) ) continue;
		
		message_begin( MSG_ONE, iIdMsg, _, iPId );
		write_byte( iPId );
		write_string( sMsg );
		message_end( );
	}
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
