/*
	Changelog:
		3.2	- code optimization
		3.1	- added a cvar to help you handle the holdtime of the hud message
		3.0	- major improvements in the code; from now on, the nvault module is a requirement; - the restriction system is now using steam ids to ban users from participating to the event.
		2.3	- added a cvar for a random amount of money
		2.2 	- added a restriction system
		2.1	- temporary solution for % and ;
		2.0 	- new random system
			- code optimization
		
		1.0 	- first release

	Credits:
		ConnorMcLeod	- code improvement
		YamiKaitou 	- code improvement
		
*/

#include < amxmodx >
#include < amxmisc >
#include < cstrike >
#include < nvault >

#define PLUGIN_NAME "Fast typing event"
#define PLUGIN_AUTHOR "floatman" // Fordította: Traops (CoopCola)
#define PLUGIN_VERSION "3.2"

#define FLAGS 9

const TASK_CLEAR = 258;

new g_Codename[ 20 ];
new g_On = 0;
new g_Time, g_Prize, g_RepTime;
new g_Random, g_Min, g_Max, g_HoldTime;

new g_Restriction[ 33 ] = 0;

new g_SyncHudMsg;

public plugin_init()
{
	register_plugin( PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR );

	register_clcmd( "say", "cmdentered" );
	register_clcmd( "say_team", "cmdentered" );

	register_concmd( "amx_restrict", "cmdRestrict", ADMIN_BAN, " < name > - restricts a player from taking part of the event." );
	register_concmd( "amx_delrestrict", "cmdUnRestrict", ADMIN_BAN, " < name > - deleting the restriction of a player." );

	register_dictionary( "fastevent.txt" );

	register_cvar( "fevent_version", PLUGIN_VERSION, FCVAR_SERVER | FCVAR_SPONLY );
	set_cvar_string( "fevent_version", PLUGIN_VERSION );

	g_Time = register_cvar( "fastev_responsetime", "20.0" );
	g_Prize = register_cvar( "fastev_moneyprize", "5000" );
	g_RepTime = register_cvar( "fastev_repeattime", "120.0" );
	g_Random = register_cvar( "fastev_randomamount", "1" );
	g_Min = register_cvar( "fastev_randommin", "500" );
	g_Max = register_cvar( "fastev_randommax", "5000" );
	g_HoldTime = register_cvar( "fastev_hudtime", "25.0" );

	g_SyncHudMsg = CreateHudSyncObj();
}

public plugin_cfg()
{
	set_task( get_pcvar_float( g_RepTime ), "create", _, _, _, "b" );
}

public client_putinserver( i_Index )
{
	LoadRestriction( i_Index );
}

public cmdRestrict( i_Index, iLevel, iCid )
{
	if( !cmd_access( i_Index, iLevel, iCid, 2 ) )
		return PLUGIN_HANDLED;

	new szArg[ 32 ];
	read_argv( 1, szArg, charsmax( szArg ) )

	new iPlayer = cmd_target( i_Index, szArg, FLAGS );

	if( !iPlayer )
		return PLUGIN_HANDLED;

	new szName[ 32 ];
	get_user_name( iPlayer, szName, charsmax( szName ) );

	if( !g_Restriction[ iPlayer ] )
	{
		g_Restriction[ iPlayer ] = 1;
		SaveRestriction( iPlayer );

		client_print( i_Index, print_chat, "{FEVENT] %L", LANG_PLAYER, "RESTRICTION_ADDED", szName );	
	}

	else
	{
		client_print( i_Index, print_chat, "[FEVENT] %L", LANG_PLAYER, "HAS_RESTRICTION", szName );	
	}

	return PLUGIN_HANDLED;
}

public cmdUnRestrict( i_Index, iLevel, iCid )
{
	if( !cmd_access( i_Index, iLevel, iCid, 2 ) )
		return PLUGIN_HANDLED;

	new szArg[ 32 ];
	read_argv( 1, szArg, charsmax( szArg ) )

	new iPlayer = cmd_target( i_Index, szArg, FLAGS );

	if( !iPlayer )
		return PLUGIN_HANDLED;

	new szName[ 32 ];
	get_user_name( iPlayer, szName, charsmax( szName ) );

	if( g_Restriction[ iPlayer ] )
	{
		g_Restriction[ iPlayer ] = 0;
		SaveRestriction( iPlayer );
		
		client_print( i_Index, print_chat, "[FEVENT] %L", LANG_PLAYER, "RESTRICTION_DELETED", szName );
	}

	return PLUGIN_HANDLED;
}	

public create()
{
	g_On = 1;

	for( new j = 0; j < sizeof g_Codename - 1; j++ )
	{
		g_Codename[ j ] = random_num( '!', '~' );

		if( g_Codename[ j ] == ';' )
			g_Codename[ j ] = ',';
		
	}

	new Float:holdtime = get_pcvar_float( g_HoldTime );
	new Float:repeattime = get_pcvar_float( g_RepTime );

	if( holdtime > repeattime )
	{
		holdtime = repeattime - 5.0;
	}
		
	new Float:cleartime = get_pcvar_float( g_Time );
	set_task( cleartime, "clear_vars", TASK_CLEAR );

	set_hudmessage( 0, 255, 0, 0.07, 0.21, 0, 6.0, holdtime, _, _, -1 );
	ShowSyncHudMsg( 0, g_SyncHudMsg, "[FEVENT] %L", LANG_PLAYER, "NEW_CODE", g_Codename );
}

public clear_vars()
{
	if( task_exists( TASK_CLEAR ) )
		remove_task( TASK_CLEAR );

	g_Codename[ 0 ] = EOS;
	g_On = 0;
}

public cmdentered( i_Index )
{
	if( g_On == 1 )
	{
		new szSaid[ 192 ];
		read_args( szSaid, charsmax( szSaid ) );
		remove_quotes( szSaid );
		trim( szSaid );

		if( equal( szSaid, g_Codename ) )
		{
			new szName[ 32 ];
			get_user_name( i_Index, szName, charsmax( szName ) );

			if( g_Restriction[ i_Index ] )
			{
				client_print( i_Index, print_chat, "[FEVENT] %L", LANG_PLAYER, "CODE_NOTACCESS" );
				return PLUGIN_HANDLED;
			}

			if( get_pcvar_num( g_Random ) && ( get_pcvar_num( g_Min ) < get_pcvar_num( g_Max ) ) && ( get_pcvar_num( g_Max ) > 0 ) )
			{
				new iAmmount = random_num( get_pcvar_num( g_Min ), get_pcvar_num( g_Max ) );
				cs_set_user_money( i_Index, (cs_get_user_money(i_Index) + iAmmount) );
				client_print( 0, print_chat, "[FEVENT] %L", LANG_PLAYER, "ANNOUNCE_WINNER", szName, iAmmount );
			}

			else
			{
				cs_set_user_money( i_Index, (cs_get_user_money(i_Index) + get_pcvar_num(g_Prize)) );
				client_print( 0, print_chat, "[FEVENT] %L", LANG_PLAYER, "ANNOUNCE_WINNER", szName, get_pcvar_num(g_Prize) );

			}

			g_On = 0;
		}

		if( equali( szSaid, "" ) )
			return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
}

public SaveRestriction( i_Index )
{
	new vault = nvault_open( "fevent_restrictions" );
	
	new iKey[ 64 ], iValue[ 64 ], szAuth[ 32 ];
	get_user_authid( i_Index, szAuth, charsmax( szAuth ) );

	formatex( iKey, charsmax( iKey ), "%s", szAuth );
	formatex( iValue, charsmax( iValue ), "%d", g_Restriction[ i_Index ] );

	nvault_set( vault, iKey, iValue );
	nvault_close( vault );
}

public LoadRestriction( i_Index )
{
	new vault = nvault_open( "fevent_restrictions" );
	
	new iKey[ 64 ], iValue[ 64 ], szAuth[ 32 ];
	get_user_authid( i_Index, szAuth, charsmax( szAuth ) );

	formatex( iKey, charsmax( iKey ), "%s", szAuth );
	
	nvault_get( vault, iKey, iValue, charsmax( iValue ) );
	nvault_close( vault );

	g_Restriction[ i_Index ] = str_to_num( iValue );
}