/*
--------------------------------------------------------------
----------------------  Made by Deviance ---------------------
--------------------- www.the-place.co.nr --------------------
--------------------------------------------------------------
*/
//
// --| ---------- Fordította Traops (CoopCola) ------------ |--
//

#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <geoip>

#define Plugin "Donation System"
#define Version "1.0"
#define Author "Doombringer"

new Float:speed[33], Float:Gravity[33]
new health[33], armor[33], glow[33]

new bool:is_donator[33], donator_level[33]
new type = 1, selected_id, selected_name[33], selected_level = 1 // Menu stuff

/* Old way of making rank names
new const donator_ranks[10][] = {
	"Donator rank 1",
	"Donator rank 2",
	"Donator rank 3",
	"Donator rank 4",
	"Donator rank 5",
	"Donator rank 6",
	"Donator rank 7",
	"Donator rank 8",
	"Donator rank 9",
	"Donator rank 10"
}
*/

new donator_ranks[33][32]
new msgtext

public plugin_init()
{
	register_plugin(Plugin, Version, Author)
	
	register_event("CurWeapon","set_speed","be")
	register_event("ResetHUD", "hook_hud", "be")
	
	register_concmd("amx_dmenu", "Main_Menu", ADMIN_LEVEL_B, "- Milyen joggal lehessen megnyitni a támogatói menüt")
	register_clcmd("fullupdate", "block")
	
	msgtext = get_user_msgid("StatusText")
	load_ranks()
}

public block()
{
	return PLUGIN_HANDLED
}

public load_ranks()
{
	new configsdir[64], path[132]
	get_configsdir(configsdir, 63)
	
	format(path, 131, "%s/donator_ranks.ini", configsdir)
	new file = fopen(path, "rt")
	
	if(!file)
	{
		server_print("Could not find the donator_ranks.ini file!")
		return PLUGIN_HANDLED
	}
	
	new Rtext[266]
	
	new file_rank[32]
	new file_speed[8], file_gravity[8]
	new file_health[8], file_armor[8], file_glow[8]
	
	new i = 1
	while(!feof(file))
	{
		fgets(file, Rtext, 265)
		
		if( (strlen(Rtext) < 2) || (contain(Rtext, "//") != -1) )
		continue;
		
		parse(Rtext, file_rank, 31, file_health, 7, file_armor, 7, file_glow, 7, file_speed, 7, file_gravity, 7)							
		
		donator_ranks[i] = file_rank
		speed[i] = str_to_float(file_speed)
		
		Gravity[i] = str_to_float(file_gravity)
		health[i] = str_to_num(file_health)
		
		armor[i] = str_to_num(file_armor)
		glow[i] = str_to_num(file_glow)
		
		//server_print("(%d) %s - %d HP, %d AP, %d GW, %f SP, %f GY", strlen(Rtext), donator_ranks[i], health[i], armor[i], glow[i], speed[i], Gravity[i])	
		i++
	}
	
	fclose(file)
	server_print("Successfully loaded %d ranks", i - 1)
	
	return PLUGIN_CONTINUE
}

public check_if_donator(id, steamid[], ip[], name[])
{	
	new configsdir[64], path[132]
	get_configsdir(configsdir, 63)
	
	format(path, 131, "%s/donators.ini", configsdir)
	new file = fopen(path, "rt")
	
	if(!file)
	{
		server_print("Could not find the donators.ini file!")
		return PLUGIN_HANDLED
	}
	
	new Rtext[166], file_id[38], file_level[4]
	
	while(!feof(file))
	{
		fgets(file, Rtext, 165)
		
		if( (strlen(Rtext) < 2) || (contain(Rtext, "//") != -1) )
		continue;
		
		parse(Rtext, file_id, 37, file_level, 3)
		
		if( (equal(file_id, steamid)) || (equal(file_id, ip))|| (equal(file_id, name)) )
		{
			is_donator[id] = true
			donator_level[id] = str_to_num(file_level)
						
			break;
		}
	}
        
	fclose(file)	
	return PLUGIN_CONTINUE
}

public give_stuff(id)
{
	set_user_health(id, health[donator_level[id]])	
	set_user_armor(id, armor[donator_level[id]])
	
	if(glow[donator_level[id]] > 1)
		set_user_rendering(id, kRenderFxGlowShell, random(256), random(256), random(256), kRenderNormal, glow[donator_level[id]])
	
	set_user_maxspeed(id, get_user_maxspeed(id) + speed[donator_level[id]])	
	set_user_gravity(id, Gravity[donator_level[id]])
}

public tell_level(id)
{
	new name[32]
	get_user_name(id, name, 31)
	
	client_print(id, print_chat, "Üdv itt %s. Te egy támogató vagy (Szinted %d, Rankod %s)", name, donator_level[id], donator_ranks[donator_level[id]])
	client_print(id, print_chat, "Az Életed, Páncélod, Gravitációd és Sebességed annál több lesz minél többet támogatod a szervert")
	
	return PLUGIN_CONTINUE
}	

public client_putinserver(id)
{
	new steamid[38], IP[22], name[32]
	
	get_user_authid(id, steamid, 37)
	get_user_ip(id, IP, 21, 0)
	
	get_user_name(id, name, 31)	
	check_if_donator(id, steamid, IP, name)
	
	if(is_donator[id])
	{
		new country[45]
		geoip_country(IP, country, 44)
		
		set_hudmessage(0, 255, 0, -1.0, 0.28, 2, 6.0, 5.0)
		show_hudmessage(0, "Egy támagotó játékos %s csatlakozott a szerverre. (%s)", name, country)
		
		set_task(3.0, "tell_level", id)
		
		give_stuff(id)
		ShowHUD(id)
	}
	
	return PLUGIN_CONTINUE
}

public ShowHUD(id)    
{ 	
	new HUD[121]
	format(HUD, 120, "[%s] Szint: %d", donator_ranks[donator_level[id]], donator_level[id]) 

	message_begin(MSG_ONE, msgtext, {0,0,0}, id)
	write_byte(0)
	write_string(HUD)
	message_end()
	
	if(is_donator[id])
		set_task(5.0, "ShowHUD", id)
}

public set_speed(id)
{
	if(is_donator[id])
	{
		set_user_maxspeed(id, get_user_maxspeed(id) + speed[donator_level[id]])
	}
}

public hook_hud(id)
{
	if(is_donator[id])
	{
		give_stuff(id)
	}
}

public Main_Menu(id, level, cid)
{
	if(!cmd_access(id, level, cid, 1))
	return PLUGIN_HANDLED
	
	new menu = menu_create("Támogató Menü:", "main_handle")

	new players[32], num, player, current_id[3]
	get_players(players, num)
	
	static name[32]
	for(new i = 0; i < num; i++)
	{
		player = players[i]
		
		get_user_name(player, name, 31)
		format(current_id, 2, "%d", player)
		
		menu_additem(menu, name, current_id, 0)
	}

	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, menu, 0)
	
	return PLUGIN_HANDLED
}

public main_handle(id, menu, item)
{
	if (item == MENU_EXIT)
	{
        	menu_destroy(menu)
        	return PLUGIN_HANDLED
	}

	new data[6]
	new access, callback
	
	menu_item_getinfo(menu, item, access, data, 2,_,_, callback)

	selected_id = str_to_num(data)
	get_user_name(selected_id, selected_name, 31)
	
	Selection_Menu(id)
	
        menu_destroy(menu)
        return PLUGIN_HANDLED
}

public Selection_Menu(id)
{
	new menu_title[255]
	
	format(menu_title, 254, "%s %s egy támogató", selected_name, is_donator[selected_id] == true ? "is":"is not")

	new menu = menu_create(menu_title, "selection_handle")
	
	if(is_donator[selected_id])
	{		
		menu_additem(menu, "Eltávolít", "1", 0)
		menu_additem(menu, "Szerkeszt", "2", 0)
	}
	else
	{
		menu_additem(menu, "Hozzáad", "1", 0)
	}
	
	menu_addblank(menu, 0)	
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	
	menu_display(id, menu, 0)
}

public selection_handle(id, menu, item)
{
	if (item == MENU_EXIT)
	{
        	menu_destroy(menu)
        	return PLUGIN_HANDLED
	}

	new data[6]
	new access, callback
	
	menu_item_getinfo(menu, item, access, data, 2,_,_, callback)
	new key = str_to_num(data)

	if(is_donator[selected_id])
	{
		switch(key)
		{
			case 1: Remove_Menu(id)
			case 2: Edit_Menu(id)
		}
	}
	else
	{
		switch(key)
		{			
			case 1: Add_Menu(id)
		}
	}

        menu_destroy(menu)
        return PLUGIN_HANDLED
}

public Remove_Menu(id)
{
	new menu_title[255]
	
	format(menu_title, 254, "Eltávolítod %s?", selected_name)
	new menu = menu_create(menu_title, "remove_handle")
		
	menu_additem(menu, "Igen", "1", 0)
	menu_additem(menu, "Nem", "2", 0)
	
	menu_addblank(menu, 0)
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	
	menu_display(id, menu, 0)
}

public remove_handle(id, menu, item)
{
	if (item == MENU_EXIT)
	{
        	menu_destroy(menu)
        	return PLUGIN_HANDLED
	}

	new data[6]
	new access, callback
	
	menu_item_getinfo(menu, item, access, data, 2,_,_, callback)
	new key = str_to_num(data)
	
	if(key == 1)
	{
		new configsdir[64], path[132]
		get_configsdir(configsdir, 63)
	
		format(path, 131, "%s/donators.ini", configsdir)
		new file = fopen(path, "rt")
	
		if(!file)
		{
			server_print("Nem talaltam a donators.ini fajlt!")
			return PLUGIN_HANDLED
		}
	
		new Rtext[43], file_id[39]
		
		new steamid[38], IP[23]
		
		get_user_authid(selected_id, steamid, 37)
		get_user_ip(selected_id, IP, 22, 0)
		
		new line
		while(!feof(file))
		{
			fgets(file, Rtext, 42)			
		
			if( (strlen(Rtext) < 2) || (contain(Rtext, "//") != -1) )
			continue;
		
			parse(Rtext, file_id, 38)
			
			if( (equal(steamid, file_id)) || (equal(IP, file_id)) || (equal(selected_name, file_id)) )
			{				
				write_file(path, " ", line)
				
				is_donator[selected_id] = false
				donator_level[selected_id] = 0
				
				remove_task(id)
				client_print(id, print_chat, "Sikeresen eltávolítottad: %s, Ő többé nem támogató.", selected_name)
				
				break;
			}
				
			line++
		}
	
		fclose(file)
	}

        menu_destroy(menu)
        return PLUGIN_HANDLED
}

public Edit_Menu(id)
{
	new menu = menu_create("Szint szerkesztése", "edit_handle")
	
	new menu_items[64]
	
	format(menu_items, 63, "Növelted %s szinjét a következőre %d", selected_name, donator_level[selected_id] + 1)
	menu_additem(menu, menu_items, "1", 0)
	
	format(menu_items, 63, "Csökkentetted %s szintjét a következőre %d", selected_name, donator_level[selected_id] - 1)
	menu_additem(menu, menu_items, "2", 0)
	
	menu_addblank(menu, 0)

	format(menu_items, 63, "Elmentetted %s szintjét", selected_name)
	menu_additem(menu, menu_items, "3", 0)
	
	menu_addblank(menu, 0)
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	
	menu_display(id, menu, 0)
}

public edit_handle(id, menu, item)
{
	if (item == MENU_EXIT)
	{
        	menu_destroy(menu)
        	return PLUGIN_HANDLED
	}

	new data[6]
	new access, callback
	
	menu_item_getinfo(menu, item, access, data, 2,_,_, callback)
	new key = str_to_num(data)
	
	switch(key)
	{
		case 1: donator_level[selected_id]++
		case 2: donator_level[selected_id]--
		
		case 3:
		{
			new configsdir[64], path[132]
			get_configsdir(configsdir, 63)
	
			format(path, 131, "%s/donators.ini", configsdir)
			new file = fopen(path, "rt")
	
			if(!file)
			{
				server_print("Could not find the donators.ini file!")
				return PLUGIN_HANDLED
			}
	
			new Rtext[43], file_id[39]
		
			new steamid[38], IP[23]
		
			get_user_authid(selected_id, steamid, 37)
			get_user_ip(selected_id, IP, 22, 0)
		
			new line
			while(!feof(file))
			{
				fgets(file, Rtext, 42)			
		
				if( (strlen(Rtext) < 2) || (contain(Rtext, "//") != -1) )
				continue;
		
				parse(Rtext, file_id, 38)
			
				if( (equal(steamid, file_id)) || (equal(IP, file_id)) || (equal(selected_name, file_id)) )
				{
					new line_text[41]
					format(line_text, 40, "^"%s^" ^"%d^"", file_id, donator_level[selected_id])
				
					write_file(path, line_text, line)
					client_print(id, print_chat, "Sikeresen elmentetted %s szintjét a támogatói fájlba", selected_name)
				
					break;
				}
			
				line++
			}
		
			fclose(file)
		}
	}

        Edit_Menu(id)
        return PLUGIN_HANDLED
}

public Add_Menu(id)
{
	new menu = menu_create("Támogató Hozzáadása", "add_handle")	
	new menu_items[64], add_type[9]
	
	menu_additem(menu, "Save to file", "1", 0)
	
	switch(type)
	{
		case 1: copy(add_type, 8, "Steamid")
		case 2: copy(add_type, 8, "IP")
		case 3: copy(add_type, 8, "Name")
	}
	
	format(menu_items, 63, "Hozzadás: %s", add_type)
	menu_additem(menu, menu_items, "2", 0)
	
	menu_addblank(menu, 0)

	format(menu_items, 63, "Magasabb szntet neki: %d", selected_level + 1)
	menu_additem(menu, menu_items, "3", 0)
	
	format(menu_items, 63, "Alacsonyabb szintet neki: %d", selected_level - 1)
	menu_additem(menu, menu_items, "4", 0)
	
	menu_addblank(menu, 0)
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	
	menu_display(id, menu, 0)
}

public add_handle(id, menu, item)
{
	if (item == MENU_EXIT)
	{
        	menu_destroy(menu)
        	return PLUGIN_HANDLED
	}

	new data[6]
	new access, callback
	
	menu_item_getinfo(menu, item, access, data, 2,_,_, callback)
	new key = str_to_num(data)
	
	switch(key)
	{
		case 1:
		{
			new configsdir[64], path[132]
			get_configsdir(configsdir, 63)
	
			format(path, 131, "%s/donators.ini", configsdir)
			new file = fopen(path, "at")
	
			if(!file)
			{
				server_print("Nem talaltam a donators.ini fajlt!")
				return PLUGIN_HANDLED
			}
			
			new add_by[38]
			
			switch(type)
			{				
				case 1: get_user_authid(selected_id, add_by, 37)
				case 2: get_user_ip(selected_id, add_by, 37, 0)
				case 3: copy(add_by, 37, selected_name)
			}
			
			new add_user[41]
			format(add_user, 40, "^"%s^" ^"%d^"^n", add_by, selected_level)
			
			fprintf(file, add_user, 40)
			fclose(file)
			
			is_donator[selected_id] = true
			donator_level[selected_id] = selected_level
				
			ShowHUD(selected_id)
			client_print(id, print_chat, "Sikeresen hozzáadtad: %s, Ő mostantól támogató.", selected_name)
		        
			type = 1
			selected_level = 1
			
			menu_destroy(menu)
        		return PLUGIN_HANDLED	
		}
			
		case 2:
		{
			if(type >= 3)
			{
				type = 1
				Add_Menu(id)
				
				return PLUGIN_HANDLED
			}
			
			type++
			Add_Menu(id)
				
			return PLUGIN_HANDLED	
		}
		
		case 3: selected_level++
		case 4: selected_level--
	}

        Add_Menu(id)
        return PLUGIN_HANDLED
}