/*
	Автор плагина: Анатолий (AcE) Бойко.
	Моя страничка: https://vk.com/e1337ace
	Профиль Steam: http://steamcommunity.com/profiles/76561198038775603/
	Отдельное спасибо за код Vagtincha и d3m37r4.
*/

#include <amxmodx>
#include <reapi>

#if !defined MAX_CLIENTS
	const MAX_CLIENTS = 32
#endif
#if !defined MAX_MENU_LENGTH
	const MAX_MENU_LENGTH = 512
#endif

//#define FFA_MODE 						/* Поддержка CSDM FFA. */
#define HUD_MSG_TIME 5.0 					/* Время показа сообщения. */
#define HUD_RGB 0, 255, 0 					/* Цвет сообщения в формате R, G, B */
#define HUD_X_Y -1.0, 0.20 					/* Позиция сообщения по оси X, Y */
#define KILLSTREAK_TIME 10.0 					/* Интервал для серии убийств */

new const MENU_SOUND[] = "killstreak/openmenu.wav"
new const HEADSHOT_SOUND[] = "killstreak/headshot.wav"
new const FIRSTBLOOD_SOUND[] = "killstreak/firstblood.wav"
new const KILLSTREAK_SOUND[][] =
{
	"killstreak/doublekill.wav",
	"killstreak/triplekill.wav",
	"killstreak/multikill.wav",
	"killstreak/megakill.wav",
	"killstreak/ultrakill.wav",
	"killstreak/monsterkill.wav",
	"killstreak/killingspree.wav",
	"killstreak/wickedsick.wav",
	"killstreak/rampage.wav",
	"killstreak/ludacrisskill.wav",
	"killstreak/godlike.wav",
	"killstreak/holyshit.wav"
}

const keys = MENU_KEY_0|MENU_KEY_1|MENU_KEY_2
new const commands[][] = {"killmenu", "say /killmenu", "say_team /killmenu"}
new g_SyncHudMsg, bool:g_FirstKill, bool:g_MsgSwitch[MAX_CLIENTS +1], bool:g_SndSwitch[MAX_CLIENTS +1]

public plugin_precache()
{
	precache_sound(MENU_SOUND)
	precache_sound(HEADSHOT_SOUND)
	precache_sound(FIRSTBLOOD_SOUND)
	for (new i; i < sizeof KILLSTREAK_SOUND; i ++)
		precache_sound(KILLSTREAK_SOUND[i])
}

public plugin_init()
{
	register_plugin("Re Kill Streak", "1.1", "AcE, Vagtincha, d3m37r4")
	g_SyncHudMsg = CreateHudSyncObj()
	RegisterHookChain(RG_CSGameRules_DeathNotice, "CSGameRules_DeathNotice", .post = true)
	RegisterHookChain(RG_CSGameRules_RestartRound, "CSGameRules_RestartRound", .post = true)
	register_menucmd(register_menuid("Menu"), keys, "show_kill_menu")
	for (new i; i < sizeof commands; i ++)
		register_clcmd(commands[i], "kill_menu")
}

public client_putinserver(id)
{
	g_SndSwitch[id] = true
	g_MsgSwitch[id] = true
}

public CSGameRules_RestartRound() g_FirstKill = false

public kill_menu(id)
{
    static menu[MAX_MENU_LENGTH]
    static const onoff[2][] = {{"\rKikapcsolva"}, {"\yBekapcsolva"}}
    formatex(menu, charsmax(menu), "\r[\yKill Streak\r] \wMenu^n\
        \r1. \wHangok: %s^n\
        \r2. \wUzenetek: %s^n\
        \r0. \wKilepes", onoff[g_SndSwitch[id]], onoff[g_MsgSwitch[id]]
    )
    show_menu(id, keys, menu, -1, "Menu")
}

public show_kill_menu(id, key)
{
	client_cmd(id, "spk ^"%s^"", MENU_SOUND)
	switch(key)
	{
		case 0:
		{
			g_SndSwitch[id] = !g_SndSwitch[id]
			kill_menu(id)
		}
		case 1:
		{
			g_MsgSwitch[id] = !g_MsgSwitch[id]
			kill_menu(id)
		}
	}
}

public CSGameRules_DeathNotice(const victim, const killer, pevInflictor)
{
	if (!is_user_connected(killer) || killer == victim)
		return HC_CONTINUE

	#if !defined FFA_MODE
	if (get_member(killer, m_iTeam) == get_member(victim, m_iTeam))
		return HC_CONTINUE
	#endif

	ClearSyncHud(killer, g_SyncHudMsg)
	set_hudmessage(HUD_RGB, HUD_X_Y, 0, 0.0, HUD_MSG_TIME)
	static Sound_Id, Float:Time, Float:LastKill[MAX_CLIENTS +1], KillStreak[MAX_CLIENTS +1]

	static const KILLSTREAK_MESSAGE[][] =
	{
		"", "Double-Kill!", "Triple-Kill!", "Multi-Kill!", "Mega-Kill!",
		"Ultra-Kill!", "Monster-Kill!", "Killing Spree!", "Wicked Sick!",
		"Rampage!", "Ludacriss-Kill", "Godlike!", "Holy Shit!"
	}
	Time = get_gametime()
	if (KillStreak[killer] >= sizeof KILLSTREAK_SOUND || (Time - LastKill[killer]) > KILLSTREAK_TIME)
	{
		KillStreak[killer] = 0
		if (!g_FirstKill)
		{
			g_FirstKill = true
			if (g_MsgSwitch[killer])
				ShowSyncHudMsg(killer, g_SyncHudMsg, "First-Blood!")
			if (g_SndSwitch[killer])
				client_cmd(killer, "spk ^"%s^"", FIRSTBLOOD_SOUND)
		}
		else
		{
			if (get_member(victim, m_bHeadshotKilled))
			{
				if (g_MsgSwitch[killer])
					ShowSyncHudMsg(killer, g_SyncHudMsg, "Headshot!")
				if (g_SndSwitch[killer])
					client_cmd(killer, "spk ^"%s^"", HEADSHOT_SOUND)
			}
		}
	}
	else
	{
		KillStreak[killer] ++
		Sound_Id = clamp(KillStreak[killer] -1, 0, sizeof KILLSTREAK_SOUND -1)
		if (g_MsgSwitch[killer])
			ShowSyncHudMsg(killer, g_SyncHudMsg, "%s", KILLSTREAK_MESSAGE[KillStreak[killer]])
		if (g_SndSwitch[killer])
			client_cmd(killer, "spk ^"%s^"", KILLSTREAK_SOUND[Sound_Id])
	}
	LastKill[killer] = Time
	LastKill[victim] = 0.0
	KillStreak[victim] = 0
	return HC_CONTINUE
}