#include <amxmodx>
#include <Settings_native>
#include <ServerPrefix>

#define PLUGIN "Round End Sounds V4"
#define VERSION "4.0"
#define AUTHOR "Kova, Adek"
#define CREDIT "DeRoiD"

#define File "addons/amxmodx/configs/musiclist.ini"

#pragma semicolon 1

new MusicData[40][3][64], Mp3File[96], MusicNum, PreviousMusic = -1, bool:Off[33], MaxFileLine;
new Prefix[32];

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_dictionary("round_end_sounds_v3.txt");
	//SayText = get_user_msgid("SayText");
	
	register_logevent("PlayMusic", 2, "1=Round_End");
	LoadMusic();
}
public Toggle(id)
{
	new Message[256];
	if(Settings_Get_RoundEndSoundPlay(id))
	{
		formatex(Message, 255, "!g%s!y %L", Prefix, LANG_SERVER, "ON");
		SendMessage(id, Message);
		Off[id] = false;
	}
	else
	{
		client_cmd(id, "mp3 stop");
		formatex(Message, 255, "!g%s!y %L", Prefix, LANG_SERVER, "OFF");
		SendMessage(id, Message);
		Off[id] = true;
	}
}
public LoadMusic()
{
	new Len, Line[196], Data[3][64];
	MaxFileLine = file_size(File, 1);
	for(new Num; Num < MaxFileLine; Num++)
	{
		MusicNum++;
		read_file(File, Num, Line, 196, Len);
		parse(Line, Data[0], 63, Data[1], 63, Data[2], 63);
		remove_quotes(Line);
		if(Line[0] == ';' || 2 > strlen(Line))
		{
			continue;
		}
		remove_quotes(Data[0]);
		remove_quotes(Data[1]);
		remove_quotes(Data[2]);
		format(MusicData[MusicNum][0], 63, "%s", Data[0]);
		format(MusicData[MusicNum][1], 63, "%s", Data[1]);
		format(MusicData[MusicNum][2], 63, "%s", Data[2]);
	}
	log_amx("Round end sounds v4");
	log_amx("%d loaded music.", MusicNum);
	log_amx("Plugin by: Kova, Adek");
}
public PlayMusic() {
	new Num = random_num(1, MusicNum);
	if(MusicNum > 1)
	{
		if(Num == PreviousMusic)
		{
			PlayMusic();
			return PLUGIN_HANDLED;
		}
	}
	formatex(Mp3File, charsmax(Mp3File), "sound/%s", MusicData[Num][2]);
	new Players[32], PlayersNum, id;
	get_players(Players, PlayersNum, "c");
	for(new i; i < PlayersNum; i++)
	{
		id = Players[i];
		if(Off[id])
		{
			continue;
		}
		client_cmd(id, "mp3 play %s", Mp3File);
		new Message[256] ;
		if(strlen(MusicData[Num][0]) > 3 && strlen(MusicData[Num][1]) > 3)
		{
			formatex(Message, 255, "!g%s!y %L", Prefix, LANG_SERVER, "PLAY", MusicData[Num][0], MusicData[Num][1]);
		}
		else
		{
			formatex(Message, 255, "!g%s!y %L", Prefix, LANG_SERVER, "UNKNOWN");
		}
		SendMessage(id, Message);
	}
	PreviousMusic = Num;
	return PLUGIN_HANDLED;
}
public plugin_precache() {
	new Len, Line[196], Data[3][64], Download[40][64];
	MaxFileLine = file_size(File, 1);
	for(new Num = 0; Num < MaxFileLine; Num++)
	{
		read_file(File, Num, Line, 196, Len);
		parse(Line, Data[0], 63, Data[1], 63, Data[2], 63);
		remove_quotes(Line);
		if(Line[0] == ';' || 2 > strlen(Line))
		{
			continue;
		}
		remove_quotes(Data[2]);
		format(Download[Num], 63, "%s", Data[2]);
		precache_sound(Download[Num]);
	}
	Prefix = Get_ServerPrefix();
}
stock SendMessage(id, const MessageData[]) {
	static Message[256];
	vformat(Message, 255, MessageData, 3);
	replace_all(Message, 255, "!g", "^4");
	replace_all(Message, 255, "!y", "^1");
	replace_all(Message, 255, "!t", "^3");
	client_print_color(id, print_team_default, "%s", Message);
}
