#if defined _msg_weap_sprites_api
	#endinput
#endif
#define _msg_weap_sprites_api

#include <msg_weap_sprites_api_const>

/* Sets a new sprite to a players weapon(with WEAP_FL_* flags) and even handles the weapon change of it.
 * 
 * @param id			Player id.
 * @param weaponId 		The def. weapon id(CSW_*), see cstrike_const.inc
 * @param newWeaponName		The name of the new weapon(and the txt file of it)
 * @param flags			Flags of the new weapon(WEAP_FL_*), see msg_weap_sprites_api_const.inc
 */
native msg_set_player_weapon_sprite(id, weaponId, const newWeaponName[], flags = -1)

/* Deletes the custom sprites on a players weapon, but can hold/edit the flags of the default weapon.
 * 
 * @param id			Player id.
 * @param weaponId 		The def. weapon id(CSW_*), see cstrike_const.inc
 * @param flags			Flags of the weapon(WEAP_FL_*), see msg_weap_sprites_api_const.inc
 */
native msg_reset_player_weapon_sprite(id, weaponId, flags = -1)
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang3076\\ f0\\ fs16 \n\\ par }
*/
