#include <amxmodx>
#include <amxmisc>
#include <sqlx>
#include <Hamsandwich>

#pragma semicolon 1

new g_iMax;

new const TableName[] = "HlmodMusic_table";

enum _:Music_prop{
	eMusicName[64],
	eMusicFile[64],
};

new g_iLoadedMusic;
new iKey;
new Array:g_aReadFile;
new Array:g_aPlayMusic[33];
new g_iMaxPlayers;
new g_sSteamId[64];
new Handle:SQLtuple;
new g_cPrefix;

public plugin_init()
{
	register_plugin("MVPZene", "0.1.0", "Turán*");
	
	/*Kiszolgáló | Felhasználó | Jelszó | Adatbázis neve*/
	SQLtuple = SQL_MakeDbTuple("", "", "", "");
	
	register_logevent("PlayMusic", 2, "1=Round_End");
	register_clcmd("say /zene", "p_musicmenu");
	
	g_cPrefix = register_cvar("ServerPrefix", "[Szerver]");//Ide ajánlom [], || jeleket használni mert chatnél csak sima %s van!
	
	g_iMaxPlayers = get_maxplayers();
	for(new i = 1; i <= g_iMaxPlayers; i++)
		g_aPlayMusic[i] = ArrayCreate(1);
	
	p_SQLCreateTable();
}
public get_prefix()
{
	new sPrefix[64];
	get_pcvar_string(g_cPrefix, sPrefix, charsmax(sPrefix));
	return sPrefix;
}
public p_musicmenu(id)
{
	new iMenu, iRow[7], sActive[64], eData[Music_prop];
	iMenu = menu_create(fmt("\r%s \w~ \dZenekészlet", get_prefix()), "p_musicmenu_handler");
	for(new i = 0; i < g_iLoadedMusic; i++)
	{
		ArrayGetArray(g_aReadFile, i, eData);
		formatex(sActive, charsmax(sActive), ArrayFindValue(g_aPlayMusic[id], i) != -1 ? "\wAktiv":"\dNem aktiv");
		num_to_str(i, iRow, charsmax(iRow));
		menu_additem(iMenu, fmt("\rZene:\d %s\w - %s", eData[eMusicName], sActive), iRow, 0);
	}
	
	menu_setprop(iMenu, MPROP_EXITNAME, fmt("Kilépés"));
	menu_display(id, iMenu);
}
public p_musicmenu_handler(id, iMenu, iMenuItem)
{
	if(iMenuItem == MENU_EXIT)
	{
		menu_destroy(iMenu);
		return PLUGIN_HANDLED;
	}
	
	new sData[9], sName[MAX_NAME_LENGTH], iAccess, iCallback;
	menu_item_getinfo(iMenu, iMenuItem, iAccess, sData, charsmax(sData), sName, charsmax(sName), iCallback);
	iKey = str_to_num(sData);
	
	new iFindValue = ArrayFindValue(g_aPlayMusic[id], iKey);
	new eData[Music_prop];
	ArrayGetArray(g_aReadFile, iKey, eData);
	
	if(iFindValue != -1)
	{
		ArrayDeleteItem(g_aPlayMusic[id], iFindValue);
		client_print_color(id, print_team_default, "^4%s^3 ~ ^1Sikeresen kikapcsoltad a(z)^3 %s^1 zenét.", get_prefix(), eData[eMusicName]);
		p_SQLUpdate(id);p_musicmenu(id);
	}
	else
	{
		ArrayPushCell(g_aPlayMusic[id], iKey);
		client_print_color(id, print_team_default, "^4%s^3 ~ ^1Sikeresen bekapcsoltad a(z)^3 %s^1 zenét.", get_prefix(), eData[eMusicName]);
		p_SQLUpdate(id);p_musicmenu(id);
	}
	
	menu_destroy(iMenu);
	return PLUGIN_HANDLED;
}
public PlayMusic()
{
	for(new i = 1; i < g_iMaxPlayers; i++)
		p_startmusic(i);
}
public p_startmusic(id)
{		
	new iArraySize = ArraySize(g_aPlayMusic[id]);
	static eData[Music_prop];
	if(!iArraySize)
		return;
	
	new iRandomMusic = random(iArraySize);
	iRandomMusic = ArrayGetCell(g_aPlayMusic[id], iRandomMusic);
	
	ArrayGetArray(g_aReadFile, iRandomMusic, eData);
	client_cmd(id, "mp3 play sound/%s", eData[eMusicFile]);
	client_print_color(id, print_team_default, "^4%s^3 ~^1 A zene cime:^3 %s", get_prefix(), eData[eMusicName]);
}
p_SQLCreateTable()
{
	static sQuery[512];
	new iLen;
	
	iLen += formatex(sQuery[iLen], charsmax(sQuery), "CREATE TABLE IF NOT EXISTS `%s` ", TableName);
	iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "( ");
	iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "`Id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY, ");
	
	for(new i = 0; i < g_iLoadedMusic; i++)
		iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "`Zene_%d` INT(11) NOT NULL,", i);
	
	iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "`MaxNumber` INT(11) NOT NULL,");
	iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "`SteamID` varchar(64) NOT NULL)");
	SQL_ThreadQuery(SQLtuple, "p_SQLCreateTableThr", sQuery);
}
public p_SQLCreateTableThr(iFailState, Handle:sQuery, sError[], iErrcode, sData[])
{
	if(iFailState == TQUERY_CONNECT_FAILED)
		set_fail_state("*DEBUG* [CreateTable] Nem sikerult csatlakozni az adatbazishoz.");
	else if(iFailState == TQUERY_QUERY_FAILED)
		set_fail_state("*DEBUG* [CreateTable] Lekerdezesi hiba");
	if(iErrcode)
		log_amx("*DEBUG* [CreateTable] - %s", sError);
}
public p_SQLLoadData(id)
{
	static sQuery[512]; 
	new sData[2];
	
	sData[0] = id;
	sData[1] = get_user_userid(id);
	get_user_authid(id, g_sSteamId, charsmax(g_sSteamId));
	
	formatex(sQuery, charsmax(sQuery), "SELECT * FROM `%s` WHERE `SteamID`='%s';", TableName, g_sSteamId);
	SQL_ThreadQuery(SQLtuple, "p_SQLLoadDatathr", sQuery, sData, 2);
}
public p_SQLLoadDatathr(iFailState, Handle:sQuery, sError[], iErrcode, sData[], iDataSize)
{
	if(iFailState == TQUERY_CONNECT_FAILED)
		set_fail_state("*DEBUG* [LoadCheck] Nem sikerult csatlakozni az adatbazishoz.");
	else if(iFailState == TQUERY_QUERY_FAILED)
		set_fail_state("*DEBUG* [LoadCheck] Lekerdezesi hiba");
	if(iErrcode)
		log_amx("*DEBUG* [LoadCheck] - %s", sError);
	
	new id = sData[0];
	
	if(sData[1] != get_user_userid(id)) return;
	
	new iRowsFound = SQL_NumRows(sQuery);
	new iReadResult;
	
	if(iRowsFound > 0)
	{
		for(new i = 0; i < g_iLoadedMusic; i++)
		{
			new sText[64];
			formatex(sText, charsmax(sText), "Zene_%d", i);
			iReadResult = SQL_ReadResult(sQuery, SQL_FieldNameToNum(sQuery, sText));
			
			if(iReadResult)
				ArrayPushCell(g_aPlayMusic[id], i);
		}
	}
	else
	{
		p_SQLinsertTable(id);
		p_SQLLoadData(id);
	}
}
public p_SQLinsertTable(id)
{
	static sQuery[512];
	new sData[2];
	
	sData[0] = id;
	sData[1] = get_user_userid(id);
	get_user_authid(id, g_sSteamId, charsmax(g_sSteamId));
	
	formatex(sQuery, charsmax(sQuery), "INSERT INTO `%s` (`SteamID`) VALUES('%s')", TableName, g_sSteamId);
	SQL_ThreadQuery(SQLtuple, "p_SQLinsertTablethr", sQuery, sData, 2);
}
public p_SQLinsertTablethr(iFailState, Handle:sQuery, sError[], iErrcode, sData[], iDataSize)
{
	if(iFailState == TQUERY_CONNECT_FAILED || iFailState == TQUERY_QUERY_FAILED)
	{
		log_amx("*DEBUG* [Insert] - %s", sError);
		return;
	}
	new id = sData[0];
	
	if(sData[1] != get_user_userid(id)) return;
}
public p_SQLUpdate(id)
{
	static sQuery[512];
	new sData[2], iLen;
	
	sData[0] = id;
	sData[1] = get_user_userid(id);
	get_user_authid(id, g_sSteamId, charsmax(g_sSteamId));
	
	iLen += formatex(sQuery[iLen], charsmax(sQuery), "UPDATE `%s` SET ", TableName);
	new iFindValue = ArrayFindValue(g_aPlayMusic[id], iKey);
	
	if(iFindValue != -1)
		iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "Zene_%d = '%i',", iKey, 1);
	else
	iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "Zene_%d = '%i',", iKey, 0);
	
	iLen += formatex(sQuery[iLen], charsmax(sQuery)-iLen, "MaxNumber = '%i' WHERE `SteamID` =  ^"%s^";", g_iMax, g_sSteamId);
	
	SQL_ThreadQuery(SQLtuple, "p_SQLUpdatethr", sQuery, sData, 2);     
}
public p_SQLUpdatethr(iFailState, Handle:sQuery, sError[], iErrcode, sData[], iDataSize) 
{
	if(iFailState == TQUERY_CONNECT_FAILED || iFailState == TQUERY_QUERY_FAILED) 
	{
		log_amx("*DEBUG* [Update] - %s", sError);return;
	}
	new id = sData[0];
	if(sData[1] != get_user_userid(id)) return;
}
public client_authorized(id)
{
	if(is_user_bot(id))
		return;
	
	p_SQLLoadData(id);
}
public client_disconnected(id)
{
	if(is_user_bot(id))
		return;
	
	ArrayDestroy(g_aPlayMusic[id]);
	ArrayDestroy(g_aReadFile);
}
public plugin_precache()
{
	g_aReadFile = ArrayCreate(Music_prop);
	
	new sPath[256];
	get_configsdir(sPath, charsmax(sPath));
	format(sPath, charsmax(sPath), "%s/Zene.ini", sPath);
	
	if(file_exists(sPath))
	{	
		new sLineData[256], iLine, sData[64], sData2[64];
		new iFile = fopen(sPath, "rt");
		
		if(!iFile)
			return;	
		
		while(!feof(iFile))
		{
			fgets(iFile, sLineData, charsmax(sLineData));
			replace(sLineData, charsmax(sLineData), "^n", "");
			
			if(sLineData[0] == ';' || !sLineData[0])
				continue;
			
			parse(sLineData, sData, charsmax(sData), sData2, charsmax(sData2));
			remove_quotes(sData);
			remove_quotes(sData2);
			
			static eData[Music_prop];
			copy(eData[eMusicName], sizeof(eData[eMusicName]) - 1, sData);
			copy(eData[eMusicFile], sizeof(eData[eMusicFile]) - 1, sData2);
			
			ArrayPushArray(g_aReadFile, eData);
			
			precache_sound(eData[eMusicFile]);
			iLine++;
		}
		fclose(iFile);
		g_iLoadedMusic = ArraySize(g_aReadFile);
	}
}
public plugin_end()
{
	for(new i = 1; i <= g_iMaxPlayers; i++)
		ArrayDestroy(g_aPlayMusic[i]);
	
	ArrayDestroy(g_aReadFile);
}