#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fun>

#define PLUGIN "AMX Cards"
#define VERSION "1.5b"
#define AUTHOR "MaTTe (Forditotta: *s1mpla)"

new g_nMsgScreenFade
new g_nMsgScreenFade2

new hasCard[33];

new g_Switch, g_PCard, g_PCardMult, g_DCard, g_LCard, g_MaxLife, g_MCard, g_IACard, g_StrCard,
g_RBCard, g_ACard, g_MaxArmor, g_SpCard, g_SlCard, g_WCard, g_GCard, g_NCard, g_SpyCard, g_MoneyCard,
g_SglassesCard, g_MaxMoney, g_MoneyPerSec, g_BankruptCard, g_InvisCard, g_InvisPercentage,
g_GlowCard, g_CardMode

//*ColorChat Inc*//
enum Color
{
	NORMAL = 1, // clients scr_concolor cvar color
	GREEN, // Green Color
	TEAM_COLOR, // Red, grey, blue
	GREY, // grey
	RED, // Red
	BLUE, // Blue
}

new TeamName[][] = 
{
	"",
	"TERRORIST",
	"CT",
	"SPECTATOR"
}

ColorChat(id, Color:type, const msg[], {Float,Sql,Result,_}:...)
{
	new message[256];

	switch(type)
	{
		case NORMAL: // clients scr_concolor cvar color
		{
			message[0] = 0x01;
		}
		case GREEN: // Green
		{
			message[0] = 0x04;
		}
		default: // White, Red, Blue
		{
			message[0] = 0x03;
		}
	}

	vformat(message[1], 251, msg, 4);

	// Make sure message is not longer than 192 character. Will crash the server.
	message[192] = '^0';

	new team, ColorChange, index, MSG_Type;
	
	if(id)
	{
		MSG_Type = MSG_ONE;
		index = id;
	} else {
		index = FindPlayer();
		MSG_Type = MSG_ALL;
	}
	
	team = get_user_team(index);
	ColorChange = ColorSelection(index, MSG_Type, type);

	ShowColorMessage(index, MSG_Type, message);
		
	if(ColorChange)
	{
		Team_Info(index, MSG_Type, TeamName[team]);
	}
}

ShowColorMessage(id, type, message[])
{
	static bool:saytext_used;
	static get_user_msgid_saytext;
	if(!saytext_used)
	{
		get_user_msgid_saytext = get_user_msgid("SayText");
		saytext_used = true;
	}
	message_begin(type, get_user_msgid_saytext, _, id);
	write_byte(id)		
	write_string(message);
	message_end();	
}

Team_Info(id, type, team[])
{
	static bool:teaminfo_used;
	static get_user_msgid_teaminfo;
	if(!teaminfo_used)
	{
		get_user_msgid_teaminfo = get_user_msgid("TeamInfo");
		teaminfo_used = true;
	}
	message_begin(type, get_user_msgid_teaminfo, _, id);
	write_byte(id);
	write_string(team);
	message_end();

	return 1;
}

ColorSelection(index, type, Color:Type)
{
	switch(Type)
	{
		case RED:
		{
			return Team_Info(index, type, TeamName[1]);
		}
		case BLUE:
		{
			return Team_Info(index, type, TeamName[2]);
		}
		case GREY:
		{
			return Team_Info(index, type, TeamName[0]);
		}
	}

	return 0;
}

FindPlayer()
{
	new i = -1;

	while(i <= get_maxplayers())
	{
		if(is_user_connected(++i))
			return i;
	}

	return -1;
}

//*Plugin*//
public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_cvar("card_version", VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_clcmd("say /card", "cmd_card")
	register_clcmd("say /kartya", "cmd_card")
	register_clcmd("say_team /card", "cmd_card")
	register_clcmd("say_team /kartya", "cmd_card")
	register_clcmd("say /cardhelp", "cardhelp")
	register_clcmd("say_team /cardhelp", "cardhelp")
	register_clcmd("say /kartyasegitseg", "cardhelp")
	register_clcmd("say_team /kartyasegitseg", "cardhelp")
	
	g_Switch = register_cvar("card_amxcards", "1")
	g_CardMode = register_cvar("card_mode", "1")
	g_PCardMult = register_cvar("card_powercard_mult", "2.0")
	g_MaxLife = register_cvar("card_lifecard_maxhealth", "200")
	g_MaxArmor = register_cvar("card_armorcard_maxarmor", "500")
	g_MaxMoney = register_cvar("card_moneycard_maxmoney", "16000")
	g_MoneyPerSec = register_cvar("card_moneycard_mpc", "10")
	g_InvisPercentage = register_cvar("card_invisiblepercent", "25")
	
	g_PCard = register_cvar("card_powercard", "0")
	g_DCard = register_cvar("card_deathcard", "0")
	g_LCard = register_cvar("card_lifecard", "0")
	g_MCard = register_cvar("card_mysterycard", "0")
	g_IACard = register_cvar("card_infiniteammocard", "0")
	g_StrCard = register_cvar("card_strippercard", "0")
	g_RBCard = register_cvar("card_rainbowcard", "0")
	g_ACard = register_cvar("card_armorcard", "0")
	g_SpCard = register_cvar("card_speedcard", "0")
	g_SlCard = register_cvar("card_slowcard", "0")
	g_WCard = register_cvar("card_weaknesscard", "0")
	g_GCard = register_cvar("card_gravitycard", "0")
	g_NCard = register_cvar("card_nadecard", "0")
	g_SpyCard = register_cvar("card_spycard", "0")
	g_MoneyCard = register_cvar("card_moneycard", "0")
	g_BankruptCard = register_cvar("card_bankruptcard", "0")
	g_SglassesCard = register_cvar("card_sunglassescard", "0")
	g_InvisCard = register_cvar("card_invisiblecard", "0")
	g_GlowCard = register_cvar("card_glowcard", "0")
	
	new CardMode = get_pcvar_num(g_CardMode)
	switch(CardMode) {
		case 0:
		{
			set_pcvar_num(g_PCard, 1)
			set_pcvar_num(g_DCard, 1)
			set_pcvar_num(g_LCard, 1)
			set_pcvar_num(g_MCard, 1)
			set_pcvar_num(g_IACard, 1)
			set_pcvar_num(g_StrCard, 1)
			set_pcvar_num(g_RBCard, 1)
			set_pcvar_num(g_ACard, 1)
			set_pcvar_num(g_SpCard, 1)
			set_pcvar_num(g_SlCard, 1)
			set_pcvar_num(g_WCard, 1)
			set_pcvar_num(g_GCard, 1)
			set_pcvar_num(g_NCard, 1)
			set_pcvar_num(g_SpyCard, 1)
			set_pcvar_num(g_MoneyCard, 1)
			set_pcvar_num(g_BankruptCard, 1)
			set_pcvar_num(g_SglassesCard, 1)
			set_pcvar_num(g_InvisCard, 1)
			set_pcvar_num(g_GlowCard, 1)
		}
		case 1:
		{
			set_pcvar_num(g_PCard, 1)
			set_pcvar_num(g_DCard, 1)
			set_pcvar_num(g_LCard, 1)
			set_pcvar_num(g_MCard, 1)
			set_pcvar_num(g_IACard, 1)
			set_pcvar_num(g_StrCard, 1)
		}
		case 2:
		{
			set_pcvar_num(g_RBCard, 1)
			set_pcvar_num(g_ACard, 1)
			set_pcvar_num(g_SpCard, 1)
			set_pcvar_num(g_SlCard, 1)
			set_pcvar_num(g_WCard, 1)
			set_pcvar_num(g_GCard, 1)
		}
		case 3:
		{
			set_pcvar_num(g_NCard, 1)
			set_pcvar_num(g_SpyCard, 1)
			set_pcvar_num(g_MoneyCard, 1)
			set_pcvar_num(g_BankruptCard, 1)
			set_pcvar_num(g_SglassesCard, 1)
			set_pcvar_num(g_InvisCard, 1)
			set_pcvar_num(g_GlowCard, 1)
		}
	}
	
	register_logevent("logevent_round_end", 2, "1=Round_End")
	
	set_task(300.0, "advertise")
	
	if(!get_pcvar_num(g_SglassesCard))
		return PLUGIN_CONTINUE
		
	g_nMsgScreenFade2 = get_user_msgid("ScreenFade")
	register_event("ScreenFade","sunglassescard","be","4=255","5=255","6=255","7>199")
	return PLUGIN_CONTINUE
}

public cardhelp(id) {
	show_motd(id, "help.txt", "Card Help")
}
public advertise(id){
	client_print(id,print_chat,"^1[^4Random Kártya^1]Ezen a szerveren az ^3AMX Cards ^4 %s ^1verziója fut (további információért ^3/cardhelp ^1vagy ^3/kartyasegitseg^1)",VERSION)
}

public cmd_card(id) {
	new nev[32]
	get_user_name(id, nev, 31)
	if(!get_pcvar_num(g_Switch))
		return PLUGIN_HANDLED

	if(hasCard[id]) {
		ColorChat(id, GREEN, "^1[^4Random Kártya^1]Ebben a körben már kiválasztottál egy kártyát ^3%s ^1!",nev)
		return PLUGIN_HANDLED;
	}
	hasCard[id] = 1;
	new rand = random_num(1,19)
	
	switch(rand)
	{
		case 1:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Halál ^1Kártyát!",nev)
			deathcard(id)
		}
		case 2:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Élet ^1Kártyát!",nev)
			lifecard(id)
		}
		case 3:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Rejtély ^1Kártyát!",nev)
			mysterycard(id)
		}
		case 4:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Végtelen Löszer ^1Kártyát!",nev)
			infiniteammocard(id)
		}
		case 5:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Lefegyvezerés ^1Kártyát!",nev)
			strippercard(id)
		}
		case 6:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Szivárvány ^1Kártyát!",nev)
			rainbowcard(id)
		}
		case 7:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Páncél ^1Kártyát!",nev)
			armorcard(id)
		}
		case 8:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Sebesség ^1Kártyát!",nev)
			speedcard(id)
		}
		case 9:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Lassú ^1Kártyát!",nev)
			slowcard(id)
		}
		case 10:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Erö ^1Kártyát!",nev)
			powercard(id)
		}
		case 11:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Gyengeség^1Kártyát!",nev)
			weaknesscard(id)
		}
		case 12:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Gravitáció ^1Kártyát!",nev)
			gravitycard(id)
		}
		case 13:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Gránát ^1Kártyát!",nev)
			nadecard(id)
		}
		case 14:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Kém ^1Kártyát!",nev)
			spycard(id)
		}
		case 15:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Pénz ^1Kártyát!",nev)
			moneycard(id)
		}
		case 16:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Csöd ^1Kártyát!",nev)
			bankruptcard(id)
		}
		case 17:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Láthatatlan ^1Kártyát!",nev)
			invisiblecard(id)
		}
		case 18:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Világitó ^1Kártyát!",nev)
			glowcard(id)
		}
		case 19:
		{
			ColorChat(id, GREEN, "^1[^4Random Kártya^1]Szép munka ^3%s^1!Megkaptad a ^4 Napszemüveg ^1Kártyát!",nev)
			sunglassescard(id)
		}
	}
	return PLUGIN_CONTINUE
}

public deathcard(id) {
	if(!get_pcvar_num(g_DCard))
		return PLUGIN_CONTINUE
	
	client_cmd(id, "kill")
	return PLUGIN_CONTINUE
}

public give_life(id) {
	new health = get_user_health(id)
	new maxhealth = get_pcvar_num(g_MaxLife)
	if(health == maxhealth)
		return PLUGIN_CONTINUE
		
	set_user_health(id, health+3)
	set_task(1.0, "give_life", id)
	return PLUGIN_CONTINUE
}

public give_armor(id) {
	new armor = get_user_armor(id)
	new maxarmor = get_pcvar_num(g_MaxArmor)
	if(armor == maxarmor)
		return PLUGIN_CONTINUE
		
	set_user_armor(id, armor+5)
	set_task(1.0, "give_armor", id)
	return PLUGIN_CONTINUE
}

public lifecard(id) {
	if(!get_pcvar_num(g_LCard))
		return PLUGIN_CONTINUE

	give_life(id)
	return PLUGIN_CONTINUE
}

public armorcard(id) {
	if(!get_pcvar_num(g_ACard))
		return PLUGIN_CONTINUE
	
	give_armor(id)
	return PLUGIN_CONTINUE
}

public speedcard(id) {
	if(!get_pcvar_num(g_SpCard))
		return PLUGIN_CONTINUE
	
	set_user_maxspeed(id, 640.0)
	return PLUGIN_CONTINUE
}

public slowcard(id) {
	if(!get_pcvar_num(g_SlCard))
		return PLUGIN_CONTINUE
	
	set_user_maxspeed(id, 160.0)
	return PLUGIN_CONTINUE
}

public powercard(id) {
	if(!get_pcvar_num(g_PCard))
		return PLUGIN_CONTINUE
	
	new damage = read_data(2)
	new Float:damage_mult = damage * get_pcvar_float(g_PCardMult)
	damage == damage_mult
	
	return PLUGIN_CONTINUE
}

public weaknesscard(id) {
	if(!get_pcvar_num(g_WCard))
		return PLUGIN_CONTINUE
	
	new damage = read_data(2)
	new Float:damage_mult = damage / get_cvar_float("powercard_mult")
	damage == damage_mult
	
	return PLUGIN_CONTINUE
}

public mysterycard(id) {
	if(!get_pcvar_num(g_MCard))
		return PLUGIN_CONTINUE
	
	new rand2 = random_num(1, 3)
	
	switch(rand2)
	{
		case 1:
		{
			set_user_noclip(id, 1)
		}
		case 2:
		{
			set_user_godmode(id, 1)
		}
		case 3:
		{
			set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
		}
	}
	return PLUGIN_CONTINUE
}

public infiniteammocard(id) {
	if(!get_pcvar_num(g_IACard))
		return PLUGIN_CONTINUE

	new clip, ammo
	get_user_weapon(id, clip, ammo)
	
	if(clip==0)
	{
		cs_set_weapon_ammo(id, 30)
	}
	return PLUGIN_CONTINUE
}

public strippercard(id) {
	if(!get_pcvar_num(g_StrCard))
		return PLUGIN_CONTINUE
	
	strip_user_weapons(id)
	give_item(id, "weapon_knife")
	set_user_health(id, 15)
	return PLUGIN_CONTINUE
}

public rainbowcard(id) {
	if(!get_pcvar_num(g_RBCard))
		return PLUGIN_CONTINUE
	
	new rand3 = random_num(1, 4)
	
	new rgb[3]
	
	switch(rand3)
	{
		case 1:
		{
			rgb[0] = 255
			rgb[1] = 0
			rgb[2] = 0
		}
		case 2:
		{
			rgb[0] = 255
			rgb[1] = 255
			rgb[2] = 0
		}
		case 3:
		{
			rgb[0] = 255
			rgb[1] = 255
			rgb[2] = 255
		}
		case 4:
		{
			rgb[0] = 0
			rgb[1] = 255
			rgb[2] = 0
		}
	}
	message_begin(MSG_ONE, g_nMsgScreenFade, {0,0,0}, id)
	write_short(read_data(1))
	write_short(read_data(2))
	write_short(read_data(3))
	write_byte (rgb[0])
	write_byte (rgb[1])
	write_byte (rgb[2])
	write_byte (read_data(7))
	message_end()
	
	return PLUGIN_CONTINUE
}

public gravitycard(id) {
	if(!get_pcvar_num(g_GCard))
		return PLUGIN_CONTINUE
	
	new rand5 = random_num(1, 4)
	
	switch(rand5) {
		case 1: {
			set_user_gravity(id, 100.0)
		}
		case 2: {
			set_user_gravity(id, 200.0)
		}
		case 3: {
			set_user_gravity(id, 300.0)
		}
		case 4: {
			set_user_gravity(id, 400.0)
		}
	}
	return PLUGIN_CONTINUE
}

public givenade(id) {
	give_item(id, "weapon_hegrenade")
	set_task(0.1, "givenade", id)
}

public nadecard(id) {
	if(!get_pcvar_num(g_NCard))
		return PLUGIN_CONTINUE
	
	givenade(id)
	return PLUGIN_CONTINUE
}

public spycard(id) {
	if(!get_pcvar_num(g_SpyCard))
		return PLUGIN_CONTINUE
    
	new Team = get_user_team(id)
	new rand4 = random_num(1, 4)
    
	switch(rand4)
	{
		case 1: 
		{
			if(Team == 1) 
			{
				cs_set_user_model(id, "sas")
			} else if(Team == 2) {
				cs_set_user_model(id, "leet")
			}
		}
		case 2: 
		{
			if(Team== 1) 
			{
				cs_set_user_model(id, "gsg9")
			} else if(Team == 2) {
				cs_set_user_model(id, "arctic")
			}
		}
		case 3: 
		{
			if(Team == 1) 
			{
				cs_set_user_model(id, "gign")
			} else if(Team == 2) {
				cs_set_user_model(id, "guerilla")
			}
		}
		case 4: 
		{
			if(Team== 1) 
			{
				cs_set_user_model(id, "urban")
			} else if(Team == 2) {
				cs_set_user_model(id, "phoenix")
			}
		}
	}
	return PLUGIN_CONTINUE
}

public give_money(id) {
	new money = cs_get_user_money(id)
	if(money==get_pcvar_num(g_MaxMoney))
		return PLUGIN_CONTINUE
		
	cs_set_user_money(id, money + get_pcvar_num(g_MoneyPerSec))
	set_task(1.0, "give_money", id)
	return PLUGIN_CONTINUE
}

public moneycard(id) {
	if(!get_pcvar_num(g_MoneyCard))
		return PLUGIN_CONTINUE
	
	give_money(id)
	return PLUGIN_CONTINUE
}

public bankruptcard(id) {
	if(!get_pcvar_num(g_BankruptCard))
		return PLUGIN_CONTINUE
	
	new money = cs_get_user_money(id)
	cs_set_user_money(id, money - money)
	return PLUGIN_CONTINUE
}

public sunglassescard(id) {
	if(!get_pcvar_num(g_SglassesCard))
		return PLUGIN_CONTINUE

	message_begin(MSG_ONE, g_nMsgScreenFade2, {0,0,0}, id)
	write_short(read_data(1))
	write_short(read_data(2))
	write_short(read_data(3))
	write_byte (0)
	write_byte (0)
	write_byte (0)
	write_byte (read_data(7))
	message_end()
	return PLUGIN_CONTINUE
}

public invisiblecard(id) {
	if(!get_pcvar_num(g_InvisCard))
		return PLUGIN_CONTINUE
	
	new percentage = get_pcvar_num(g_InvisPercentage)
	set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderNormal, percentage)
	return PLUGIN_CONTINUE
}

public glowcard(id) {
	if(!get_pcvar_num(g_GlowCard))
		return PLUGIN_CONTINUE
	
	set_user_rendering(id, kRenderFxNone, 224, 12, 224, kRenderGlow, 100)
	return PLUGIN_CONTINUE
}

public logevent_round_end()
{
	new players[32], num;
	get_players(players, num);
	new id;

	for(new i=0;i<num;i++)
	{
		id = players[i]

		hasCard[id] = 0
		set_user_godmode(id, 0)
		set_user_noclip(id, 0)
		set_user_health(id, 100)
		set_user_maxspeed(id, 320.0)
		set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderNormal, 100)
		cs_reset_user_model(id)
	}
}
