#include <amxmodx>
#include <amxmisc>
#include <fakemeta>

#define PLUGIN		"Custom Knife Models"
#define VERSION		"1.0"
#define AUTHOR		"AndrewZ"

#define MAX_LINES	16

new g_player[ MAX_LINES ][ 36 ]
new g_v_model[ MAX_LINES ][ 64 ]
new g_p_model[ MAX_LINES ][ 64 ]

public plugin_init()
{
	register_plugin( PLUGIN, VERSION, AUTHOR )
	
	register_event( "CurWeapon", "event_curweapon", "be", "1=1" )
}

public plugin_precache()
{
	new configs_dir[ 64 ]
	get_configsdir( configs_dir, 63 )
	format( configs_dir, 63, "%s/knife_models.ini", configs_dir )
	
	new line, string[ 164 ], textsize
	
	while( read_file( configs_dir, line, string, 163, textsize ) )
	{
		parse( string, g_player[ line ], 35, g_v_model[ line ], 63, g_p_model[ line ], 63 )
		
		precache_model( g_v_model[ line ] )
		precache_model( g_p_model[ line ] )
		
		line ++
	}
}

public event_curweapon( id )
{
	if( read_data( 2 ) != CSW_KNIFE )
		return PLUGIN_HANDLED

	for( new l; l < MAX_LINES - 1; l ++ )
	{
		if( g_player[ l ][ 0 ] )
		{
			if( g_player[ l ][ 0 ] == 'S' && 
				g_player[ l ][ 1 ] == 'T' && 
				g_player[ l ][ 2 ] == 'E' &&
				g_player[ l ][ 3 ] == 'A' &&
				g_player[ l ][ 4 ] == 'M' &&
				g_player[ l ][ 5 ] == '_' )
			{
				new authid[ 36 ]
				get_user_authid( id, authid, 35 ) 
				
				if( equal( g_player[ l ], authid ) )
				{
					set_user_knife_models( id, l )
					break
				}
			}
			
			else
			{
				new name[ 32 ]
				get_user_name( id, name, 31 )
				
				if( equal( g_player[ l ], name ) )
				{
					set_user_knife_models( id, l )
					break
				}
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

public set_user_knife_models( id, line )
{
	set_pev( id, pev_viewmodel2, g_v_model[ line ] )
	set_pev( id, pev_weaponmodel2, g_p_model[ line ] )
}