#include < amxmodx >
#include < amxmisc >

new szSound [ 32 + 1 ][ 63 + 1 ],
	Sound [ 33 ], lens, r_num = 0

public plugin_init ( )
{
	register_plugin ( "Round End", "1.0", "OverGame" )
	
	register_cvar ( "re_info", "1" )
	register_cvar ( "re_start_off", "0" )
	
	register_logevent ( "logevent_round_start", 2, "1=Round_Start" )
	register_logevent ( "logevent_round_end", 2, "1=Round_End" )
	
	register_clcmd ( "say /korvegi", "volume_control" )
	register_clcmd ( "say_team /korvegi", "volume_control" )
	
	set_task ( 600.0, "control_info", _, _, _, "b" )
	register_dictionary ( "round_end.txt" )
}

public plugin_precache ( )
{
	read_ini ( )
	
	new i
	for ( i = 1; i <= lens; i++ )
		precache_sound ( szSound [ i ] )
}

public plugin_cfg ( )
{
	new szCfgDir [ 64 ], szFile [ 192 ]
	get_configsdir ( szCfgDir, charsmax ( szCfgDir ) )
	format ( szFile, charsmax ( szFile ), "%s/round_end.cfg", szCfgDir )
	
	if ( file_exists ( szFile ) )
		server_cmd ( "exec %s", szFile )
}

public read_ini ( )
{
	new len = 1, buffer [ 256 ]
	new file = fopen ( "/addons/amxmodx/configs/round_end.ini", "r" )
	
	while ( !feof ( file ) )
	{
		fgets ( file, buffer, 255 )
		trim ( buffer )
		
		if ( buffer [ 0 ] == '"' )
		{
			parse ( buffer, szSound [ len ], 63 )
		} else {
			continue
		}
		len++
	}
	
	lens = len - 1
	fclose ( file )
}

public logevent_round_start ( )
{
	for ( new id = 1; id <= get_maxplayers (); id++ )
	{
		if ( get_cvar_num ( "re_start_off" ) ) 
			client_cmd ( id, "mp3 stop" )
	}
	
	return PLUGIN_CONTINUE
}

public logevent_round_end ( )
{
	if ( r_num == lens )
		r_num = 0
	
	r_num++

	for ( new id = 1; id <= get_maxplayers (); id++ )
	{
		if ( is_user_connected ( id ) && Sound [ id ] )
			client_cmd ( id, "mp3 play sound/%s", szSound [ r_num ] )
	}
	
	return PLUGIN_CONTINUE
}

public client_putinserver ( id )
	Sound [ id ] = true

public control_info ( )
{
	for ( new id = 1; id <= get_maxplayers (); id++ )
	{
		if ( is_user_connected ( id ) && get_cvar_num ( "re_info" ) )
		{
			ShowMsg ( id, "%L %L", LANG_SERVER, "RE_PREFIX", LANG_SERVER, "RE_INFO" )
		}
	}
	
	return PLUGIN_CONTINUE
}
	
public volume_control ( id )
{
	if ( Sound [ id ] )
	{
		Sound [ id ] = false
		ShowMsg ( id, "%L %L", LANG_SERVER, "RE_PREFIX", LANG_SERVER, "RE_OFF" )
	} else {
		Sound [ id ] = true
		ShowMsg ( id, "%L %L", LANG_SERVER, "RE_PREFIX", LANG_SERVER, "RE_ON" )
	}
	
	return PLUGIN_HANDLED
}

stock ShowMsg ( const id, const input [ ], any:... )
{
	new count = 1, players [ 32 ]
	static msg [ 188 ]
	vformat ( msg, 187, input, 3 )
	
	replace_all ( msg, 187, "!g", "^4" )
	replace_all ( msg, 187, "!y", "^1" )
	replace_all ( msg, 187, "!t", "^3" )
	
	if ( id ) players [ 0 ] = id; else get_players ( players, count, "ch" )
	{
		for ( new i = 0; i < count; i++ )
		{
			if ( is_user_connected ( players [ i ] ) )
			{
				message_begin ( MSG_ONE_UNRELIABLE, get_user_msgid ( "SayText" ), _, players [ i ] )
				write_byte ( players [ i ] )
				write_string ( msg )
				message_end ( )
			}
		}
	}
}