#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fakemeta_util>

// #define ZP_SUPPORT 

#define PREFIX "CSO COSTUMES" 
#define DICTIONARY "cso_like_costumes.txt" 

#define MAX_MODELS 4

#if defined ZP_SUPPORT
    #include <hamsandwich>
    #include <zombieplague>
#endif

new menu[33]
new g_CostumeModelBack[33]
new g_CostumeModelBack2[33]
new g_CostumeModelHead[33]
new g_CostumeModelPelvis[33]
new costume_back[33]
new costume_head[33]
new costume_pelvis[33]
new save_costume_back[33]
new save_costume_head[33]
new save_costume_pelvis[33]

new bool:g_HadCostumeModel[33]

new const CostumeNamesBack[][] =
{
    "Acorn (Back)", 
    "Angel Wings",
    "Cat Tuna", 
    "Christmas Socks",
    "Clock",
    "Devil Wings", 
    "Golden Shield", 
    "Kid Ghost", 
    "Panda Doll",
    "Pig Fork", 
    "Penguin Doll"
}

new const CostumeNamesHead[][] =
{
    "Angel Halo",
    "Bazzi Head", 
    "Cat Ears", 
    "Dao Head", 
    "Devil Horns", 
    "Golden Mask", 
    "Panda Ear", 
    "Pig Ears", 
    "Polar Bear Head", 
    "Pumpkin Head", 
    "Snowman Head",
    "Squirrel Ears" 
}

new const CostumeNamesPelvis[][] =
{
    "Cat Tail", 
    "Devil Tail", 
    "Panda Tail",
    "Pig Tail",
    "Squirrel Tail"
}

new const CostumeModels[MAX_MODELS][] =
{
    "models/cso_like_costumes/cso_like_costumes_back.mdl",
    "models/cso_like_costumes/cso_like_costumes_face.mdl",
    "models/cso_like_costumes/cso_like_costumes_head.mdl", 
    "models/cso_like_costumes/cso_like_costumes_pelvis.mdl"
}

public plugin_init()
{
    register_plugin("[CSO LIKE] Costumes", "1.0", "RaZzoR")
    register_clcmd("say /costumes", "costumes")

    #if defined ZP_SUPPORT
        RegisterHam(Ham_Spawn, "player", "Spawn", 1)
    #endif

    register_dictionary(DICTIONARY)
}

public client_putinserver(id)
{
    g_CostumeModelBack[id] = 0
    g_CostumeModelBack2[id] = 0
    g_CostumeModelHead[id] = 0
    g_CostumeModelPelvis[id] = 0

    costume_back[id] = 0
    costume_head[id] = 0
    costume_pelvis[id] = 0
    save_costume_back[id] = 0
    save_costume_head[id] = 0
    save_costume_pelvis[id] = 0
}

public client_disconnect(id)
{
    g_CostumeModelBack[id] = 0
    g_CostumeModelBack2[id] = 0
    g_CostumeModelHead[id] = 0
    g_CostumeModelPelvis[id] = 0

    costume_back[id] = 0
    costume_head[id] = 0
    costume_pelvis[id] = 0
    save_costume_back[id] = 0
    save_costume_head[id] = 0
    save_costume_pelvis[id] = 0
}

public plugin_precache()
{	
    for(new i = 0; i < MAX_MODELS; i++)
    {
	precache_model(CostumeModels[i])
    }
}

#if defined ZP_SUPPORT
    public zp_user_infected_post(id)
    {
        reset_costume(id, 1)
        reset_costume(id, 2)
        reset_costume(id, 3)
        reset_costume(id, 4)

        g_HadCostumeModel[id] = false
    }

    public Spawn(id)
    {
        set_task(2.0, "load", id)
    }

    public load(id)
    {
             if(g_HadCostumeModel[id] || zp_get_user_zombie(id))
                return

             if(save_costume_back[id] == 1)
             {
                if(costume_back[id] == 1)
                {
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 10) 

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[0]) 

                   if(costume_back[id] == 1 && costume_head[id] == 12 && costume_pelvis[id] == 5)
                   {  
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 3)
                   }
               }

               else if(costume_back[id] == 2)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 0) 

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[1]) 
               }

               else if(costume_back[id] == 3)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 1)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[2]) 

                   if(costume_back[id] == 3 && costume_head[id] == 3 && costume_pelvis[id] == 1)
                   {
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 0)
                   }
               }

               else if(costume_back[id] == 4)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)
 
                   make_costume(id, CostumeModels[0], 1, 9)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[3]) 
               }

               else if(costume_back[id] == 5)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 2)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[4])
               } 

               else if(costume_back[id] == 6)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)
  
                   make_costume(id, CostumeModels[0], 1, 3)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[5]) 
               }

               else if(costume_back[id] == 7)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 4)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[6])
               }

               else if(costume_back[id] == 8)
               { 
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 8)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[7])
               } 

               else if(costume_back[id] == 9)
               {
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 5)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[8]) 

                   if(costume_back[id] == 9 && costume_head[id] == 7 && costume_pelvis[id] == 3)
                   {
                      reset_costume(id, 4)
 
                      make_costume(id, CostumeModels[1], 4, 1)
                   }
               }

               else if(costume_back[id] == 10)
               {     
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 6)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[9]) 

                   if(costume_back[id] == 10 && costume_head[id] == 8 && costume_pelvis[id] == 4)
                   {
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 2)
                   } 
               }

               else if(costume_back[id] == 11)
               { 
                   reset_costume(id, 1)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[0], 1, 7)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesBack[10])
               } 
             }

             if(save_costume_head[id] == 1)
             {
               if(costume_head[id] == 1)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 0)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[0])
               } 

               else if(costume_head[id] == 2)
               {                 
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 1)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[1])
               } 

               else if(costume_head[id] == 3)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 2)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[2]) 

                   if(costume_back[id] == 3 && costume_head[id] == 3 && costume_pelvis[id] == 1)
                   {
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 0)
                   }
               }

               else if(costume_head[id] == 4)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 3)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[3]) 
               }

               else if(costume_head[id] == 5)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 4)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[4]) 
               }

               else if(costume_head[id] == 6)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 5)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[5])
               } 

               else if(costume_head[id] == 7)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 6)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[6]) 
                 
                   if(costume_back[id] == 9 && costume_head[id] == 7 && costume_pelvis[id] == 3)
                   {
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 1)
                   }
               }

               else if(costume_head[id] == 8)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 7)
 
                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[7])
               
                   if(costume_back[id] == 10 && costume_head[id] == 8 && costume_pelvis[id] == 4)
                   {
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 2)
                   } 
               }

               else if(costume_head[id] == 9)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 8)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[8]) 
               }

               else if(costume_head[id] == 10)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 9)       

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[9]) 
               }

               else if(costume_head[id] == 11)
               {
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 10)

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[10])
               }

               else if(costume_head[id] == 12)
               { 
                   reset_costume(id, 2)
                   reset_costume(id, 4)

                   make_costume(id, CostumeModels[2], 2, 11)    

                   print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesHead[11]) 
         
                   if(costume_back[id] == 1 && costume_head[id] == 12 && costume_pelvis[id] == 5)
                   {
                      reset_costume(id, 4)

                      make_costume(id, CostumeModels[1], 4, 3)
                   }
               }
             }

             if(save_costume_pelvis[id] == 1)
             {
               if(costume_pelvis[id] == 1)
               { 
                    reset_costume(id, 3)
                    reset_costume(id, 4)

                    make_costume(id, CostumeModels[3], 3, 0)

                    print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesPelvis[0])

                    if(costume_back[id] == 3 && costume_head[id] == 3 && costume_pelvis[id] == 1)
                    {
                       reset_costume(id, 4)

                       make_costume(id, CostumeModels[1], 4, 0)
                    } 
               }

               else if(costume_pelvis[id] == 2)
               { 
                    reset_costume(id, 3)
                    reset_costume(id, 4)

                    make_costume(id, CostumeModels[3], 3, 1)

                    print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesPelvis[1]) 
               }

               else if(costume_pelvis[id] == 3)
               { 
                    reset_costume(id, 3)
                    reset_costume(id, 4)	

                    make_costume(id, CostumeModels[3], 3, 2)

                    print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesPelvis[2]) 
 
                    if(costume_back[id] == 9 && costume_head[id] == 7 && costume_pelvis[id] == 3)
                    {
                       reset_costume(id, 4)

                       make_costume(id, CostumeModels[1], 4, 1)
                    }
               }

               else if(costume_pelvis[id] == 4)
               { 
                    reset_costume(id, 3)
                    reset_costume(id, 4)	

                    make_costume(id, CostumeModels[3], 3, 3)

                    print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesPelvis[3])

                    if(costume_back[id] == 10 && costume_head[id] == 8 && costume_pelvis[id] == 4)
                    {
                       reset_costume(id, 4)

                       make_costume(id, CostumeModels[1], 4, 2)
                    }
               }

               else if(costume_pelvis[id] == 5)
               {
                    reset_costume(id, 3)
                    reset_costume(id, 4)	

                    make_costume(id, CostumeModels[3], 3, 4)

                    print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_LOADED", CostumeNamesPelvis[4]) 

                    if(costume_back[id] == 1 && costume_head[id] == 12 && costume_pelvis[id] == 5)
                    {
                       reset_costume(id, 4)

                       make_costume(id, CostumeModels[1], 4, 3)
                    }
               }
             }

        g_HadCostumeModel[id] = true
    } 
#endif


public costumes(id)
{
    static Letterhead[64]
    static MenuName[64]

    #if defined ZP_SUPPORT
        if(zp_get_user_zombie(id))
        {
            print_colorchat(id, "!g[%s] !n%L", PREFIX, LANG_PLAYER, "CSO_NO_ZOMBIE")
            return
        }
    #endif
 
    format(Letterhead, 63, "\w%L\r", LANG_PLAYER, "CSO_CHOOSE_CATEGORY")
    menu[id] = menu_create(Letterhead, "costumes_handler")       

    format(MenuName, 63, "\w%L", LANG_PLAYER, "CSO_BACK")
    menu_additem(menu[id], MenuName, "1", 0)

    format(MenuName, 63, "\w%L", LANG_PLAYER, "CSO_HEAD")
    menu_additem(menu[id], MenuName, "2", 0)

    format(MenuName, 63, "\w%L^n", LANG_PLAYER, "CSO_PELVIS")
    menu_additem(menu[id], MenuName, "3", 0)

    format(MenuName, 63, "\w%L", LANG_PLAYER, "CSO_NO_COSTUME")
    menu_additem(menu[id], MenuName, "4", 0) 

    menu_setprop(menu[id], MPROP_EXIT, MEXIT_ALL)
    menu_display(id, menu[id], 0)
}

public back_menu(id)
{
    static Letterhead[64]
    static MenuName[64]
 
    format(Letterhead, 63, "\w%L\r", LANG_PLAYER, "CSO_CHOOSE_COSTUME")
    menu[id] = menu_create(Letterhead, "back_handler")    

    format(MenuName, 63, "\w%s", CostumeNamesBack[0])
    menu_additem(menu[id], MenuName, "1", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[1])
    menu_additem(menu[id], MenuName, "2", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[2])
    menu_additem(menu[id], MenuName, "3", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[3])
    menu_additem(menu[id], MenuName, "4", 0)
  
    format(MenuName, 63, "\w%s", CostumeNamesBack[4])
    menu_additem(menu[id], MenuName, "5", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[5])
    menu_additem(menu[id], MenuName, "6", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[6])
    menu_additem(menu[id], MenuName, "7", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[7])
    menu_additem(menu[id], MenuName, "8", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[8])
    menu_additem(menu[id], MenuName, "9", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[9])
    menu_additem(menu[id], MenuName, "10", 0)

    format(MenuName, 63, "\w%s", CostumeNamesBack[10])
    menu_additem(menu[id], MenuName, "11", 0)

    menu_setprop(menu[id], MPROP_EXIT, MEXIT_ALL)
    menu_display(id, menu[id], 0)
}

public head_menu(id)
{
    static Letterhead[64]
    static MenuName[64]
 
    format(Letterhead, 63, "\w%L\r", LANG_PLAYER, "CSO_CHOOSE_COSTUME")
    menu[id] = menu_create(Letterhead, "head_handler")    

    format(MenuName, 63, "\w%s", CostumeNamesHead[0])
    menu_additem(menu[id], MenuName, "1", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[1])
    menu_additem(menu[id], MenuName, "2", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[2])
    menu_additem(menu[id], MenuName, "3", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[3])
    menu_additem(menu[id], MenuName, "4", 0)
  
    format(MenuName, 63, "\w%s", CostumeNamesHead[4])
    menu_additem(menu[id], MenuName, "5", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[5])
    menu_additem(menu[id], MenuName, "6", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[6])
    menu_additem(menu[id], MenuName, "7", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[7])
    menu_additem(menu[id], MenuName, "8", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[8])
    menu_additem(menu[id], MenuName, "9", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[9])
    menu_additem(menu[id], MenuName, "10", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[10])
    menu_additem(menu[id], MenuName, "11", 0)

    format(MenuName, 63, "\w%s", CostumeNamesHead[11])
    menu_additem(menu[id], MenuName, "12", 0)

    menu_setprop(menu[id], MPROP_EXIT, MEXIT_ALL)
    menu_display(id, menu[id], 0)
}

public pelvis_menu(id)
{
    static Letterhead[64]
    static MenuName[64]
 
    format(Letterhead, 63, "\w%L\r", LANG_PLAYER, "CSO_CHOOSE_COSTUME")
    menu[id] = menu_create(Letterhead, "pelvis_handler")    

    format(MenuName, 63, "\w%s", CostumeNamesPelvis[0])
    menu_additem(menu[id], MenuName, "1", 0)

    format(MenuName, 63, "\w%s", CostumeNamesPelvis[1])
    menu_additem(menu[id], MenuName, "2", 0)

    format(MenuName, 63, "\w%s", CostumeNamesPelvis[2])
    menu_additem(menu[id], MenuName, "3", 0)

    format(MenuName, 63, "\w%s", CostumeNamesPelvis[3])
    menu_additem(menu[id], MenuName, "4", 0)
  
    format(MenuName, 63, "\w%s", CostumeNamesPelvis[4])
    menu_additem(menu[id], MenuName, "5", 0)
 
    menu_setprop(menu[id], MPROP_EXIT, MEXIT_ALL)
    menu_display(id, menu[id], 0)
}

public costumes_handler(id, menu, item)
{
    if(item == MENU_EXIT)
    {
        menu_destroy(menu)
        return PLUGIN_HANDLED
    }
    
    new data[6], iName[64]
    new access, callback

    menu_item_getinfo(menu, item, access, data, 6, iName, 63, callback)
   
    new key = str_to_num(data)  

    if(key == 1)
    {
       back_menu(id)     
    }

    if(key == 2)
    {
       head_menu(id)           
    }

    if(key == 3)
    {
       pelvis_menu(id)          
    }
    
    if(key == 4)
    {  
       if(!g_HadCostumeModel[id])
       {
           print_colorchat(id, "!g[%s] !n%L", PREFIX, LANG_PLAYER, "CSO_NF_COSTUME")    
       }

       else
       {
           reset_costume(id, 1)
           reset_costume(id, 2)
           reset_costume(id, 3)
           reset_costume(id, 4)

           print_colorchat(id, "!g[%s] !n%L", PREFIX, LANG_PLAYER, "CSO_REMOVED")  

           g_HadCostumeModel[id] = false
  
           costume_back[id] = 0
           costume_head[id] = 0
           costume_pelvis[id] = 0
           save_costume_back[id] = 0
           save_costume_head[id] = 0
           save_costume_pelvis[id] = 0
       }
    }                

    menu_destroy(menu)
    return PLUGIN_HANDLED
}

public back_handler(id, menu, item)
{
    if(item == MENU_EXIT)
    {
        menu_destroy(menu)
        return PLUGIN_HANDLED
    }
    
    new data[6], iName[64]
    new access, callback
    menu_item_getinfo(menu, item, access, data, 6, iName, 63, callback)
   
    new key = str_to_num(data)

    if(key == 1)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 10) 

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[0]) 

        g_HadCostumeModel[id] = true 
        
        costume_back[id] = 1

        if(costume_back[id] == 1 && costume_head[id] == 12 && costume_pelvis[id] == 5)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 3)
        }
        
        save_costume_back[id] = 1
    }  

    if(key == 2)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 0) 

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[1]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 2

        save_costume_back[id] = 1
    }

    if(key == 3)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 1)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[2]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 3

        if(costume_back[id] == 3 && costume_head[id] == 3 && costume_pelvis[id] == 1)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 0)
        }

        save_costume_back[id] = 1
    }

    if(key == 4)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 9)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[3]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 4

        save_costume_back[id] = 1
    } 

    if(key == 5)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 2)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[4]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 5

        save_costume_back[id] = 1
    } 

    if(key == 6)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 3)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[5]) 

        costume_back[id] = 6

        save_costume_back[id] = 1
    }  

    if(key == 7)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 4)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[6]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 7

        save_costume_back[id] = 1
    } 

    if(key == 8)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 8)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[7]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 8

        save_costume_back[id] = 1
    } 

    if(key == 9)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 5)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[8]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 9

        if(costume_back[id] == 9 && costume_head[id] == 7 && costume_pelvis[id] == 3)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 1)
        }

        save_costume_back[id] = 1
    } 

    if(key == 10)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 6)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[9]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 10

        if(costume_back[id] == 10 && costume_head[id] == 8 && costume_pelvis[id] == 4)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 2)
        } 

        save_costume_back[id] = 1
    } 

    if(key == 11)
    {   
        reset_costume(id, 1)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[0], 1, 7)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesBack[10]) 

        g_HadCostumeModel[id] = true 

        costume_back[id] = 11

        save_costume_back[id] = 1
    } 

    menu_destroy(menu)
    return PLUGIN_HANDLED
}

public head_handler(id, menu, item)
{
    if(item == MENU_EXIT)
    {
        menu_destroy(menu)
        return PLUGIN_HANDLED
    }
    
    new data[6], iName[64]
    new access, callback
    menu_item_getinfo(menu, item, access, data, 6, iName, 63, callback)
   
    new key = str_to_num(data)

    if(key == 1)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 0)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[0]) 

        g_HadCostumeModel[id] = true  

        costume_head[id] = 1

        save_costume_head[id] = 1
    }  

    if(key == 2)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 1)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[1]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 2

        save_costume_head[id] = 1
    }

    if(key == 3)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 2)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[2]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 3
     
        if(costume_back[id] == 3 && costume_head[id] == 3 && costume_pelvis[id] == 1)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 0)
        }

        save_costume_head[id] = 1
    }

    if(key == 4)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 3)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[3]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 4

        save_costume_head[id] = 1
    } 

    if(key == 5)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 4)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[4]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 5

        save_costume_head[id] = 1
    } 

    if(key == 6)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 5)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[5]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 6

        save_costume_head[id] = 1
    }  

    if(key == 7)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 6)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[6]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 7

        if(costume_back[id] == 9 && costume_head[id] == 7 && costume_pelvis[id] == 3)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 1)
        }

        save_costume_head[id] = 1
    } 

    if(key == 8)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 7)
 
        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[7]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 8

        if(costume_back[id] == 10 && costume_head[id] == 8 && costume_pelvis[id] == 4)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 2)
        }

        save_costume_head[id] = 1
    } 

    if(key == 9)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 8)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[8]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 9

        save_costume_head[id] = 1
    } 

    if(key == 10)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 9)       

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[9]) 

        g_HadCostumeModel[id] = true 

        costume_head[id] = 10

        save_costume_head[id] = 1
    }

    if(key == 11)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 10)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[10]) 

        g_HadCostumeModel[id] = true

        costume_head[id] = 11

        save_costume_head[id] = 1
    } 

    if(key == 12)
    {   
        reset_costume(id, 2)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[2], 2, 11)    

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesHead[11]) 

        g_HadCostumeModel[id] = true

        costume_head[id] = 12

        if(costume_back[id] == 1 && costume_head[id] == 12 && costume_pelvis[id] == 5)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 3)
        }

        save_costume_head[id] = 1
    } 

    menu_destroy(menu)
    return PLUGIN_HANDLED
}

public pelvis_handler(id, menu, item)
{
    if(item == MENU_EXIT)
    {
        menu_destroy(menu)
        return PLUGIN_HANDLED
    }
    
    new data[6], iName[64]
    new access, callback
    menu_item_getinfo(menu, item, access, data, 6, iName, 63, callback)
   
    new key = str_to_num(data)

    if(key == 1)
    {   
        reset_costume(id, 3)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[3], 3, 0)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesPelvis[0]) 

        g_HadCostumeModel[id] = true  

        costume_pelvis[id] = 1

        if(costume_back[id] == 3 && costume_head[id] == 3 && costume_pelvis[id] == 1)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 0)
        }

        save_costume_pelvis[id] = 1
    }  

    if(key == 2)
    {   
        reset_costume(id, 3)
        reset_costume(id, 4)

        make_costume(id, CostumeModels[3], 3, 1)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesPelvis[1]) 

        g_HadCostumeModel[id] = true 

        costume_pelvis[id] = 2

        save_costume_pelvis[id] = 1
    }

    if(key == 3)
    {   
        reset_costume(id, 3)
        reset_costume(id, 4)	

        make_costume(id, CostumeModels[3], 3, 2)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesPelvis[2]) 

        g_HadCostumeModel[id] = true  

        costume_pelvis[id] = 3

        if(costume_back[id] == 9 && costume_head[id] == 7 && costume_pelvis[id] == 3)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 1)
        }

        save_costume_pelvis[id] = 1
    }

    if(key == 4)
    {   
        reset_costume(id, 3)
        reset_costume(id, 4)	

        make_costume(id, CostumeModels[3], 3, 3)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesPelvis[3]) 

        g_HadCostumeModel[id] = true  

        costume_pelvis[id] = 4

        if(costume_back[id] == 10 && costume_head[id] == 8 && costume_pelvis[id] == 4)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 2)
        }

        save_costume_pelvis[id] = 1
    }

    if(key == 5)
    {   
        reset_costume(id, 3)
        reset_costume(id, 4)	

        make_costume(id, CostumeModels[3], 3, 4)

        print_colorchat(id, "!g[%s] !n%L: !g%s", PREFIX, LANG_PLAYER, "CSO_CHOOSED", CostumeNamesPelvis[4]) 

        g_HadCostumeModel[id] = true  

        costume_pelvis[id] = 5

        if(costume_back[id] == 1 && costume_head[id] == 12 && costume_pelvis[id] == 5)
        {
            reset_costume(id, 4)

            make_costume(id, CostumeModels[1], 4, 3)
        }

        save_costume_pelvis[id] = 1
    }

    menu_destroy(menu)
    return PLUGIN_HANDLED
}

public make_costume(id, model[], part, anim)
{
    switch(part)
    {
        case 1:
        {
           g_CostumeModelBack[id] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))	

           set_pev(g_CostumeModelBack[id], pev_movetype, MOVETYPE_FOLLOW)
	   set_pev(g_CostumeModelBack[id], pev_aiment, id)
	   set_pev(g_CostumeModelBack[id], pev_rendermode, 	kRenderNormal)
	   engfunc(EngFunc_SetModel, g_CostumeModelBack[id], model)
           set_pev(g_CostumeModelBack[id], pev_body, anim)
           set_pev(g_CostumeModelBack[id], pev_sequence, anim)
           set_pev(g_CostumeModelBack[id], pev_animtime, get_gametime())
           set_pev(g_CostumeModelBack[id], pev_framerate, 1.0)
        }

        case 2:
        {
           g_CostumeModelHead[id] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))	

           set_pev(g_CostumeModelHead[id], pev_movetype, MOVETYPE_FOLLOW)
	   set_pev(g_CostumeModelHead[id], pev_aiment, id)
	   set_pev(g_CostumeModelHead[id], pev_rendermode, 	kRenderNormal)
	   engfunc(EngFunc_SetModel, g_CostumeModelHead[id], model)
           set_pev(g_CostumeModelHead[id], pev_body, anim)
           set_pev(g_CostumeModelHead[id], pev_sequence, anim)
           set_pev(g_CostumeModelHead[id], pev_animtime, get_gametime())
           set_pev(g_CostumeModelHead[id], pev_framerate, 1.0)
        }

        case 3:
        {
           g_CostumeModelPelvis[id] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))	

           set_pev(g_CostumeModelPelvis[id], pev_movetype, MOVETYPE_FOLLOW)
	   set_pev(g_CostumeModelPelvis[id], pev_aiment, id)
	   set_pev(g_CostumeModelPelvis[id], pev_rendermode, 	kRenderNormal)
	   engfunc(EngFunc_SetModel, g_CostumeModelPelvis[id], model)
           set_pev(g_CostumeModelPelvis[id], pev_body, anim)
           set_pev(g_CostumeModelPelvis[id], pev_sequence, anim)
           set_pev(g_CostumeModelPelvis[id], pev_animtime, get_gametime())
           set_pev(g_CostumeModelPelvis[id], pev_framerate, 1.0)
        }

        case 4:
        {
           g_CostumeModelBack2[id] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))	

           set_pev(g_CostumeModelBack2[id], pev_movetype, MOVETYPE_FOLLOW)
	   set_pev(g_CostumeModelBack2[id], pev_aiment, id)
	   set_pev(g_CostumeModelBack2[id], pev_rendermode, 	kRenderNormal)
	   engfunc(EngFunc_SetModel, g_CostumeModelBack2[id], model)
           set_pev(g_CostumeModelBack2[id], pev_body, anim)
           set_pev(g_CostumeModelBack2[id], pev_sequence, anim)
           set_pev(g_CostumeModelBack2[id], pev_animtime, get_gametime())
           set_pev(g_CostumeModelBack2[id], pev_framerate, 1.0)
        }
    }
}

public reset_costume(id, number)
{
    switch(number)
    {
	case 1:
	{
	   fm_set_entity_visibility(g_CostumeModelBack[id], 0)
	   g_CostumeModelBack[id] = 0
	}

        case 2:
	{
	   fm_set_entity_visibility(g_CostumeModelHead[id], 0)
	   g_CostumeModelHead[id] = 0
	}

        case 3:
	{
	   fm_set_entity_visibility(g_CostumeModelPelvis[id], 0)
	   g_CostumeModelPelvis[id] = 0
	}

        case 4:
	{
	   fm_set_entity_visibility(g_CostumeModelBack2[id], 0)
	   g_CostumeModelBack2[id] = 0
	}
    }
}

//Stock
stock print_colorchat(id, String[], any:...)
{
    new SzMsg[192]
    vformat(SzMsg, charsmax(SzMsg), String, 3)
     
    replace_all(SzMsg, charsmax(SzMsg), "!n", "^1")
    replace_all(SzMsg, charsmax(SzMsg), "!t", "^3")
    replace_all(SzMsg, charsmax(SzMsg), "!g", "^4")
     
    static msgSayText = 0
    static fake_user
     
    if(!msgSayText)
    {
        msgSayText = get_user_msgid("SayText")
        fake_user = get_maxplayers() + 1
    }
     
    message_begin(id ? MSG_ONE_UNRELIABLE : MSG_BROADCAST, msgSayText, _, id)
    write_byte(id ? id : fake_user)
    write_string(SzMsg)
    message_end()
}