# Hunter's Time Left Addon
#  
# Install instructions:
#       1. Install Mattie's EventScripts 2.0 plugin:
#           http://mattie.info/cs/
#
#       2. Copy and upload this script to:
#           <gamedir>/addons/eventscripts/time_left/
#
#       3. Add the following line somewhere in autoexec.cfg:
#           es_load time_left
#
################################################################################
#import EventScripts
import es
#import Libraries
import gamethread
import keyvalues
import langlib
import playerlib
import settinglib
import time
#import Psyco Compiler
import psyco
psyco.full()

# Addon Information
info = es.AddonInfo()
info.name = "Time Left"
info.version = "3.0.0"
info.author = "Hunter"
info.url = "http://addons.eventscripts.com/addons/user/289"
info.description = "Shows the remaining time on a map"
info.basename = "time_left"

hunter_time_left_ver      = info.version
hunter_time_left_text     = 'Hunters '+info.name+', www.sourceplugins.de, '+info.version+', ES 2.0.0.247+ (Python Version)'

# Server Variables
time_left_savetime        = es.ServerVar('time_left_savetime', '30', 'How much days should inactive users be stored, before their settings get deleted? ( default = 30 )')
time_left_soundload       = es.ServerVar('time_left_soundload', '1', 'Should the sounds be downloaded with EventScripts?')
time_left_endmap          = es.ServerVar('time_left_endmap', '1', 'Should the map end after the timelimit is reached?')
time_left_default_text    = es.ServerVar('time_left_default_text', '1', 'Default settings for new connecting players')
time_left_default_sound   = es.ServerVar('time_left_default_sound', '1', 'Default settings for new connecting players')
time_left_show_amx        = es.ServerVar('time_left_show_amx', '1', 'Show remaining time in HLSW? (AMX Variable)')
time_left_show_cm         = es.ServerVar('time_left_show_cm', '0', 'Show remaining time in HLSW? (CM Variable)')

# Global Variables
time_left_starttime       = int(time.time())
time_left_roundend        = True
time_left_mp_timelimit    = es.ServerVar('mp_timelimit')
time_left_language        = langlib.Strings(es.getAddonPath('time_left')+'/time_left.ini')

# KeyValues Object
time_left_kv              = keyvalues.KeyValues(name='time_left')

# Settinglib Object
time_left_setting         = settinglib.create('timeleft', 'Time Left Settings', 'toggle')

def load():
    public = es.ServerVar('hu_bt', info.version, info.name)
    public.makepublic()

    time_left_kv.load(es.getAddonPath('time_left')+'/time_left.txt')

    time_left_setting.addoption('text', 'Szoveg')
    time_left_setting.addoption('sound', 'Hang')
    time_left_setting.setdefault('text', int(time_left_default_text))
    time_left_setting.setdefault('sound', int(time_left_default_sound))
    time_left_setting.addsound('ui/buttonclick.wav')
    
    gamethread.delayedname(1, 'time_left', time_ticker)

    es.regsaycmd('!times', 'time_left/saycmd', 'Time Left Settings')
    es.regsaycmd('!timeleft', 'time_left/saycmd_timeleft', 'Time Left Information')
    es.regsaycmd('!thetime', 'time_left/saycmd_thetime', 'Current Time Information')
    es.log(hunter_time_left_text)
    es.msg('#multi', '#green[TimeLeft] #default Bekapcsolva')
    
def unload():
    gamethread.cancelDelayed('time_left')

    es.unregsaycmd('!times')
    es.unregsaycmd('!timeleft')
    es.unregsaycmd('!thetime')
    es.msg('#multi', '#green[TimeLeft] #defaultKikapcsolva')
    
def es_map_start(event_var):
    global time_left_starttime, time_left_roundend
    time_left_setting.clear(int(time_left_savetime)*86400)
    time_left_starttime = int(time.time())
    time_left_roundend = True
    gamethread.cancelDelayed('time_left')
    gamethread.delayedname(1, 'time_left', time_ticker)
    if int(time_left_soundload):
        for keyname in time_left_kv:
            if str(keyname)[:6] == 'sounds':
                for soundname in time_left_kv[str(keyname)]:
                    es.stringtable('downloadables', 'sound/'+str(time_left_kv[str(keyname)][str(soundname)]))

def es_client_command(event_var):
    if (str(event_var['command']) == '!hunter_time_left_ver') or (str(event_var['command']) == '!hunter_all_ver'):
        es.cexec(int(event_var['userid']), 'echo '+hunter_time_left_text)

def player_activate(event_var):
    time_left_setting.updateTime(int(event_var['userid']))
    gamethread.delayed(30, es.cexec, (int(event_var['userid']), 'echo '+hunter_time_left_text))
    gamethread.delayed(15, es.tell, (int(event_var['userid']), '#multi', '#green[TimeLeft] #defaultIrd a chatbe hogy \'!times\' a beallitasok menuert!'))

def player_disconnect(event_var):
    time_left_setting.updateTime(int(event_var['userid']))

def time_ticker():
    global time_left_starttime
    gamethread.delayedname(1, 'time_left', time_ticker)
    remaining = int(int(time_left_mp_timelimit)*60) - int(int(time.time()) - time_left_starttime)
    if remaining >= 0:
        _run_time(str(remaining))
    else:
        userid = int(es.getuserid())
        es.ServerCommand('es_xgive '+str(userid)+' game_end')
        es.ServerCommand('es_xfire '+str(userid)+' game_end EndGame')

def round_start(event_var):
    global time_left_starttime, time_left_roundend
    if time_left_roundend:
        time_left_roundend = False
    else:
        time_left_starttime = int(time.time())

def round_end(event_var):
    global time_left_roundend
    gamethread.cancelDelayed('time_left')
    if int(event_var['reason']) == 16:
        time_left_roundend = False
    else:
        time_left_roundend = True

def saycmd():
    time_left_setting.send(int(es.getcmduserid()))

def saycmd_timeleft():
    global time_left_starttime
    remaining = int(int(time_left_mp_timelimit)*60) - int(int(time.time()) - time_left_starttime)
    timestring = _format_timeleft(remaining)
    es.msg('#multi', '#green[TimeLeft] #lightgreen'+str(timestring)+' #defaultmaradt hatra!')
    
def saycmd_thetime():
    timestring = time.strftime('%a, %d %b %Y %H:%M:%S #lightgreen%Z')
    es.msg('#multi', '#green[TimeLeft] #defaultAz ido: #green'+str(timestring))

def _format_timeleft(ticker):
    minutes = int(int(ticker) / 60)
    seconds = int(int(ticker) - int(minutes * 60))
    if minutes < 10:
        minutes = '0'+str(minutes)
    else:
        minutes = str(minutes)
    if seconds < 10:
        seconds = '0'+str(seconds)
    else:
        seconds = str(seconds)
    timestring = str(minutes)+':'+str(seconds)
    return timestring

def _run_time(ticker):
    timestring = _format_timeleft(ticker)
    if int(time_left_show_amx):
        amx_timeleft = es.ServerVar('amx_timeleft')
        amx_timeleft.set(timestring)
        amx_timeleft.makepublic()
    if int(time_left_show_cm):
        cm_timeleft = es.ServerVar('cm_timeleft')
        cm_timeleft.set(timestring)
        cm_timeleft.makepublic()
    if str(ticker) in time_left_kv['commands'].keys():
        command = str(time_left_kv['commands'][str(ticker)])
        if (';' in command):
            commandlist = command.split(';')
            for command in commandlist:
                es.ServerCommand(command.strip())
        else:
            es.ServerCommand(command.strip())
    useridlist = playerlib.getUseridList('#human')
    for userid in useridlist:
        if time_left_setting.get('text', userid):
            if 'timeleft_'+str(ticker) in time_left_language.keys():
                player = playerlib.getPlayer(userid)
                soundtext = time_left_language('timeleft_'+str(ticker), {}, player.get("lang"))
                es.tell(userid, '#multi', soundtext)
        if time_left_setting.get('sound', userid):
            if int(es.getplayerteam(userid)) < 2:
                keyname = 'sounds_spec'
            elif int(es.getplayerteam(userid)) == 2:
                keyname = 'sounds_t'
            elif int(es.getplayerteam(userid)) == 3:    
                keyname = 'sounds_ct'
            if str(ticker) in time_left_kv[str(keyname)].keys():
                soundfile = str(time_left_kv[str(keyname)][str(ticker)])
                es.playsound(userid, soundfile, 1.0)
