﻿import es, random, cfglib, playerlib

config = cfglib.AddonCFG(es.getAddonPath('headbuff') + "/headbuff.cfg")

config.text(' _   _                _______        __  __ ')
config.text('| | | |              | | ___ \\      / _|/ _|')
config.text('| |_| | ___  __ _  __| | |_/ /_   _| |_| |_ ')
config.text('|  _  |/ _ \\/ _` |/ _` | ___ \\ | | |  _|  _|')
config.text('| | | |  __/ (_| | (_| | |_/ / |_| | | | |  ')
config.text('\\_| |_/\\___|\\__,_|\\__,_\\____/ \\__,_|_| |_|  ')
config.text(' ')
config.text('1 = enabled, 0 = disabled')
headbuff_enabled	= config.cvar('headbuff_enabled',	1, 'Enable/disable HeadBuff')
msg_enabled			= config.cvar('msg_enabled',		1, 'Enable/disable the message sent when a player gets a buff')
config.text(' ')
config.text(' ')
config.text('To disable any of the buffs enter 0 as the amount.')
health_amount		= config.cvar('health_amount',		30, 'How much health should be given by the health buff? Default is 30')
armor_amount		= config.cvar('armor_amount',		50, 'How much armor should be given by the armor buff? Default is 50')
ammo_amount			= config.cvar('ammo_amount',		50, 'How much ammo should be given by the ammo buff? Default is 50')
speed_amount		= config.cvar('speed_amount',		2.0, 'Which speed should be given by the speed buff? Default is 2.0')
gravity_amount		= config.cvar('gravity_amount',		0.5, 'Which gravity should be given by the gravity buff? Default is 0.5')
cash_amount			= config.cvar('cash_amount',		2000, 'How much cash should be given by the cash buff? Default is 2000')

config.text(' ')
config.text(' ')
default_speed		= config.cvar('default_speed',		1, 'What is the default server speed?')
default_gravity		= config.cvar('default_gravity',	1, "What is the default server gravity? It's not the same as sv_gravity, '1' is normal")

config.write()

info = es.AddonInfo()
info.name			= 'HeadBuff'
info.version		= '1.3'
info.author			= 'Fault aka Immortal, Steam - Faultx'
info.basename		= 'headbuff'
info.description	= 'If a player gets a headshot, he is rewarded with a random buff'

es.ServerVar(info.basename, info.version, info.description).makepublic()

buffs = {
        'élet':health_amount,
        'páncél':armor_amount,
        'lőszer':ammo_amount,
        'gyorsaság':speed_amount,
        'gravitáció':gravity_amount,
		'pénz':cash_amount
        } 

def load():
	config.execute()
	
def player_death(ev):
	if headbuff_enabled and ev['attacker'] and int(ev['headshot']):
		player = playerlib.getPlayer(ev['attacker'])
			
		buff = random.choice([x for x in filter(lambda x: buffs[x], buffs)])
		if buff == 'élet':
			player.health += buffs[buff]
		elif buff == 'páncél':
			player.armor += buffs[buff]
		elif buff == 'pénz':
			player.cash += buffs[buff]
		elif buff == 'lőszer':
			if player.getPrimary():
				player.ammo.primary += buffs[buff]
			if player.getSecondary():
				player.ammo.secondary += buffs[buff]
		elif buff == 'gravitáció':
			es.server.queuecmd('est_setgravity %s %s'%(ev['attacker'],buffs[buff]))
		elif buff == 'gyorsaság':
			player.speed = buffs[buff]
		if msg_enabled:
			es.msg("#multi", " #green%s #default Kapott #green %s #defaultjutalmat, #lightgreen(%s)-t #default,mert fejbelőtt valakit!" % (player.name, buff, buffs[buff]))

def player_spawn(ev):
	playerlib.getPlayer(ev['userid']).set('speed', default_speed)
	es.server.queuecmd('est_setgravity %s %s'%(ev['userid'],default_gravity))