﻿# -*- coding:Utf-8 -*- #

###########################################################
# Name: Radio Messages Editor                             #
# Version: 1337                                           #
# Author: Devilsnake88                                    #
#                                                         #
# Add-on for TrikzMe Servers                              #
# Thanks to 101satoon101 for optimization/revised add-on! #
# Thanks for downloading!                                 ###################
#                                                                           #
# * Recommendations *                                                       #
#    For a better optimisation, please follow instructions:                 #
#       - I recommend to use a mirror (FastDL) server                       #
#       and                                                                 #
#       - compress any sound format ".bz2" using "bzip2-105-x86-win32.exe"  #
# ______ __________           ___                                 _____     #
#/\   __\\__    __/       ___/\  \             /¯¯\_/¯¯\         /\__  \    #    
#\ \  \/ \/_/\  \/ _____ /\__\ \  \/¯\   _____/\        \    ____\/_/\  \   # 
# \ \  \    \ \  \/\   __\/\  \ \    <__/\__  \ \  \__\  \  /  __ \ \ \  \  # 
#  \ \  \_   \ \  \ \  \/ \ \  \ \  \\  \/_/  /_ \  \_/\  \/\  ___/  \_\  \ # 
#   \ \___\   \ \__\ \__\  \ \__\ \__\\__\ \____\ \__\\ \__\ \____\  /\____\# 
#    \/___/    \/__/\/__/   \/__/\/__/\/__//____/\/__/ \/__/\/____/  \/____/# 
#                                                                           #
#              Copyright © All Rights Reserved to DevilSnake88              #
#############################################################################

import es, playerlib

defaultsoundDir = 'magyar_radio/'
defaultsoundList = [
	'fedezz',
	'ellenseg_halott',
	'bemerve',
	'visszavonulas',
	'kovess',
	'tartsd_es_varj',
	'robban',
	'gyerunk',
	'tartsd',
	'helyemen',
	'segitsetek',
	'negative',
	'alakzatba',
	'jelentest',
	'korulnezek',
	'megerositem',
	'tiszta',
	'maradjunk_egyutt',
	'rohamra',
	'foglaldel',
	'tuzet_nyitottak'
]
persosoundDir = 'magyar_radio/' #Your personnal directory on /cstrike/sound/ folder
persosoundList = [         #Your personnal sounds on format ['sound1', 'sound2']
	'bemerve'             #Don't put file extension (.mp3, .wav, ...)
]
radio = {
	#'coverme': {'text': 'Fuck me!', 'sound': 'headshot'}, # Your personnal sound here with NO extensions
	'coverme': {'text': 'Fedezz!', 'sound': 'fedezz'}, # Default sound
	'enemydown': {'text': 'Az ellenség halott!', 'sound': 'ellenseg_halott'},
	'enemyspot': {'text': 'Ellenség bemérve!', 'sound': 'bemerve'},
	'fallback': {'text': "Fiúk, vissza vonulás!", 'sound': 'visszavonulas'},
	'followme': {'text': 'Kövess!', 'sound': 'kovess'},
	'getinpos': {'text': 'Tartsd a pocíziót és várj meg ott!', 'sound': 'tartsd_es_varj'},
	'getout': {'text': 'Mennyetek onnan, felfog robbani!', 'sound': 'robban'},
	'go': {'text': 'Gyerünk, gyerünk, mozgás!', 'sound': 'gyerunk'},
	'holdpos': {'text': 'Tartsd a pocíziót!', 'sound': 'tartsd'},
	'inposition': {'text': "A helyemen vagyok!", 'sound': 'helyemen'},
	'needbackup': {'text': 'Segítsetek!', 'sound': 'segitsetek'},
	'negative': {'text': 'Negatív', 'sound': 'negative'},
	'regroup': {'text': 'Alakzatba fiúk!', 'sound': 'alakzatba'},
	'report': {'text': 'Jelentést fiúk!', 'sound': 'jelentest'},
	'reportingin': {'text': 'Körülnétek!', 'sound': 'korulnezek'},
	'roger': {'text': 'Megerősítem.', 'sound': 'megerositem'},
	'sectorclear': {'text': 'A szektor tiszta!', 'sound': 'tiszta'},
	'sticktog': {'text': 'Fiúk, maradjunk együtt!', 'sound': 'maradjunk_egyutt'},
	'stormfront': {'text': 'ROHAMRA!', 'sound': 'rohamra'},
	'takepoint': {'text': 'Foglald el a helyed!', 'sound': 'foglaldel'},
	'takingfire': {'text': 'Tüzet nyitottak, SEGÍTSETEK!', 'sound': 'tuzet_nyitottak'}
}
colors = {2: '#green', 3: '#default'}

def load():
	es.addons.registerClientCommandFilter(radioeditor)

def unload():
	es.addons.unregisterClientCommandFilter(radioeditor) 

def es_map_start(ev):
	for index in persosoundList: #Searching for all sound names on persosoundList
		es.stringtable('downloadables', 'sound/%s%s.wav' %(persosoundDir, index)) #Add to download list at player connexion
		
		es.stringtable('downloadables', 'sound/magyar_radio/alakzatba.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/bemerve.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/ellenseg_halott.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/fedezz.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/foglaldel.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/gyerunk.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/helyemen.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/jelentest.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/korulnezek.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/kovess.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/maradjunk_egyutt.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/megerositem.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/negative.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/robban.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/rohamra.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/segitsetek.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/tartsd.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/tartsd_es_varj.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/tiszta.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/tuzet_nyitottak.wav')
		es.stringtable('downloadables', 'sound/magyar_radio/visszavonulas.wav')

		
	
def radioeditor(userid, args):
	command = args[0].lower()
	player = playerlib.getPlayer(userid)
	if not command in radio:
		return True
	radiosound = radio[command]['sound']
	if not player.team in colors:
		return True
	es.msg('#multi', '%s%s #default(RADIO): %s' % (colors[player.team], player.name, radio[command]['text']))
	if radiosound in defaultsoundList: #If radio sound is on defaultsoundList (default radio sounds)
		es.cexec_all('play', '%s%s.wav' % (defaultsoundDir, radiosound))
	elif radiosound in persosoundList: #If radio sound is on persosoundList (your personnal radio sounds)
		es.cexec_all('play', '%s%s.wav' % (persosoundDir, radiosound))
	else: #If you did one error, Script show you this message ->
		es.msg('#multi', '#green[Radio Editor#green]#lightgreen There is a problem, please check your personnal modifications!\n #green"%s" not found!'%radiosound)
	return False