
""" Imports """
# ------------
# EventScripts Core-Module      - ES functionality
# ------------
import es

""" Global Variables """
# ------------
# This player-dictionary will hold everyone's round-stats
# ------------
player = {}

""" Class - Player """
# ------------
# This class will manage all the players' names, kills, headshots, hits and damage
# ------------
class Player(object):
    def __init__(self, userid):
        self.userid = userid
        self.name = self.kills = self.hs = self.hits = self.damage = 0
    def hurt(self, damage):
        self.hits += 1
        self.damage += damage
    def death(self, hs):
        self.kills += 1
        if hs:
            self.hs += 1
    def reset(self):
        self.kills = self.hs = self.hits = self.damage = 0

""" Instance - getPlayer """
# ------------
# Rather call this instance instead of the class itself
# ------------
def getPlayer(userid):
    if es.exists('userid', userid):
        return Player(userid)
    raise ValueError, 'Userid %s does not exist!' % userid

""" Events """
# ------------
# Add the connected player to the player-dictionary
# ------------
def player_activate(ev):
    userid = ev['userid']
    player[userid] = getPlayer(userid)

# ------------
# Reset every the spawning player's name in the player-dictionary
# ------------
def player_spawn(ev):
    userid = ev['userid']
    if int(ev['es_userteam']) > 1 and userid in player:
        player[userid].name = ev['es_username']

# ------------
# Add one hit and the damage to the player's info
# ------------
def player_hurt(ev):
    attacker = ev['attacker']
    if int(attacker):
        player[attacker].hurt(int(ev['dmg_health']))

# ------------
# Add one kill to the player's info, if it's a headshot, add one headshot, too
# ------------
def player_death(ev):
    attacker = ev['attacker']
    if int(attacker):
        player[attacker].death(int(ev['headshot']))

# ------------
# Delete the player off the dictionary whenever he/she leaves
# ------------
def player_disconenct(ev):
    del player[ev['userid']]

# ------------
# Sort out "Most Kills", "Most Headshots" and "Most Damage" and announce it
# ------------
def round_end(ev):
    if int(ev['winner']) in (2, 3):
        winkills = sorted(player, key=lambda userid: player[userid].kills, reverse=True)[0]
        windamage = sorted(player, key=lambda userid: player[userid].damage, reverse=True)[0]
        winhs = sorted(player, key=lambda userid: player[userid].hs, reverse=True)[0]
        kills = player[winkills].kills
        damage = player[windamage].damage
        hits = player[windamage].hits
        hs = player[winhs].hs
        if kills:
            name = es.getplayername(winkills)
            es.msg('#multi', '#lightgreen[#lightgreenKILL-MONITOR#green] #defaultLegtobbet olt: #green%s #lightgreen- #default%s' % (name, kills))
            if kills == es.getplayercount(2 if es.getplayerteam(winkills) == 3 else 3):
                es.msg('#multi', '#green[#lightgreenKILL-MONITOR#green] #defaultCsapat bash: #green%s' % name)
        if hs:
            es.msg('#multi', '#green[#lightgreenKILL-MONITOR#green] #defaultLegtobb fejloves: #green%s #lightgreen- #default%s' % (es.getplayername(winhs), hs))
        if damage and hits:
            es.msg('#multi', '#green[#lightgreenKILL-MONITOR#green] #defaultLegtobbet sebzo: #green%s #lightgreen- #default%s (%s Hit%s)' % (es.getplayername(windamage), damage, hits, '' if hits == 1 else 's'))
        for userid in player:
            player[userid].reset()

""" EventScripts main-control functions """
# ------------
# Add every player to the player-dictionary and set the current version on load
# ------------
def load():
    es.ServerVar('roundstats_ver', '1.2').makepublic()
    for userid in es.getUseridList():
        userid = str(userid)
        player[userid] = getPlayer(userid)

# ------------
# Clean-up: clear the player-dictionary on load
# ------------
def unload():
    player.clear()

""" End Code """
