# -*- coding:Utf-8 -*-


# ==================================================
# >> IMPORTATIONS
# ==================================================


import es

import os
import re
import random

import psyco
psyco.full()


# ==================================================
# >> INFORMATIONS
# ==================================================


g_informations = es.AddonInfo()
g_informations["name"] = "Parachute by L'In20Cible"
g_informations["version"] = "1.3"
g_informations["date"] = "2010-05-10"
g_informations["author"] = "L\'in20Cible"
g_informations["url"] = "http://addons.eventscripts.com/addons/view/parachute/"
g_informations["basename"] = "parachute"

es.ServerVar("pc_version", (g_informations["version"] + " by " + g_informations["author"])).makepublic()


# ==================================================
# >> GLOBALES
# ==================================================


g_options = {
   "enable": ("1", "pc_enable <1/0> -- Active/Désactive le parachute."),
   "admins": ("0", "pc_admins <1/0> -- Active/Désactive la restriction du parachute aux joueurs qui ne sont pas administrateurs."),
   "models": ("0", "pc_models <1/0> -- Active/Désactive les apparences du parachute.")
   }
for option in g_options:
   g_options[option] = es.ServerVar(("pc_" + option), g_options[option][0], g_options[option][1])
   
eventscripts_gamedir = str(es.ServerVar("eventscripts_gamedir")).replace(os.sep, "/")
est_enable_peruserkeyevents = es.ServerVar("est_enable_peruserkeyevents")


# ==================================================
# >> INITIALISATION
# ==================================================


def load():
   Initialization()
   if (str(est_enable_peruserkeyevents) == "0"):
      est_enable_peruserkeyevents.set("1")
   es.addons.registerTickListener(TickListenerCallBack)
      
      
def Initialization():
   global g_admins, g_models, g_players
   path = GetConfigurationFilePath("")
   if not os.path.isdir(path):
      os.mkdir(path)
   path = GetConfigurationFilePath("configuration.cfg")
   if os.path.isfile(path):
      es.mexec(path.replace(eventscripts_gamedir, ".."))
   g_admins = GetConfigurationFileParsed(GetConfigurationFilePath("admins.txt"))
   g_models = GetConfigurationFileParsed(GetConfigurationFilePath("models.txt"))
   if (str(es.ServerVar("eventscripts_currentmap")) == ""):
      return
   for line in GetConfigurationFileParsed(GetConfigurationFilePath("downloads.txt")):
      if not os.path.isfile(os.path.join(eventscripts_gamedir, line).replace(os.sep, "/")):
         continue
      es.stringtable("downloadables", line)
   g_players = list()
   est_enable_peruserkeyevents.addFlag("notify")
   
   
def unload():
   est_enable_peruserkeyevents.removeFlag("notify")
   es.mexec("../cfg/es_tools.cfg")
   es.addons.unregisterTickListener(TickListenerCallBack)
   
   
# ==================================================
# >> UTILITAIRES
# ==================================================
   
   
def GetConfigurationFileParsed(path):
   lines = list()
   if not os.path.isfile(path):
      return lines
   regex = re.compile("//.*|^(( |\t)+)|(( |\t)+)$|(\r)+|(\n)+")
   for line in open(path):
      line = regex.sub("", line).strip()
      if not line:
         continue
      lines.append(line)
   return lines
   
   
def GetConfigurationFilePath(file):
   return os.path.join(str(es.ServerVar("eventscripts_addondir")), g_informations["basename"], "configuration", file).replace(os.sep, "/")
   
   
def SetPlayerParachuteLocation(userid, origin):
   if not int(g_options["models"]) or not len(g_models):
      return
   commands = [
      "es_xfire %i parachute_%i ADDOUTPUT \"origin %s %s %s\"" % (userid, userid, origin[0], origin[1], origin[2]),
      "es_xfire %s parachute_%i ADDOUTPUT \"angles 0 %s 0\"" % (userid, userid, es.getplayerprop(userid, "CCSPlayer.m_angEyeAngles[1]"))
      ]
   for command in commands:
      es.server.queuecmd(command)
      
      
def OpenPlayerParachute(userid):
   if not int(g_options["enable"]) or (int(g_options["admins"]) and es.getplayersteamid(userid) not in g_admins) or (userid in g_players):
      return
   if (es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_Local.m_flFallVelocity") > 0.0) and not (es.getplayerprop(userid, "CBaseEntity.movetype") == -65527):
      g_players.append(userid)
      es.server.queuecmd("es_xfire %i !self ADDOUTPUT \"gravity 0.1\"" % userid)
      es.server.queuecmd("est_physpush %i %s %s %s" % (userid, es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_vecVelocity[0]"), es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_vecVelocity[1]"), (es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_Local.m_flFallVelocity") + es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_vecVelocity[2]"))))
      if not int(g_options["models"]) or not len(g_models):
         return
      commands = [
         "es_xprop_physics_create %i props/cs_office/water_bottle.mdl" % userid,
         "es est_setentname server_var(eventscripts_lastgive) parachute_%i" % userid,
         "es_setindexprop server_var(eventscripts_lastgive) \"CBaseEntity.m_nModelIndex\" %i" % es.precachemodel(random.choice(g_models)),
         "es_setindexprop server_var(eventscripts_lastgive) \"CBaseEntity.m_clrRender\" -1",
         "es_setindexprop server_var(eventscripts_lastgive) \"CBaseEntity.m_CollisionGroup\" 2",
         "es_setindexprop server_var(eventscripts_lastgive) \"CBaseEntity.movetype\" 0"
         ]
      for command in commands:
         es.server.queuecmd(command)
      SetPlayerParachuteLocation(userid, es.getplayerlocation(userid))
      
      
def ClosePlayerParachute(userid):
   if (userid not in g_players):
      return
   g_players.remove(userid)
   es.server.queuecmd("es_xfire %i !self ADDOUTPUT \"gravity 1.0\"" % userid)
   if not int(g_options["models"]) or not len(g_models):
      return
   es.server.queuecmd("es_xfire %i parachute_%i kill" % (userid, userid))
   
   
# ==================================================
# >> FONCTIONS D'APPEL
# ==================================================


def TickListenerCallBack():
   for userid in es.getUseridList():
      if (userid in g_players):
         if (str(es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_hGroundEntity")) <> "-1") or (str(es.getplayerprop(userid, "CBaseEntity.movetype")) == "-65527") or (str(es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_nWaterLevel")) == "1"):
            ClosePlayerParachute(userid)
         else:
            SetPlayerParachuteLocation(userid, es.getplayerlocation(userid))
      elif es.isbot(userid):
         OpenPlayerParachute(userid)
      
            
            
# ==================================================
# >> ÉVÉNEMENTS
# ==================================================


def es_map_start(event_var):
   Initialization()
   
   
def player_death(event_var):
   ClosePlayerParachute(int(event_var["userid"]))
   
   
def player_disconnect(event_var):
   ClosePlayerParachute(int(event_var["userid"]))
   
   
def server_cvar(event_var):
   if (event_var["cvarname"].lower() == "est_enable_peruserkeyevents"):
      if (event_var["cvarvalue"] == "1"):
         return
      es.set("est_enable_peruserkeyevents", "1")
      
      
def player_jump(event_var):
   es.server.queuecmd("es_xfire %i !self ADDOUTPUT \"gravity 1.0\"" % int(event_var["userid"]))
   
   
def est_client_keypress(event_var):
   if not int(g_options["enable"]) or not (event_var["keyname"].lower() =="use"):
      return
   if (int(event_var["status"]) == 1):
      OpenPlayerParachute(int(event_var["userid"]))
   else:
      ClosePlayerParachute(int(event_var["userid"]))