import es

info = es.AddonInfo() 
info.name = 'Anti Retry' 
info.version = '1.0.2' 
info.url = 'http://forums.mattie.info/cs/forums/viewtopic.php?t=24766' 
info.basename = 'anti_retry' 
info.author = 'Sc0pE'
es.ServerVar('anti_retry_ver',info.version,' By: Sc0pE').makepublic()

dead_players = []
disc_players = []
enabled = 1

def load():
    es.msg('#multi', '#green[#lightgreenAnti Retry#green]#default Loaded')

def unload():
    es.msg('#multi', '#green[#lightgreenAnti Retry#green]#default Unloaded')

def round_end(ev):
    global dead_players, disc_players, enabled
    enabled = 0
    dead_players = []
    disc_players = []

def round_start(ev):
    global enabled
    enabled = 1

def player_disconnect(ev):
    if enabled:
        if ev['reason'] == 'Disconnect by user.':
            disc_players.append(ev['es_steamid'])

def player_death(ev):
    if enabled:
        dead_players.append(ev['es_steamid'])

def player_spawn(ev):
    userid = ev['userid']
    if not es.getplayerprop(userid, "CBasePlayer.pl.deadflag"):
        steamid = ev['es_steamid']
        if steamid in dead_players and steamid in disc_players:
            es.setplayerprop(userid, "CBasePlayer.m_iHealth", 0)
            es.server.queuecmd('es_xfire %s !self ignite' % userid) 
            es.msg('#multi', '#green[#lightgreenAnti Retry#green] #lightgreen%s#default was slayed for playing the same round twice' % ev['es_username'])