# ./addons/eventscripts/existsscript/existsscript.py
# ES 2.0+

import es
import keyvalues # Only required for the ESS commands


""" Functions that may be used in other addons """

def exists_script(script_name):
   """ Returns True if the script is loaded otherwise returns False """
   # Check if it's a loaded script
   if es.exists('script', script_name):
      return True
   # Check if it's a loaded addon
   for module in es.addons.getAddonList():
      if module.__name__.rsplit('.', 1)[0].replace('.', '/') == script_name:
         return True
   # Guess it's not loaded
   return False


def createscriptlist_python(script_name=None):
   """ Returns a dictionary populated with ESS and ESP addons """
   if script_name:
      # If it's an ESS addon this will return the result we are after
      # If it's an ESP addon this will return an empty dictionary
      scriptlist = es.createscriptlist(script_name)
      if not scriptlist and exists_script(script_name):
         # If exists_script is True we know it's a loaded ESP addon so
         # we simply add the key to our empty dictionary
         scriptlist[script_name] = {'status':'enabled', 'type':'py'}

   else:
      # This creates a list of loaded ESS addon or returns an empty dictionary
      scriptlist = es.createscriptlist()

      # Now we loop through each ESP addon and add it to the existing dictionary
      for module in es.addons.getAddonList():
         module_name = module.__name__.rsplit('.', 1)[0].replace('.', '/')
         if module_name not in scriptlist:
            # We know the type is PY and ESP addons can't de disabled as of yet
            # so the status must be "enabled"
            scriptlist[module_name] = {'status':'enabled', 'type':'py'}

   return scriptlist


""" Functions for this addon's functionality """

def existsscript_cmd():
   """ existsscript <return var> <script name> """
   if es.getargc() == 3:
      es.ServerVar(es.getargv(1)).set(int(exists_script(es.getargv(2))))
   else:
      es.dbgmsg(0, 'Syntax: existsscript <return var> <script name>')
if not es.exists('command', 'existsscript'):
   es.regcmd('existsscript', 'existsscript/existsscript_cmd', 'existsscript <return var> <script name>\nReturns nonzero if the script is loaded')


def createscriptlistpython_cmd():
   """ createscriptlistpython <keygroup> [script name] """
   if es.getargc() in (2, 3):
      # Create the return keygroup
      keygroup_name = es.getargv(1)
      es.keygroupcreate(keygroup_name)
      kv_output  = keyvalues.getKeyGroup(keygroup_name)

      # Generate a dictionary of addons and convert that to the
      # keygroup created earlier
      scriptlist = createscriptlist_python(es.getargv(2))
      for script in scriptlist:
         kv_output[script] = keyvalues.KeyValues(name=script)
         script_info = scriptlist[script]
         for keyvalue in script_info:
            kv_output[script][keyvalue] = script_info[keyvalue]
   else:
      es.dbgmsg(0, 'Syntax: createscriptlistpython <keygroup> [script name]')
if not es.exists('command', 'createscriptlistpython'):
   es.regcmd('createscriptlistpython', 'existsscript/createscriptlistpython_cmd', 'createscriptlistpython <keygroup> [script name]\nReturns a keygroup of loaded addons')