"""
//******************************
//Sn4k3 Paint Ball (SPB)
//	for Counter-Strike: Source
//
//* Requires:
//
//	Mattie EventScripts v2.0.0.242+
//	ES_Tools Plugin by Awuh0 v.416d+
//
//* Description:
//
//	Paint Ball Mod
//	
//
//* Install instructions:
//     1. Install Mattie's EventScripts plugins:
//         http://mattie.info/cs
//
//     2. Copy and upload this script to:
//         cstrike/addons/eventscripts/spb/spb.py
//
//     3. Add the following line somewhere in autoexec.cfg:
//         es_load spb
//
//*Credits
//
//sn4k3 -> Script Developer
//
//
//Suport: MSN : Tiago_caza@hotmail.com
//*************************************
"""

import es
import random
import gamethread

# all SPB server variables are declared here for convenience 
spb_version	  				= es.ServerVar("spb_version",			2.1, "Current SPB version.") 
spb	  						= es.ServerVar("spb",					1, "Is SPB loaded or not.") 
spb_enable	  				= es.ServerVar("spb_enable",			1, "Turn SPB ON or OFF in any time.") 
spb_decal_time	  			= es.ServerVar("spb_decal_time",		2.0, "How much time the effect stay.") 
spb_blue_effect_scale  		= es.ServerVar("spb_blue_effect_scale",		0, "Blue tint scale.") 
spb_lightblue_effect_scale	= es.ServerVar("spb_lightblue_effect_scale",	0, "Lightblue tint scale.") 
spb_red_effect_scale  		= es.ServerVar("spb_red_effect_scale",		0, "Red tint scale.") 
spb_green_effect_scale 		= es.ServerVar("spb_green_effect_scale",	0, "Green tint scale.") 
spb_lightblue_effect_scale	= es.ServerVar("spb_lightblue_effect_scale",	0, "Lightblue tint scale.") 
spb_yellow_effect_scale		= es.ServerVar("spb_yellow_effect_scale",	0, "Yellow tint scale.") 

spb_use_team_colors		= es.ServerVar("spb_use_team_colors",		0, "Allow use blue tint to CTs and red tint to Ts.") 
spb_bots_can_use		= es.ServerVar("spb_bots_can_use",		0, "Allow bots use paintball.") 

#_spb_coord			= es.ServerVar("_spb_coord",			0, "Player Detection.") 

info = es.AddonInfo() 
info.name     = "Sn4k3 PaintBall" 
info.basename = "SPB" 
info.version  	= str(spb_version)
info.url      = "http://addons.eventscripts.com/addons/view/SPB" 
info.description = "A PaintBall mod for SourceGames"
info.author   = "sn4k3" 
#info.contact  	= "Tiago_caza@hotmail.com"
#info.tags = "spb;paintball,effects"

_spb_opt = {}
_spb_opt['game_options'] = {}
_spb_opt['game_options']['path'] = es.getAddonPath("spb") + "/"
_spb_opt['game_options']['game_path'] = str(es.ServerVar('eventscripts_gamedir')) 
_spb_opt['game_options']['config_path'] = _spb_opt['game_options']['path'] + "cfg/"
_spb_opt['game_options']['config_short_path'] = "addons/eventscripts/spb/cfg/"
_spb_opt['game_options']['data_path'] = _spb_opt['game_options']['path'] + "data/"
_spb_opt['tint'] = {}
_spb_opt['tint'][0] = "spb/spb_shot1.vmt" ## Red
_spb_opt['tint'][1] = "spb/spb_shot2.vmt" ## Blue
_spb_opt['tint'][2] = "spb/spb_shot3.vmt" ## Green
_spb_opt['tint'][3] = "spb/spb_shot5.vmt" ## LigthGreen
_spb_opt['tint'][4] = "spb/spb_shot6.vmt" ## Yellow
_spb_opt['tint'][5] = "spb/spb_shot7.vmt" ## LigthBlue
_spb_opt['cvars'] = {}
_spb_opt['cvars'][0] = "spb_red_effect_scale"
_spb_opt['cvars'][1] = "spb_blue_effect_scale"
_spb_opt['cvars'][2] = "spb_green_effect_scale"
_spb_opt['cvars'][3] = "spb_green_effect_scale"
_spb_opt['cvars'][4] = "spb_yellow_effect_scale"
_spb_opt['cvars'][5] = "spb_lightblue_effect_scale"

def requirements():
	if not es.exists("variable", "est_version"):
		return False
	return True

def reset(isLoad = False):
	es.stringtable("downloadables", "materials/spb/spb_shot1.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot1.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot2.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot2.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot3.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot3.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot5.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot5.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot6.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot6.vmt")
	es.stringtable("downloadables", "materials/spb/spb_shot7.vtf")
	es.stringtable("downloadables", "materials/spb/spb_shot7.vmt")
	es.set("est_enable_est_bullet_impact", 1)

def load():
	spb_version.makepublic()
	spb.makepublic()
	spb_enable.makepublic()
	spb.set(1)
	
	if not requirements():
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "----------------SPB----------------")
		es.dbgmsg(0, "Eventscripts (ES): PASSED [%s]" % str(es.ServerVar("eventscripts_ver")))
		es.dbgmsg(0, "EsTools (EST):     FAIL")
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "Script will be unloaded, because not meat the REQUIREMENTS!")
		es.dbgmsg(0, "Please repair or load missing requirement if you haveit")
		es.dbgmsg(0, "Fail requirement can be downloaded at:")
		es.dbgmsg(0, "http://forums.mattie.info/cs/forums/viewtopic.php?t=3413")
		es.dbgmsg(0, "----------------SPB----------------")
		es.dbgmsg(0, " ")
		es.server.queuecmd("es_unload svip")
		return False

	es.mexec("spb/spb_server.cfg")
	es.server.cmd("es_xmexec ../%sspb_server.cfg;es_xmexec ../%son_load.cfg" % (_spb_opt['game_options']['config_short_path'], _spb_opt['game_options']['config_short_path']))

	if len(str(es.ServerVar('eventscripts_currentmap'))) > 3:
		reset(True)

def unload():
	spb.set(0)
	es.server.cmd("es_xmexec ../%son_unload.cfg" % _spb_opt['game_options']['config_short_path'])

def player_activate(event_var):
	if int(spb_enable) > 0 and event_var['es_steamid'] != "BOT":
		gamethread.delayed(10, spb_delayed_funcs, event_var['userid'])

def es_map_start(event_var):
	reset()
	es.server.cmd("es_xmexec ../%son_newmap.cfg" % _spb_opt['game_options']['config_short_path'])
	
def est_bullet_impact(event_var):
	if int(spb_enable) <= 0:
		return
	if event_var['es_steamid'] == "BOT" and int(spb_bots_can_use) > 0 or event_var['es_steamid'] != "BOT":
		color = 0
		if int(spb_use_team_colors) > 0:
			color = int(event_var['es_userteam'])-2
		else:
			color = random.randint(0,5)
		es.server.cmd("est_Effect_23 #h 0 %s \"%s %s %s\" %s %s 255" % (_spb_opt['tint'][color], event_var['x'], event_var['y'], event_var['z'], spb_decal_time, es.ServerVar(_spb_opt['cvars'][color])))

def spb_delayed_funcs(userid):
	if es.exists("userid", userid):
		es.tell(userid, "\x04SPB:\x01 Source Games\x03 PaintBall\x01 Mod, version: \x03%s\n\x04SPB:\x01 Written By:\x03 sn4k3\x01 AKA\x03 Tiago Conceicao\n\x04Visit:\x01 http://addons.eventscripts.com/addons/view/SPB\n" % (info.version))