# IPToCountry plda David Bowland
# ./addons/eventscripts/iptocountry_example/iptocountry_example.py

# >>> Konfigurlshoz ez addon lsd iptocountry_example.cfg <<<

"" "
Plda addon a IPToCountry knyvtr.
Ignyel csak ES 2.1+
"" "


import cfglib
import cmdlib
import es
import langlib
import playerlib
import ideje
import usermsg

import iptocountry

import psyco
psyco.full ()

tjbl import tvonal


info = es.AddonInfo ()
info.name = 'IPToCountry plda "
info.version = "3"
info.basename = 'iptocountry_example'
info.url = 'http://addons.eventscripts.com/addons/view/iptocountry'
info.author = 'SuperDave'
info.database = 'http://software77.net/geo-ip/'


addonpath = path (es.getAddonPath (info.basename))

###

config = cfglib.AddonCFG (addonpath.joinpath (info.basename + '.cfg'))

config.text (info.name + "kiads% s opci '% info.version)
config.text (./ addons / eventscripts /% (basename) s /% (basename) s.cfg '% {' basename ": info.basename})
config.text (info.url)
config.text ( '')
config.text (Load ez addon az: es_load '+ info.basename)
config.text ( '\ n')
config.text (konfigurlshoz nyelvbelltsait% s olvassa% s_languages.ini '% (info.name, info.basename))
config.text ( '\ n')
config.text ( 'Ez a plda addon:')
config.text ( '- Megmutatja pldul klcsnhats IPToCountry)
config.text ( '- Automatikusan frissti a IPToCountry adatbzis)
config.text ( '- bemutatja az orszg csatlakozott jtkosok)
config.text ( '- Biztostja szerver parancsokat interakci ESS szkriptek)
config.text (- Rengeteg IPToCountry gyorsabb adatbzis-hozzfrs egyb mellkletek)
config.text ( "Mivel a nagy mret adatbzis, akkor _HIGHLY_ ajnlott ez addon lehet betlteni kzben szerver indtsnl vagy trkpen vltozs.)
config.text ( '')
config.text ( 'Az adatbzis a IPToCountry knyvtr adta: http://Software77.net)
config.text ( '')
config.text (NO vonatkoz lltsokat pontossgra vonatkoz adatbzisban. Hasznlja a IPToCountry knyvtr ezt szem eltt tartva. ")
config.text ( '')
config.text (Tovbbi informcik itt tallhatk: http://software77.net/geo-ip/)
config.text ( '\ n')

config.text (***** Update belltsainak *****)
config.text ( "Ez a plda addon csak frissti az adatbzist, ha nincs jtkos csatlakozik miatt kapcsoldsi problmk.)
cvar_update_days = config.cvar (iptocountry_example_update_days ', 14' napok szma kztti adatbzis frisstsek - a 0 megszntetse)
cvar_update_load = config.cvar (iptocountry_example_update_load ', 0' 0 = nincs vltozs, 1 = update database valahnyszor ipcountry_example van tltve (nem ajnlott) ")
config.text ( '\ n')

config.text (***** Hirdetmnyben lehetsgek *****)
cvar_announce_chat = config.cvar (iptocountry_example_announce_chat ', 2' 0 = nincs vltozs, 1 = be a konzolon az orszg minden jtkos csatlakozik re, 2 = bejelenti chat terlet az orszg minden jtkos csatlakozik re)
cvar_announce_center = config.cvar (iptocountry_example_announce_center ', 1,' 0 = nincs vltozs, 1 = be a kzpont szveges orszgban minden jtkos csatlakozik re)
cvar_announce_hud = config.cvar (iptocountry_example_announce_hud ', 0' 0 = nincs vltozs, 1 = be a HUD zenet az orszg minden jtkos csatlakozik re)
config.text ( '\ n')

config.text (***** Command dokumentci *****)
config.text ( '')
config.text ( "Ez addon a kvetkez szerver parancsokat: ')
config.text ( '')
config.text (iptocountry_getcountry <orszg var> <abbr var> < "ip"> ')
config.text (- Visszatr orszg nevt s hrombets rvidtse info a megadott IP)
config.text ( "orszg var - Vltoz neve kapni orszg neve)
config.text (rv var - Vltoz neve kapni orszg hrombets rvidts)
config.text (IP - IP-cm megoldani orszgra informci)
config.text ( '')
config.text (iptocountry_getinfo <var> <info tpus> < "ip"> ')
config.text ( '- Visszaadja helyt info a megadott IP)
config.text (var - A vltoz neve, hogy megkapja helyt inforation)
config.text (info tpus - Type informcit kapni (ip_from / ip_to / nyilvntartsi / kijellt / country_2 / country_3 / country_long) ")
config.text (IP - IP-cm megoldani orszgra informci)
config.text ( '')
config.text (iptocountry_getlastupdate <var> ')
config.text ( '- Visszaadja az id az utols adatbzis frissts (Unix id) ")
config.text (var - Vltoz neve kapni idejn utols frissts)
config.text ( '')
config.text (iptocountry_updatedata [ "url"] ")
config.text ( '- Szinkronizlja az adatbzist az internetes adatbzis)
config.text ( "Ezt a parancsot nem hasznlhat, mikzben jtkos csatlakozik!)
config.text ( 'url - (nem ktelez) URL adatbzis letlthet)
config.text ( '')
config.text (iptocountry_updatefrompath [ "path"] ")
config.text ( '- Szinkronizlja az adatbzist a helyi adatbzis)
config.text ( "Ezt a parancsot nem hasznlhat, mikzben jtkos csatlakozik!)
config.text (path - (nem ktelez) tvonala adatbzis fjl szerver knyvtr)
config.text (Alaprtkek: /addons/eventscripts/_libs/python/IPToCountry.csv)

config.write ()

###

ini = cfglib.AddonINI (addonpath.joinpath (info.basename + '_languages.ini'))

ini.setInitialComments ([
"# ./addons/eventscripts/%(basename)s/%(basename)s_languages.ini '% {' Basename": info.basename},
"# >>> ltalnos addon konfigurci lsd" + info.basename + ".cfg <<<"
'',
"# NE lefordtani szavakat $ vagy # eltt!",
"# A listt a nyelvi rvidtsek lsd ./addons/eventscripts/_libs/python/deflangs.ini '])

ini.addGroup ( "Connect")
ini.addValueToGroup ( "connect", "en", "# vilgoszld $ name # mulaszts bektsre # vilgoszld $ location # default".)
ini.addValueToGroup ( "connect", "fr", "# vilgoszld $ name # default vient de # vilgoszld $ location # default".)
ini.addValueToGroup ( "connect", "de", "# vilgoszld $ name # default kommt aus # vilgoszld $ location # default".)
ini.addValueToGroup ( "connect", "pt", "# vilgoszld $ name # default se Conecto de # vilgoszld $ location # default".)
ini.addValueToGroup ( "connect", "es", "# vilgoszld $ name # default se ha conectado desde # vilgoszld $ location # default".)
ini.addValueToGroup ( "connect", "nl", "# vilgoszld $ name # default KOMT uit # vilgoszld $ location # default".)
ini.addValueToGroup ( "Connect", "fi", "# vilgoszld $ name # alaprtelmezs liittynyt peliin maasta # vilgoszld $ location # default".)

ini.write ()


lang_text = langlib.Strings (INI)

def remove_tags (szveg):
"" "Eltvoltja #lightgreen, #darkgreen, #green s #default cmkket a mellkelt" "szveg"
visszatr cskkentse (lambda T, R: t.replace (r, ''), ( '#lightgreen', '#darkgreen', '#green "," #default'), szveg)

###

def load ():
"" "
Biztostja a kritikus szerver vltozk ltal ltrehozott config
Frissti az adatbzist, ha szksges
"" "
config.execute ()

ha cvar_update_load:
data_update ()
ms:
try_update ()

ha nem iptocountry.get_last_update ():
es.dbgmsg (0, 'IPToCountry Plda: Error, nem adatbzis betltve! ")


def round_end (event_var):
"" "Kri try_update frissteni az adatbzist, ha nincs emberi jtkos" ""
try_update ()


def player_connect (event_var):
"" "Bejelenti a csatlakoz lejtsz orszga" ""
ha event_var [ 'networkid'] == 'BOT ":
visszatrs

token = { 'name': event_var [ 'name'], 'hely': iptocountry.get_country (event_var [ 'cm']) [0]}
beszlgetni = int (cvar_announce_chat)
center = int (cvar_announce_center)
hud = int (cvar_announce_hud)

es.dbgmsg (0, remove_tags (lang_text ( "connect", zsetonok)))

A felhasznli azonost a es.getUseridList ():
text = lang_text ( "Connect", zsetonok, playerlib.getPlayer (userid) Szlljon (lang '))

Ha beszlgets:
Ha csevegs == 2:
es.tell (userid "#multi", szveg)
ms:
usermsg.echo (userid, remove_tags (szveg))
ha kzponttl:
es.centertell (userid, remove_tags (szveg))
ha hud:
usermsg.hudhint (userid, remove_tags (szveg))


def player_disconnect (event_var):
"" "Kri try_update frissteni az adatbzist, ha a jtkos volt az utols ember a szerver" ""
try_update ()


def kirak ():
cmdlib.unregisterServerCommand ( 'iptocountry_getcountry')
cmdlib.unregisterServerCommand ( 'iptocountry_getinfo')
cmdlib.unregisterServerCommand ( 'iptocountry_getlastupdate')
cmdlib.unregisterServerCommand ( 'iptocountry_updatedata')
cmdlib.unregisterServerCommand ( 'iptocountry_updatefrompath')

A cvar a config.getCvars ():
es.ServerVar (cvar) .set (0)

###

def try_update ():
"" "Felhvja data_update ha az adatok a szksges letkor s nem az emberek vannak ktve" ""
update_days = float (cvar_update_days)
ha update_days s nem playerlib.getPlayerList (# humn):
ha time.time () - iptocountry.get_last_update ()> update_days * 86400:
data_update ()


def data_update ():
"" "Frissti a IPToCountry adatbzis" ""
es.dbgmsg (0, 'IPToCountry Plda: frisstse IPToCountry adatbzis)

ha iptocountry.update_data ():
es.dbgmsg (0, 'IPToCountry Plda: Frissts teljes)
ms:
es.dbgmsg (0, 'IPToCountry Plda: Error frisstse adatbzis! ")

###

def country_cmd (args):
"" "
iptocountry_getcountry <orszg var> <abbr var> < "ip">
Visszaadja az orszg nevt s hrombets rvidtse trstott IP szerver vltozk
"" "
ha len (args) == 3:
info = iptocountry.get_country (args [2])

es.ServerVar (args [0]). szett (info [0])
es.ServerVar (args [1]). szett (info [1])

ms:
es.dbgmsg (0, "Syntax: iptocountry_getcountry <orszg var> <abbr var> <" ip "> ')

cmdlib.registerServerCommand (iptocountry_getcountry "country_cmd,
"Iptocountry_getcountry <orszg var> <abbr var> <" ip "> \ n tr vissza az orszg nevt s hrombets rvidtse trstott IP szerver vltozk)


def info_cmd (args):
"" "
iptocountry_getinfo <var> <info tpus> < "ip">
Visszaadja helyre vonatkoz informcik a VI
"" "
ha len (args) == 3:
info_type = args [1] .lower ()
data = iptocountry.get_location_data (args [2])

ha data.has_key (info_type):
es.ServerVar (args [0]). szett (data [info_type])

ms:
es.dbgmsg (0, 'IPToCountry Plda: Info tpus "% s" nem tallhat "% args [1])
ms:
es.dbgmsg (0, "Syntax: iptocountry_getinfo <var> <info tpus> <" ip "> ')

cmdlib.registerServerCommand (iptocountry_getinfo "info_cmd,
"Iptocountry_getinfo <var> <info tpus> <" ip "> \ nReturns helyre vonatkoz informcik VI)


def lastupdate_cmd (args):
"" "
iptocountry_getlastupdate <var>
Visszaadja az id az utols IPToCountry adatbzis frissts
"" "
ha len (args) == 1:
es.ServerVar (args [0]). szett (iptocountry.get_last_update ())

ms:
es.dbgmsg (0, "Syntax: iptocountry_getlastupdate <var> ')

cmdlib.registerServerCommand (iptocountry_getlastupdate "lastupdate_cmd,
"Iptocountry_getlastupdate <var> \ nReturns Unix id az utols IPToCountry adatbzis frissts)


def updatedata_cmd (args):
"" "
iptocountry_updatedata [ "url"]
Szinkronizlja az adatbzist az internetes adatbzis
"" "
ha len (args) (0, 1):
ha len (args) == 1:
siker = iptocountry.update_data (args [0])
ms:
siker = iptocountry.update_data ()

ha siker:
es.dbgmsg (0, 'IPToCountry Plda: Adatbzis sikeresen frisstve)
ms:
es.dbgmsg (0, 'IPToCountry Plda: Error frisstse adatbzis: "+ str (siker))
ms:
es.dbgmsg (0, "Syntax: iptocountry_updatedata [" url "]")

cmdlib.registerServerCommand (iptocountry_updatedata "updatedata_cmd,
"Iptocountry_updatedata [" url "] \ nSyncs az adatbzist az internetes adatbzis)


def updatefrompath_cmd (args):
"" "
iptocountry_updatefrompath < "path">
Szinkronizlja az adatbzist a helyi adatbzis
"" "
ha len (args) == 1:
siker = iptocountry.update_from_file (args [0])
ha siker:
es.dbgmsg (0, 'IPToCountry Plda: Adatbzis sikeresen frisstve)
ms:
es.dbgmsg (0, 'IPToCountry Plda: Error frisstse adatbzis: "+ str (siker))
ms:
es.dbgmsg (0, "Syntax: iptocountry_updatefrompath <" path "> ')

cmdlib.registerServerCommand (iptocountry_updatefrompath "updatefrompath_cmd,
"Iptocountry_updatefrompath <" path "> \ nSyncs az adatbzis egy helyi adatbzis)
