/* Plugin Template generated by Pawn Studio */

#include <sourcemod>
#include <sdktools>

public Plugin:myinfo = 
{
	name = "New Plugin",
	author = "Unknown",
	description = "<- Description ->",
	version = "1.0",
	url = "www.devzone.cn"
}

enum {
	kill_1,
	kill_2,
	kill_3,
	kill_4,
	kill_5,
	kill_headshot,
	kill_knife,
	kill_hegrenade,
	kill_inferno,
	kill_taser
};

new String:SND_KILLVOICE[][] = {"vox/first.wav","vox/double.wav",
"vox/third.wav","vox/forth.wav","vox/perfect.wav","vox/headshot.wav",
"vox/knife.wav","vox/grenade.wav","vox/inferno.wav","vox/taser.wav"};

new String:NAME_OVERLAYS[][] = {"overlays/kill/kill_1","overlays/kill/kill_2",
"overlays/kill/kill_3","overlays/kill/kill_4","overlays/kill/kill_5","overlays/kill/kill_headshot",
"overlays/kill/kill_knife","overlays/kill/kill_hegrenade","overlays/kill/kill_inferno","overlays/kill/kill_taser"};

new Handle:g_taskCountdown[33] = INVALID_HANDLE,Handle:g_taskClean[33] = INVALID_HANDLE;
new g_killCount[33] = 0,g_iMaxClients = 0;
new bool:g_bShowAuthor[33] = false;

public OnPluginStart()
{
	// Add your own code here...
	HookEvent("player_death", Event_PlayerDeath);
	HookEvent("round_start", Event_round_start,EventHookMode_Post);
}

public OnMapStart()
{
	for(new i = 0;i<sizeof(SND_KILLVOICE);i++)
		PrecacheSound(SND_KILLVOICE[i]);
	
	AddFolderToDownloadsTable("materials/overlays/kill");
	AddFolderToDownloadsTable("sound/vox");
	
	ServerCommand("sv_cheats 1");
	g_iMaxClients = GetMaxClients();
}

public Event_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	new victim = GetClientOfUserId(GetEventInt(event, "userid"))
	new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));
	new bool:headshot = GetEventBool(event, "headshot");
	new String:weapon[32];
	GetEventString(event, "weapon",weapon, sizeof(weapon));
	
	g_killCount[victim] = 0;
	if(g_taskCountdown[victim] !=INVALID_HANDLE)
	{
		KillTimer(g_taskCountdown[victim]);
		g_taskCountdown[victim] =INVALID_HANDLE;
	}
	
	if(attacker <1 || attacker == victim )
		return;
	
	if(IsFakeClient(attacker) || GetEntityTeam(attacker) == GetEntityTeam(victim))
		return;
	
	if(g_killCount[attacker] <5) 
		g_killCount[attacker]++;
	
	if(g_taskCountdown[attacker] !=INVALID_HANDLE)
	{
		KillTimer(g_taskCountdown[attacker]);
		g_taskCountdown[attacker] =INVALID_HANDLE;
	}
	g_taskCountdown[attacker] = CreateTimer(2.0,task_Countdown,attacker,1);
	
	if(g_killCount[attacker] == 1)
	{
		if(StrEqual(weapon,"hegrenade"))
			ShowKillMessage(attacker,kill_hegrenade);
		else if(StrEqual(weapon,"knife"))
			ShowKillMessage(attacker,kill_knife);
		else if(StrEqual(weapon,"inferno"))
			ShowKillMessage(attacker,kill_inferno);
		else if(StrEqual(weapon,"taser"))
			ShowKillMessage(attacker,kill_taser);
		else if(headshot)
			ShowKillMessage(attacker,kill_headshot);
		else
			ShowKillMessage(attacker,kill_1);
	}
	else 
		ShowKillMessage(attacker,g_killCount[attacker]-1);
	
	if(g_taskClean[attacker] !=INVALID_HANDLE)
	{
		KillTimer(g_taskClean[attacker]);
		g_taskClean[attacker] =INVALID_HANDLE;
	}
	g_taskClean[attacker] = CreateTimer(3.0,task_Clean,attacker);
}

public Event_round_start(Handle:event,const String:name[],bool:dontBroadcast)
{
	for(new client=1;client <= g_iMaxClients;client++)
	{
		g_killCount[client] = 0;
		if(g_taskCountdown[client] !=INVALID_HANDLE)
		{
			KillTimer(g_taskCountdown[client]);
			g_taskCountdown[client] =INVALID_HANDLE;
		}

		g_bShowAuthor[client] = GetRandomInt(1,3)==1 ? true : false;
		//PrintToConsole(1,"CCC %d",client);
	}
}

public Action:task_Countdown(Handle:Timer, any:client)
{
	g_killCount[client] --;
	if(!IsPlayerAlive(client) || g_killCount[client]==0)
	{
		KillTimer(Timer);
		g_taskCountdown[client] = INVALID_HANDLE;
	}
}

public Action:task_Clean(Handle:Timer, any:client)
{
	KillTimer(Timer);
	g_taskClean[client] = INVALID_HANDLE;
	
	//if(!IsPlayerUseZoomWeapon(client)&&IsClientZooming(client))
		//return;
	ClientCommand(client, "r_screenoverlay \"\"");
}

public ShowKillMessage(client,type)
{
		
	EmitSoundToClient(client,SND_KILLVOICE[type],SOUND_FROM_PLAYER,SNDCHAN_VOICE);
	//ClientCommand(client, "playgamesound \"%s\"",SND_KILLVOICE[type])
	
	ClientCommand(client, "r_screenoverlay \"%s\"",NAME_OVERLAYS[type]);
	
	if(g_bShowAuthor[client])
	{
		g_bShowAuthor[client] = false;
		ShowKeyHintText(client,"  ﻿欢迎使用CS:GO杀敌提 -By fs_wTong www.devzone.cn");
	}
}

public OnClientConnected(client)
{
	ClientCommand(client,"r_drawscreenoverlay 1");
}

public OnClientDisconnect_Post(client)
{
	if(g_taskCountdown[client] !=INVALID_HANDLE)
	{
		KillTimer(g_taskCountdown[client]);
		g_taskCountdown[client] =INVALID_HANDLE;
	}
	
	if(g_taskClean[client] !=INVALID_HANDLE)
	{
		KillTimer(g_taskClean[client]);
		g_taskClean[client] =INVALID_HANDLE;
	}
}

public ShowKeyHintText(client,String:sMessage[])
{
	new Handle:hBuffer = StartMessageOne("KeyHintText", client); 
	if(hBuffer==INVALID_HANDLE)
		return;
	BfWriteByte(hBuffer, 1); 
	BfWriteString(hBuffer,sMessage); 
	EndMessage();
}


stock GetEntityTeam(entity)
{
	return GetEntProp(entity, Prop_Send, "m_iTeamNum");
}

stock AddFolderToDownloadsTable(const String:sDirectory[])
{
	decl String:sFile[64], String:sPath[512];
	new FileType:iType, Handle:hDir = OpenDirectory(sDirectory);
	while(ReadDirEntry(hDir, sFile, sizeof(sFile), iType))     
	{
		if(iType == FileType_File)
		{
			Format(sPath, sizeof(sPath), "%s/%s", sDirectory, sFile);
			AddFileToDownloadsTable(sPath);
		}
	}
}